/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class AreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final int TIME_BETWEEN_APPLICATIONS = 5;
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.defineId(AreaEffectCloud.class, EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.defineId(AreaEffectCloud.class, EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.defineId(AreaEffectCloud.class, EntityDataSerializers.PARTICLE);
    private static final float MAX_RADIUS = 32.0f;
    private static final int DEFAULT_AGE = 0;
    private static final int DEFAULT_DURATION_ON_USE = 0;
    private static final float DEFAULT_RADIUS_ON_USE = 0.0f;
    private static final float DEFAULT_RADIUS_PER_TICK = 0.0f;
    private static final float DEFAULT_POTION_DURATION_SCALE = 1.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    public static final int INFINITE_DURATION = -1;
    public static final int DEFAULT_LINGERING_DURATION = 600;
    private static final int DEFAULT_WAIT_TIME = 20;
    private static final int DEFAULT_REAPPLICATION_DELAY = 20;
    private static final ColorParticleOption DEFAULT_PARTICLE = ColorParticleOption.create(ParticleTypes.ENTITY_EFFECT, -1);
    @Nullable
    private ParticleOptions customParticle;
    public PotionContents potionContents = PotionContents.EMPTY;
    private float potionDurationScale = 1.0f;
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = -1;
    public int waitTime = 20;
    public int reapplicationDelay = 20;
    public int durationOnUse = 0;
    public float radiusOnUse = 0.0f;
    public float radiusPerTick = 0.0f;
    @Nullable
    private EntityReference<LivingEntity> owner;

    public AreaEffectCloud(EntityType<? extends AreaEffectCloud> entitytypes, Level world) {
        super(entitytypes, world);
        this.noPhysics = true;
    }

    public AreaEffectCloud(Level world, double d0, double d1, double d2) {
        this((EntityType<? extends AreaEffectCloud>)EntityType.AREA_EFFECT_CLOUD, world);
        this.setPos(d0, d1, d2);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_RADIUS, Float.valueOf(3.0f));
        datawatcher_a.define(DATA_WAITING, false);
        datawatcher_a.define(DATA_PARTICLE, DEFAULT_PARTICLE);
    }

    public void setRadius(float f) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, Float.valueOf(Mth.clamp(f, 0.0f, 32.0f)));
        }
    }

    @Override
    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    public float getRadius() {
        return this.getEntityData().get(DATA_RADIUS).floatValue();
    }

    public void setPotionContents(PotionContents potioncontents) {
        this.potionContents = potioncontents;
        this.updateParticle();
    }

    public void setCustomParticle(@Nullable ParticleOptions particleparam) {
        this.customParticle = particleparam;
        this.updateParticle();
    }

    public void setPotionDurationScale(float f) {
        this.potionDurationScale = f;
    }

    public void updateParticle() {
        if (this.customParticle != null) {
            this.entityData.set(DATA_PARTICLE, this.customParticle);
        } else {
            int i = ARGB.opaque(this.potionContents.getColor());
            this.entityData.set(DATA_PARTICLE, ColorParticleOption.create(DEFAULT_PARTICLE.getType(), i));
        }
    }

    public void addEffect(MobEffectInstance mobeffect) {
        this.setPotionContents(this.potionContents.withEffectAdded(mobeffect));
    }

    public ParticleOptions getParticle() {
        return this.getEntityData().get(DATA_PARTICLE);
    }

    protected void setWaiting(boolean flag) {
        this.getEntityData().set(DATA_WAITING, flag);
    }

    public boolean isWaiting() {
        return this.getEntityData().get(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int i) {
        this.duration = i;
    }

    @Override
    public void inactiveTick() {
        super.inactiveTick();
        if (this.tickCount >= this.waitTime + this.duration) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
            return;
        }
    }

    @Override
    public void tick() {
        super.tick();
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.serverTick(worldserver);
        } else {
            this.clientTick();
        }
    }

    private void clientTick() {
        boolean flag = this.isWaiting();
        float f = this.getRadius();
        if (!flag || !this.random.nextBoolean()) {
            float f1;
            int i;
            ParticleOptions particleparam = this.getParticle();
            if (flag) {
                i = 2;
                f1 = 0.2f;
            } else {
                i = Mth.ceil((float)Math.PI * f * f);
                f1 = f;
            }
            for (int j = 0; j < i; ++j) {
                float f2 = this.random.nextFloat() * ((float)Math.PI * 2);
                float f3 = Mth.sqrt(this.random.nextFloat()) * f1;
                double d0 = this.getX() + (double)(Mth.cos(f2) * f3);
                double d1 = this.getY();
                double d2 = this.getZ() + (double)(Mth.sin(f2) * f3);
                if (particleparam.getType() == ParticleTypes.ENTITY_EFFECT) {
                    if (flag && this.random.nextBoolean()) {
                        this.level().addAlwaysVisibleParticle(DEFAULT_PARTICLE, d0, d1, d2, 0.0, 0.0, 0.0);
                        continue;
                    }
                    this.level().addAlwaysVisibleParticle(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                    continue;
                }
                if (flag) {
                    this.level().addAlwaysVisibleParticle(particleparam, d0, d1, d2, 0.0, 0.0, 0.0);
                    continue;
                }
                this.level().addAlwaysVisibleParticle(particleparam, d0, d1, d2, (0.5 - this.random.nextDouble()) * 0.15, 0.01f, (0.5 - this.random.nextDouble()) * 0.15);
            }
        }
    }

    private void serverTick(ServerLevel worldserver) {
        if (this.duration != -1 && this.tickCount - this.waitTime >= this.duration) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            boolean flag1;
            boolean flag = this.isWaiting();
            boolean bl = flag1 = this.tickCount < this.waitTime;
            if (flag != flag1) {
                this.setWaiting(flag1);
            }
            if (!flag1) {
                float f = this.getRadius();
                if (this.radiusPerTick != 0.0f) {
                    if ((f += this.radiusPerTick) < 0.5f) {
                        this.discard(EntityRemoveEvent.Cause.DESPAWN);
                        return;
                    }
                    this.setRadius(f);
                }
                if (this.tickCount % 5 == 0) {
                    this.victims.entrySet().removeIf(entry -> this.tickCount >= (Integer)entry.getValue());
                    if (!this.potionContents.hasEffects()) {
                        this.victims.clear();
                    } else {
                        ArrayList list = new ArrayList();
                        PotionContents potioncontents = this.potionContents;
                        Objects.requireNonNull(list);
                        potioncontents.forEachEffect(list::add, this.potionDurationScale);
                        List<LivingEntity> list1 = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox());
                        if (!list1.isEmpty()) {
                            ArrayList<org.bukkit.entity.LivingEntity> entities = new ArrayList<org.bukkit.entity.LivingEntity>();
                            for (LivingEntity entityliving : list1) {
                                double d1;
                                double d0;
                                double d2;
                                if (this.victims.containsKey(entityliving) || !entityliving.isAffectedByPotions()) continue;
                                Stream stream = list.stream();
                                Objects.requireNonNull(entityliving);
                                if (stream.noneMatch(entityliving::canBeAffected) || !((d2 = (d0 = entityliving.getX() - this.getX()) * d0 + (d1 = entityliving.getZ() - this.getZ()) * d1) <= (double)(f * f))) continue;
                                entities.add((org.bukkit.entity.LivingEntity)entityliving.getBukkitEntity());
                            }
                            AreaEffectCloudApplyEvent event = CraftEventFactory.callAreaEffectCloudApplyEvent(this, entities);
                            if (!event.isCancelled()) {
                                for (org.bukkit.entity.LivingEntity entity : event.getAffectedEntities()) {
                                    if (!(entity instanceof CraftLivingEntity)) continue;
                                    LivingEntity entityliving = ((CraftLivingEntity)entity).getHandle();
                                    this.victims.put(entityliving, this.tickCount + this.reapplicationDelay);
                                    for (MobEffectInstance mobeffect : list) {
                                        if (mobeffect.getEffect().value().isInstantenous()) {
                                            mobeffect.getEffect().value().applyInstantenousEffect(worldserver, this, this.getOwner(), entityliving, mobeffect.getAmplifier(), 0.5);
                                            continue;
                                        }
                                        entityliving.addEffect(new MobEffectInstance(mobeffect), this, EntityPotionEffectEvent.Cause.AREA_EFFECT_CLOUD);
                                    }
                                    if (this.radiusOnUse != 0.0f) {
                                        if ((f += this.radiusOnUse) < 0.5f) {
                                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                            return;
                                        }
                                        this.setRadius(f);
                                    }
                                    if (this.durationOnUse == 0 || this.duration == -1) continue;
                                    this.duration += this.durationOnUse;
                                    if (this.duration > 0) continue;
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float f) {
        this.radiusOnUse = f;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float f) {
        this.radiusPerTick = f;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int i) {
        this.durationOnUse = i;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int i) {
        this.waitTime = i;
    }

    public void setOwner(@Nullable LivingEntity entityliving) {
        this.owner = entityliving != null ? new EntityReference<LivingEntity>(entityliving) : null;
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        return EntityReference.get(this.owner, this.level(), LivingEntity.class);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        this.tickCount = valueinput.getIntOr("Age", 0);
        this.duration = valueinput.getIntOr("Duration", -1);
        this.waitTime = valueinput.getIntOr("WaitTime", 20);
        this.reapplicationDelay = valueinput.getIntOr("ReapplicationDelay", 20);
        this.durationOnUse = valueinput.getIntOr("DurationOnUse", 0);
        this.radiusOnUse = valueinput.getFloatOr("RadiusOnUse", 0.0f);
        this.radiusPerTick = valueinput.getFloatOr("RadiusPerTick", 0.0f);
        this.setRadius(valueinput.getFloatOr("Radius", 3.0f));
        this.owner = EntityReference.read(valueinput, "Owner");
        this.setCustomParticle(valueinput.read("custom_particle", ParticleTypes.CODEC).orElse(null));
        this.setPotionContents(valueinput.read("potion_contents", PotionContents.CODEC).orElse(PotionContents.EMPTY));
        this.potionDurationScale = valueinput.getFloatOr("potion_duration_scale", 1.0f);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        valueoutput.putInt("Age", this.tickCount);
        valueoutput.putInt("Duration", this.duration);
        valueoutput.putInt("WaitTime", this.waitTime);
        valueoutput.putInt("ReapplicationDelay", this.reapplicationDelay);
        valueoutput.putInt("DurationOnUse", this.durationOnUse);
        valueoutput.putFloat("RadiusOnUse", this.radiusOnUse);
        valueoutput.putFloat("RadiusPerTick", this.radiusPerTick);
        valueoutput.putFloat("Radius", this.getRadius());
        valueoutput.storeNullable("custom_particle", ParticleTypes.CODEC, this.customParticle);
        EntityReference.store(this.owner, valueoutput, "Owner");
        if (!this.potionContents.equals(PotionContents.EMPTY)) {
            valueoutput.store("potion_contents", PotionContents.CODEC, this.potionContents);
        }
        if (this.potionDurationScale != 1.0f) {
            valueoutput.putFloat("potion_duration_scale", this.potionDurationScale);
        }
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        if (DATA_RADIUS.equals(datawatcherobject)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    public PushReaction getPistonPushReaction() {
        return PushReaction.IGNORE;
    }

    @Override
    public EntityDimensions getDimensions(Pose entitypose) {
        return EntityDimensions.scalable(this.getRadius() * 2.0f, 0.5f);
    }

    @Override
    public final boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        return false;
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.POTION_CONTENTS ? AreaEffectCloud.castComponentValue(datacomponenttype, this.potionContents) : (datacomponenttype == DataComponents.POTION_DURATION_SCALE ? AreaEffectCloud.castComponentValue(datacomponenttype, Float.valueOf(this.potionDurationScale)) : super.get(datacomponenttype));
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
        this.applyImplicitComponentIfPresent(datacomponentgetter, DataComponents.POTION_CONTENTS);
        this.applyImplicitComponentIfPresent(datacomponentgetter, DataComponents.POTION_DURATION_SCALE);
        super.applyImplicitComponents(datacomponentgetter);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.POTION_CONTENTS) {
            this.setPotionContents(AreaEffectCloud.castComponentValue(DataComponents.POTION_CONTENTS, t0));
            return true;
        }
        if (datacomponenttype == DataComponents.POTION_DURATION_SCALE) {
            this.setPotionDurationScale(AreaEffectCloud.castComponentValue(DataComponents.POTION_DURATION_SCALE, t0).floatValue());
            return true;
        }
        return super.applyImplicitComponent(datacomponenttype, t0);
    }
}

