/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.storage.loot.LootTable;

public record EquipmentTable(ResourceKey<LootTable> lootTable, Map<EquipmentSlot, Float> slotDropChances) {
    public static final Codec<Map<EquipmentSlot, Float>> DROP_CHANCES_CODEC = Codec.either((Codec)Codec.FLOAT, (Codec)Codec.unboundedMap(EquipmentSlot.CODEC, (Codec)Codec.FLOAT)).xmap(var0 -> (Map)var0.map(EquipmentTable::createForAllSlots, Function.identity()), var0 -> {
        boolean var1 = var0.values().stream().distinct().count() == 1L;
        boolean var2 = var0.keySet().containsAll(EquipmentSlot.VALUES);
        if (var1 && var2) {
            return Either.left((Object)var0.values().stream().findFirst().orElse(Float.valueOf(0.0f)));
        }
        return Either.right((Object)var0);
    });
    public static final Codec<EquipmentTable> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)LootTable.KEY_CODEC.fieldOf("loot_table").forGetter(EquipmentTable::lootTable), (App)DROP_CHANCES_CODEC.optionalFieldOf("slot_drop_chances", Map.of()).forGetter(EquipmentTable::slotDropChances)).apply((Applicative)var0, EquipmentTable::new));

    public EquipmentTable(ResourceKey<LootTable> var0, float var1) {
        this(var0, EquipmentTable.createForAllSlots(var1));
    }

    private static Map<EquipmentSlot, Float> createForAllSlots(float var0) {
        return EquipmentTable.createForAllSlots(List.of(EquipmentSlot.values()), var0);
    }

    private static Map<EquipmentSlot, Float> createForAllSlots(List<EquipmentSlot> var0, float var1) {
        HashMap var2 = Maps.newHashMap();
        for (EquipmentSlot var4 : var0) {
            var2.put(var4, Float.valueOf(var1));
        }
        return var2;
    }
}

