/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public enum Relative {
    X(0),
    Y(1),
    Z(2),
    Y_ROT(3),
    X_ROT(4),
    DELTA_X(5),
    DELTA_Y(6),
    DELTA_Z(7),
    ROTATE_DELTA(8);

    public static final Set<Relative> ALL;
    public static final Set<Relative> ROTATION;
    public static final Set<Relative> DELTA;
    public static final StreamCodec<ByteBuf, Set<Relative>> SET_STREAM_CODEC;
    private final int bit;

    @SafeVarargs
    public static Set<Relative> union(Set<Relative> ... var0) {
        HashSet<Relative> var1 = new HashSet<Relative>();
        for (Set<Relative> var5 : var0) {
            var1.addAll(var5);
        }
        return var1;
    }

    private Relative(int var2) {
        this.bit = var2;
    }

    private int getMask() {
        return 1 << this.bit;
    }

    private boolean isSet(int var0) {
        return (var0 & this.getMask()) == this.getMask();
    }

    public static Set<Relative> unpack(int var0) {
        EnumSet<Relative> var1 = EnumSet.noneOf(Relative.class);
        for (Relative var5 : Relative.values()) {
            if (!var5.isSet(var0)) continue;
            var1.add(var5);
        }
        return var1;
    }

    public static int pack(Set<Relative> var0) {
        int var1 = 0;
        for (Relative var3 : var0) {
            var1 |= var3.getMask();
        }
        return var1;
    }

    static {
        ALL = Set.of(Relative.values());
        ROTATION = Set.of(X_ROT, Y_ROT);
        DELTA = Set.of(DELTA_X, DELTA_Y, DELTA_Z, ROTATE_DELTA);
        SET_STREAM_CODEC = ByteBufCodecs.INT.map(Relative::unpack, Relative::pack);
    }
}

