/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;

public interface SpawnPlacementTypes {
    public static final SpawnPlacementType NO_RESTRICTIONS = (var0, var1, var2) -> true;
    public static final SpawnPlacementType IN_WATER = (var0, var1, var2) -> {
        if (var2 == null || !var0.getWorldBorder().isWithinBounds(var1)) {
            return false;
        }
        BlockPos var3 = var1.above();
        return var0.getFluidState(var1).is(FluidTags.WATER) && !var0.getBlockState(var3).isRedstoneConductor(var0, var3);
    };
    public static final SpawnPlacementType IN_LAVA = (var0, var1, var2) -> {
        if (var2 == null || !var0.getWorldBorder().isWithinBounds(var1)) {
            return false;
        }
        return var0.getFluidState(var1).is(FluidTags.LAVA);
    };
    public static final SpawnPlacementType ON_GROUND = new SpawnPlacementType(){

        @Override
        public boolean isSpawnPositionOk(LevelReader var0, BlockPos var1, @Nullable EntityType<?> var2) {
            if (var2 == null || !var0.getWorldBorder().isWithinBounds(var1)) {
                return false;
            }
            BlockPos var3 = var1.above();
            BlockPos var4 = var1.below();
            BlockState var5 = var0.getBlockState(var4);
            if (!var5.isValidSpawn(var0, var4, var2)) {
                return false;
            }
            return this.isValidEmptySpawnBlock(var0, var1, var2) && this.isValidEmptySpawnBlock(var0, var3, var2);
        }

        private boolean isValidEmptySpawnBlock(LevelReader var0, BlockPos var1, EntityType<?> var2) {
            BlockState var3 = var0.getBlockState(var1);
            return NaturalSpawner.isValidEmptySpawnBlock(var0, var1, var3, var3.getFluidState(), var2);
        }

        @Override
        public BlockPos adjustSpawnPosition(LevelReader var0, BlockPos var1) {
            BlockPos var2 = var1.below();
            if (var0.getBlockState(var2).isPathfindable(PathComputationType.LAND)) {
                return var2;
            }
            return var1;
        }
    };
}

