/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class AnimalPanic<E extends PathfinderMob>
extends Behavior<E> {
    private static final int PANIC_MIN_DURATION = 100;
    private static final int PANIC_MAX_DURATION = 120;
    private static final int PANIC_DISTANCE_HORIZONTAL = 5;
    private static final int PANIC_DISTANCE_VERTICAL = 4;
    private final float speedMultiplier;
    private final Function<PathfinderMob, TagKey<DamageType>> panicCausingDamageTypes;
    private final Function<E, Vec3> positionGetter;

    public AnimalPanic(float var02) {
        this(var02, var0 -> DamageTypeTags.PANIC_CAUSES, var0 -> LandRandomPos.getPos(var0, 5, 4));
    }

    public AnimalPanic(float var02, int var12) {
        this(var02, var0 -> DamageTypeTags.PANIC_CAUSES, var1 -> AirAndWaterRandomPos.getPos(var1, 5, 4, var12, var1.getViewVector((float)0.0f).x, var1.getViewVector((float)0.0f).z, 1.5707963705062866));
    }

    public AnimalPanic(float var02, Function<PathfinderMob, TagKey<DamageType>> var1) {
        this(var02, var1, var0 -> LandRandomPos.getPos(var0, 5, 4));
    }

    public AnimalPanic(float var0, Function<PathfinderMob, TagKey<DamageType>> var1, Function<E, Vec3> var2) {
        super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.REGISTERED, MemoryModuleType.HURT_BY, MemoryStatus.REGISTERED), 100, 120);
        this.speedMultiplier = var0;
        this.panicCausingDamageTypes = var1;
        this.positionGetter = var2;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, E var12) {
        return ((LivingEntity)var12).getBrain().getMemory(MemoryModuleType.HURT_BY).map(var1 -> var1.is(this.panicCausingDamageTypes.apply((PathfinderMob)var12))).orElse(false) != false || ((LivingEntity)var12).getBrain().hasMemoryValue(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, E var1, long var2) {
        return true;
    }

    @Override
    protected void start(ServerLevel var0, E var1, long var2) {
        ((LivingEntity)var1).getBrain().setMemory(MemoryModuleType.IS_PANICKING, true);
        ((LivingEntity)var1).getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        ((Mob)var1).getNavigation().stop();
    }

    @Override
    protected void stop(ServerLevel var0, E var1, long var2) {
        Brain<?> var4 = ((LivingEntity)var1).getBrain();
        var4.eraseMemory(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected void tick(ServerLevel var0, E var1, long var2) {
        Vec3 var4;
        if (((Mob)var1).getNavigation().isDone() && (var4 = this.getPanicPos(var1, var0)) != null) {
            ((LivingEntity)var1).getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(var4, this.speedMultiplier, 0));
        }
    }

    @Nullable
    private Vec3 getPanicPos(E var0, ServerLevel var1) {
        Optional<Vec3> var2;
        if (((Entity)var0).isOnFire() && (var2 = this.lookForWater(var1, (Entity)var0).map(Vec3::atBottomCenterOf)).isPresent()) {
            return var2.get();
        }
        return this.positionGetter.apply(var0);
    }

    private Optional<BlockPos> lookForWater(BlockGetter var0, Entity var13) {
        BlockPos var2 = var13.blockPosition();
        if (!var0.getBlockState(var2).getCollisionShape(var0, var2).isEmpty()) {
            return Optional.empty();
        }
        Predicate<BlockPos> var3 = Mth.ceil(var13.getBbWidth()) == 2 ? var12 -> BlockPos.squareOutSouthEast(var12).allMatch(var1 -> var0.getFluidState((BlockPos)var1).is(FluidTags.WATER)) : var1 -> var0.getFluidState((BlockPos)var1).is(FluidTags.WATER);
        return BlockPos.findClosestMatch(var2, 5, 1, var3);
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (E)((PathfinderMob)livingEntity), l);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.tick(serverLevel, (E)((PathfinderMob)livingEntity), l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (E)((PathfinderMob)livingEntity), l);
    }
}

