/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class HarvestFarmland
extends Behavior<Villager> {
    private static final int HARVEST_DURATION = 200;
    public static final float SPEED_MODIFIER = 0.5f;
    @Nullable
    private BlockPos aboveFarmlandPos;
    private long nextOkStartTime;
    private int timeWorkedSoFar;
    private final List<BlockPos> validFarmlandAroundVillager = Lists.newArrayList();

    public HarvestFarmland() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.SECONDARY_JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldserver, Villager entityvillager) {
        if (!worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            return false;
        }
        if (!entityvillager.getVillagerData().profession().is(VillagerProfession.FARMER)) {
            return false;
        }
        BlockPos.MutableBlockPos blockposition_mutableblockposition = entityvillager.blockPosition().mutable();
        this.validFarmlandAroundVillager.clear();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    blockposition_mutableblockposition.set(entityvillager.getX() + (double)i, entityvillager.getY() + (double)j, entityvillager.getZ() + (double)k);
                    if (!this.validPos(blockposition_mutableblockposition, worldserver)) continue;
                    this.validFarmlandAroundVillager.add(new BlockPos(blockposition_mutableblockposition));
                }
            }
        }
        this.aboveFarmlandPos = this.getValidFarmland(worldserver);
        return this.aboveFarmlandPos != null;
    }

    @Nullable
    private BlockPos getValidFarmland(ServerLevel worldserver) {
        return this.validFarmlandAroundVillager.isEmpty() ? null : this.validFarmlandAroundVillager.get(worldserver.getRandom().nextInt(this.validFarmlandAroundVillager.size()));
    }

    private boolean validPos(BlockPos blockposition, ServerLevel worldserver) {
        BlockState iblockdata = worldserver.getBlockState(blockposition);
        Block block = iblockdata.getBlock();
        Block block1 = worldserver.getBlockState(blockposition.below()).getBlock();
        return block instanceof CropBlock && ((CropBlock)block).isMaxAge(iblockdata) || iblockdata.isAir() && block1 instanceof FarmBlock;
    }

    @Override
    protected void start(ServerLevel worldserver, Villager entityvillager, long i) {
        if (i > this.nextOkStartTime && this.aboveFarmlandPos != null) {
            entityvillager.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(this.aboveFarmlandPos));
            entityvillager.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new BlockPosTracker(this.aboveFarmlandPos), 0.5f, 1));
        }
    }

    @Override
    protected void stop(ServerLevel worldserver, Villager entityvillager, long i) {
        entityvillager.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        entityvillager.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        this.timeWorkedSoFar = 0;
        this.nextOkStartTime = i + 40L;
    }

    @Override
    protected void tick(ServerLevel worldserver, Villager entityvillager, long i) {
        if (this.aboveFarmlandPos == null || this.aboveFarmlandPos.closerToCenterThan(entityvillager.position(), 1.0)) {
            if (this.aboveFarmlandPos != null && i > this.nextOkStartTime) {
                BlockState iblockdata = worldserver.getBlockState(this.aboveFarmlandPos);
                Block block = iblockdata.getBlock();
                Block block1 = worldserver.getBlockState(this.aboveFarmlandPos.below()).getBlock();
                if (block instanceof CropBlock && ((CropBlock)block).isMaxAge(iblockdata) && CraftEventFactory.callEntityChangeBlockEvent(entityvillager, this.aboveFarmlandPos, Blocks.AIR.defaultBlockState())) {
                    worldserver.destroyBlock(this.aboveFarmlandPos, true, entityvillager);
                }
                if (iblockdata.isAir() && block1 instanceof FarmBlock && entityvillager.hasFarmSeeds()) {
                    SimpleContainer inventorysubcontainer = entityvillager.getInventory();
                    for (int j = 0; j < inventorysubcontainer.getContainerSize(); ++j) {
                        BlockItem itemblock;
                        BlockState iblockdata1;
                        Item item;
                        ItemStack itemstack = inventorysubcontainer.getItem(j);
                        boolean flag = false;
                        if (!itemstack.isEmpty() && itemstack.is(ItemTags.VILLAGER_PLANTABLE_SEEDS) && (item = itemstack.getItem()) instanceof BlockItem && CraftEventFactory.callEntityChangeBlockEvent(entityvillager, this.aboveFarmlandPos, iblockdata1 = (itemblock = (BlockItem)item).getBlock().defaultBlockState())) {
                            worldserver.setBlockAndUpdate(this.aboveFarmlandPos, iblockdata1);
                            worldserver.gameEvent(GameEvent.BLOCK_PLACE, this.aboveFarmlandPos, GameEvent.Context.of(entityvillager, iblockdata1));
                            flag = true;
                        }
                        if (!flag) continue;
                        worldserver.playSound((Entity)null, (double)this.aboveFarmlandPos.getX(), (double)this.aboveFarmlandPos.getY(), (double)this.aboveFarmlandPos.getZ(), SoundEvents.CROP_PLANTED, SoundSource.BLOCKS, 1.0f, 1.0f);
                        itemstack.shrink(1);
                        if (!itemstack.isEmpty()) break;
                        inventorysubcontainer.setItem(j, ItemStack.EMPTY);
                        break;
                    }
                }
                if (block instanceof CropBlock && !((CropBlock)block).isMaxAge(iblockdata)) {
                    this.validFarmlandAroundVillager.remove(this.aboveFarmlandPos);
                    this.aboveFarmlandPos = this.getValidFarmland(worldserver);
                    if (this.aboveFarmlandPos != null) {
                        this.nextOkStartTime = i + 20L;
                        entityvillager.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new WalkTarget(new BlockPosTracker(this.aboveFarmlandPos), 0.5f, 1));
                        entityvillager.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(this.aboveFarmlandPos));
                    }
                }
            }
            ++this.timeWorkedSoFar;
        }
    }

    @Override
    protected boolean canStillUse(ServerLevel worldserver, Villager entityvillager, long i) {
        return this.timeWorkedSoFar < 200;
    }
}

