/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class LookAtTargetSink
extends Behavior<Mob> {
    public LookAtTargetSink(int var0, int var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), var0, var1);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Mob var12, long var2) {
        return var12.getBrain().getMemory(MemoryModuleType.LOOK_TARGET).filter(var1 -> var1.isVisibleBy(var12)).isPresent();
    }

    @Override
    protected void stop(ServerLevel var0, Mob var1, long var2) {
        var1.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
    }

    @Override
    protected void tick(ServerLevel var0, Mob var12, long var2) {
        var12.getBrain().getMemory(MemoryModuleType.LOOK_TARGET).ifPresent(var1 -> var12.getLookControl().setLookAt(var1.currentPosition()));
    }
}

