/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.pathfinder.Path;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class VillagerMakeLove
extends Behavior<Villager> {
    private long birthTimestamp;

    public VillagerMakeLove() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.BREED_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 350, 350);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel worldserver, Villager entityvillager) {
        return this.isBreedingPossible(entityvillager);
    }

    @Override
    protected boolean canStillUse(ServerLevel worldserver, Villager entityvillager, long i) {
        return i <= this.birthTimestamp && this.isBreedingPossible(entityvillager);
    }

    @Override
    protected void start(ServerLevel worldserver, Villager entityvillager, long i) {
        AgeableMob entityageable = entityvillager.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        BehaviorUtils.lockGazeAndWalkToEachOther(entityvillager, entityageable, 0.5f, 2);
        worldserver.broadcastEntityEvent(entityageable, (byte)18);
        worldserver.broadcastEntityEvent(entityvillager, (byte)18);
        int j = 275 + entityvillager.getRandom().nextInt(50);
        this.birthTimestamp = i + (long)j;
    }

    @Override
    protected void tick(ServerLevel worldserver, Villager entityvillager, long i) {
        Villager entityvillager1 = (Villager)entityvillager.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        if (entityvillager.distanceToSqr(entityvillager1) <= 5.0) {
            BehaviorUtils.lockGazeAndWalkToEachOther(entityvillager, entityvillager1, 0.5f, 2);
            if (i >= this.birthTimestamp) {
                entityvillager.eatAndDigestFood();
                entityvillager1.eatAndDigestFood();
                this.tryToGiveBirth(worldserver, entityvillager, entityvillager1);
            } else if (entityvillager.getRandom().nextInt(35) == 0) {
                worldserver.broadcastEntityEvent(entityvillager1, (byte)12);
                worldserver.broadcastEntityEvent(entityvillager, (byte)12);
            }
        }
    }

    private void tryToGiveBirth(ServerLevel worldserver, Villager entityvillager, Villager entityvillager1) {
        Optional<BlockPos> optional = this.takeVacantBed(worldserver, entityvillager);
        if (optional.isEmpty()) {
            worldserver.broadcastEntityEvent(entityvillager1, (byte)13);
            worldserver.broadcastEntityEvent(entityvillager, (byte)13);
        } else {
            Optional<Villager> optional1 = this.breed(worldserver, entityvillager, entityvillager1);
            if (optional1.isPresent()) {
                this.giveBedToChild(worldserver, optional1.get(), optional.get());
            } else {
                worldserver.getPoiManager().release(optional.get());
                DebugPackets.sendPoiTicketCountPacket(worldserver, optional.get());
            }
        }
    }

    @Override
    protected void stop(ServerLevel worldserver, Villager entityvillager, long i) {
        entityvillager.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
    }

    private boolean isBreedingPossible(Villager entityvillager) {
        Brain<Villager> behaviorcontroller = entityvillager.getBrain();
        Optional<AgeableMob> optional = behaviorcontroller.getMemory(MemoryModuleType.BREED_TARGET).filter(entityageable -> entityageable.getType() == EntityType.VILLAGER);
        return optional.isEmpty() ? false : BehaviorUtils.targetIsValid(behaviorcontroller, MemoryModuleType.BREED_TARGET, EntityType.VILLAGER) && entityvillager.canBreed() && optional.get().canBreed();
    }

    private Optional<BlockPos> takeVacantBed(ServerLevel worldserver, Villager entityvillager) {
        return worldserver.getPoiManager().take(holder -> holder.is(PoiTypes.HOME), (holder, blockposition) -> this.canReach(entityvillager, (BlockPos)blockposition, (Holder<PoiType>)holder), entityvillager.blockPosition(), 48);
    }

    private boolean canReach(Villager entityvillager, BlockPos blockposition, Holder<PoiType> holder) {
        Path pathentity = entityvillager.getNavigation().createPath(blockposition, holder.value().validRange());
        return pathentity != null && pathentity.canReach();
    }

    private Optional<Villager> breed(ServerLevel worldserver, Villager entityvillager, Villager entityvillager1) {
        Villager entityvillager2 = entityvillager.getBreedOffspring(worldserver, entityvillager1);
        if (entityvillager2 == null) {
            return Optional.empty();
        }
        entityvillager2.setAge(-24000);
        entityvillager2.snapTo(entityvillager.getX(), entityvillager.getY(), entityvillager.getZ(), 0.0f, 0.0f);
        if (CraftEventFactory.callEntityBreedEvent(entityvillager2, entityvillager, entityvillager1, null, null, 0).isCancelled()) {
            return Optional.empty();
        }
        entityvillager.setAge(6000);
        entityvillager1.setAge(6000);
        worldserver.addFreshEntityWithPassengers(entityvillager2, CreatureSpawnEvent.SpawnReason.BREEDING);
        worldserver.broadcastEntityEvent(entityvillager2, (byte)12);
        return Optional.of(entityvillager2);
    }

    private void giveBedToChild(ServerLevel worldserver, Villager entityvillager, BlockPos blockposition) {
        GlobalPos globalpos = GlobalPos.of(worldserver.dimension(), blockposition);
        entityvillager.getBrain().setMemory(MemoryModuleType.HOME, globalpos);
    }
}

