/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;

public class VillagerPanicTrigger
extends Behavior<Villager> {
    public VillagerPanicTrigger() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of());
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Villager var1, long var2) {
        return VillagerPanicTrigger.isHurt(var1) || VillagerPanicTrigger.hasHostile(var1);
    }

    @Override
    protected void start(ServerLevel var0, Villager var1, long var2) {
        if (VillagerPanicTrigger.isHurt(var1) || VillagerPanicTrigger.hasHostile(var1)) {
            Brain<Villager> var4 = var1.getBrain();
            if (!var4.isActive(Activity.PANIC)) {
                var4.eraseMemory(MemoryModuleType.PATH);
                var4.eraseMemory(MemoryModuleType.WALK_TARGET);
                var4.eraseMemory(MemoryModuleType.LOOK_TARGET);
                var4.eraseMemory(MemoryModuleType.BREED_TARGET);
                var4.eraseMemory(MemoryModuleType.INTERACTION_TARGET);
            }
            var4.setActiveActivityIfPossible(Activity.PANIC);
        }
    }

    @Override
    protected void tick(ServerLevel var0, Villager var1, long var2) {
        if (var2 % 100L == 0L) {
            var1.spawnGolemIfNeeded(var0, var2, 3);
        }
    }

    public static boolean hasHostile(LivingEntity var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_HOSTILE);
    }

    public static boolean isHurt(LivingEntity var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Villager)livingEntity, l);
    }
}

