/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;

public class WorkAtPoi
extends Behavior<Villager> {
    private static final int CHECK_COOLDOWN = 300;
    private static final double DISTANCE = 1.73;
    private long lastCheck;

    public WorkAtPoi() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.JOB_SITE, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED)));
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Villager var1) {
        if (var0.getGameTime() - this.lastCheck < 300L) {
            return false;
        }
        if (var0.random.nextInt(2) != 0) {
            return false;
        }
        this.lastCheck = var0.getGameTime();
        GlobalPos var2 = var1.getBrain().getMemory(MemoryModuleType.JOB_SITE).get();
        return var2.dimension() == var0.dimension() && var2.pos().closerToCenterThan(var1.position(), 1.73);
    }

    @Override
    protected void start(ServerLevel var0, Villager var12, long var2) {
        Brain<Villager> var4 = var12.getBrain();
        var4.setMemory(MemoryModuleType.LAST_WORKED_AT_POI, var2);
        var4.getMemory(MemoryModuleType.JOB_SITE).ifPresent(var1 -> var4.setMemory(MemoryModuleType.LOOK_TARGET, new BlockPosTracker(var1.pos())));
        var12.playWorkSound();
        this.useWorkstation(var0, var12);
        if (var12.shouldRestock()) {
            var12.restock();
        }
    }

    protected void useWorkstation(ServerLevel var0, Villager var1) {
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Villager var1, long var2) {
        Optional<GlobalPos> var4 = var1.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        if (var4.isEmpty()) {
            return false;
        }
        GlobalPos var5 = var4.get();
        return var5.dimension() == var0.dimension() && var5.pos().closerToCenterThan(var1.position(), 1.73);
    }

    @Override
    protected /* synthetic */ boolean checkExtraStartConditions(ServerLevel serverLevel, LivingEntity livingEntity) {
        return this.checkExtraStartConditions(serverLevel, (Villager)livingEntity);
    }

    @Override
    protected /* synthetic */ boolean canStillUse(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        return this.canStillUse(serverLevel, (Villager)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Villager)livingEntity, l);
    }
}

