/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.control;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class FlyingMoveControl
extends MoveControl {
    private final int maxTurn;
    private final boolean hoversInPlace;

    public FlyingMoveControl(Mob var0, int var1, boolean var2) {
        super(var0);
        this.maxTurn = var1;
        this.hoversInPlace = var2;
    }

    @Override
    public void tick() {
        if (this.operation == MoveControl.Operation.MOVE_TO) {
            this.operation = MoveControl.Operation.WAIT;
            this.mob.setNoGravity(true);
            double var0 = this.wantedX - this.mob.getX();
            double var2 = this.wantedY - this.mob.getY();
            double var4 = this.wantedZ - this.mob.getZ();
            double var6 = var0 * var0 + var2 * var2 + var4 * var4;
            if (var6 < 2.500000277905201E-7) {
                this.mob.setYya(0.0f);
                this.mob.setZza(0.0f);
                return;
            }
            float var8 = (float)(Mth.atan2(var4, var0) * 57.2957763671875) - 90.0f;
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), var8, 90.0f));
            float var9 = this.mob.onGround() ? (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED)) : (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.FLYING_SPEED));
            this.mob.setSpeed(var9);
            double var10 = Math.sqrt(var0 * var0 + var4 * var4);
            if (Math.abs(var2) > (double)1.0E-5f || Math.abs(var10) > (double)1.0E-5f) {
                float var12 = (float)(-(Mth.atan2(var2, var10) * 57.2957763671875));
                this.mob.setXRot(this.rotlerp(this.mob.getXRot(), var12, this.maxTurn));
                this.mob.setYya(var2 > 0.0 ? var9 : -var9);
            }
        } else {
            if (!this.hoversInPlace) {
                this.mob.setNoGravity(false);
            }
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }
}

