/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MoveThroughVillageGoal
extends Goal {
    protected final PathfinderMob mob;
    private final double speedModifier;
    @Nullable
    private Path path;
    private BlockPos poiPos;
    private final boolean onlyAtNight;
    private final List<BlockPos> visited = Lists.newArrayList();
    private final int distanceToPoi;
    private final BooleanSupplier canDealWithDoors;

    public MoveThroughVillageGoal(PathfinderMob var0, double var1, boolean var3, int var4, BooleanSupplier var5) {
        this.mob = var0;
        this.speedModifier = var1;
        this.onlyAtNight = var3;
        this.distanceToPoi = var4;
        this.canDealWithDoors = var5;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        if (!GoalUtils.hasGroundPathNavigation(var0)) {
            throw new IllegalArgumentException("Unsupported mob for MoveThroughVillageGoal");
        }
    }

    @Override
    public boolean canUse() {
        BlockPos var1;
        if (!GoalUtils.hasGroundPathNavigation(this.mob)) {
            return false;
        }
        this.updateVisited();
        if (this.onlyAtNight && this.mob.level().isBrightOutside()) {
            return false;
        }
        ServerLevel var02 = (ServerLevel)this.mob.level();
        if (!var02.isCloseToVillage(var1 = this.mob.blockPosition(), 6)) {
            return false;
        }
        Vec3 var22 = LandRandomPos.getPos(this.mob, 15, 7, var2 -> {
            if (!var02.isVillage((BlockPos)var2)) {
                return Double.NEGATIVE_INFINITY;
            }
            Optional<BlockPos> var3 = var02.getPoiManager().find(var0 -> var0.is(PoiTypeTags.VILLAGE), this::hasNotVisited, (BlockPos)var2, 10, PoiManager.Occupancy.IS_OCCUPIED);
            return var3.map(var1 -> -var1.distSqr(var1)).orElse(Double.NEGATIVE_INFINITY);
        });
        if (var22 == null) {
            return false;
        }
        Optional<BlockPos> var3 = var02.getPoiManager().find(var0 -> var0.is(PoiTypeTags.VILLAGE), this::hasNotVisited, BlockPos.containing(var22), 10, PoiManager.Occupancy.IS_OCCUPIED);
        if (var3.isEmpty()) {
            return false;
        }
        this.poiPos = var3.get().immutable();
        GroundPathNavigation var4 = (GroundPathNavigation)this.mob.getNavigation();
        var4.setCanOpenDoors(this.canDealWithDoors.getAsBoolean());
        this.path = var4.createPath(this.poiPos, 0);
        var4.setCanOpenDoors(true);
        if (this.path == null) {
            Vec3 var5 = DefaultRandomPos.getPosTowards(this.mob, 10, 7, Vec3.atBottomCenterOf(this.poiPos), 1.5707963705062866);
            if (var5 == null) {
                return false;
            }
            var4.setCanOpenDoors(this.canDealWithDoors.getAsBoolean());
            this.path = this.mob.getNavigation().createPath(var5.x, var5.y, var5.z, 0);
            var4.setCanOpenDoors(true);
            if (this.path == null) {
                return false;
            }
        }
        for (int var5 = 0; var5 < this.path.getNodeCount(); ++var5) {
            Node var6 = this.path.getNode(var5);
            BlockPos var7 = new BlockPos(var6.x, var6.y + 1, var6.z);
            if (!DoorBlock.isWoodenDoor(this.mob.level(), var7)) continue;
            this.path = this.mob.getNavigation().createPath(var6.x, (double)var6.y, var6.z, 0);
            break;
        }
        return this.path != null;
    }

    @Override
    public boolean canContinueToUse() {
        if (this.mob.getNavigation().isDone()) {
            return false;
        }
        return !this.poiPos.closerToCenterThan(this.mob.position(), this.mob.getBbWidth() + (float)this.distanceToPoi);
    }

    @Override
    public void start() {
        this.mob.getNavigation().moveTo(this.path, this.speedModifier);
    }

    @Override
    public void stop() {
        if (this.mob.getNavigation().isDone() || this.poiPos.closerToCenterThan(this.mob.position(), this.distanceToPoi)) {
            this.visited.add(this.poiPos);
        }
    }

    private boolean hasNotVisited(BlockPos var0) {
        for (BlockPos var2 : this.visited) {
            if (!Objects.equals(var0, var2)) continue;
            return false;
        }
        return true;
    }

    private void updateVisited() {
        if (this.visited.size() > 15) {
            this.visited.remove(0);
        }
    }
}

