/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class GroundPathNavigation
extends PathNavigation {
    private boolean avoidSun;

    public GroundPathNavigation(Mob var0, Level var1) {
        super(var0, var1);
    }

    @Override
    protected PathFinder createPathFinder(int var0) {
        this.nodeEvaluator = new WalkNodeEvaluator();
        return new PathFinder(this.nodeEvaluator, var0);
    }

    @Override
    protected boolean canUpdatePath() {
        return this.mob.onGround() || this.mob.isInLiquid() || this.mob.isPassenger();
    }

    @Override
    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), this.getSurfaceY(), this.mob.getZ());
    }

    @Override
    public Path createPath(BlockPos var0, int var1) {
        BlockPos.MutableBlockPos var3;
        LevelChunk var2 = this.level.getChunkSource().getChunkNow(SectionPos.blockToSectionCoord(var0.getX()), SectionPos.blockToSectionCoord(var0.getZ()));
        if (var2 == null) {
            return null;
        }
        if (var2.getBlockState(var0).isAir()) {
            var3 = var0.mutable().move(Direction.DOWN);
            while (var3.getY() >= this.level.getMinY() && var2.getBlockState(var3).isAir()) {
                var3.move(Direction.DOWN);
            }
            if (var3.getY() >= this.level.getMinY()) {
                return super.createPath((BlockPos)var3.above(), var1);
            }
            var3.setY(var0.getY() + 1);
            while (var3.getY() <= this.level.getMaxY() && var2.getBlockState(var3).isAir()) {
                var3.move(Direction.UP);
            }
            var0 = var3;
        }
        if (var2.getBlockState(var0).isSolid()) {
            var3 = var0.mutable().move(Direction.UP);
            while (var3.getY() <= this.level.getMaxY() && var2.getBlockState(var3).isSolid()) {
                var3.move(Direction.UP);
            }
            return super.createPath(var3.immutable(), var1);
        }
        return super.createPath(var0, var1);
    }

    @Override
    public Path createPath(Entity var0, int var1) {
        return this.createPath(var0.blockPosition(), var1);
    }

    private int getSurfaceY() {
        if (!this.mob.isInWater() || !this.canFloat()) {
            return Mth.floor(this.mob.getY() + 0.5);
        }
        int var0 = this.mob.getBlockY();
        BlockState var1 = this.level.getBlockState(BlockPos.containing(this.mob.getX(), var0, this.mob.getZ()));
        int var2 = 0;
        while (var1.is(Blocks.WATER)) {
            var1 = this.level.getBlockState(BlockPos.containing(this.mob.getX(), ++var0, this.mob.getZ()));
            if (++var2 <= 16) continue;
            return this.mob.getBlockY();
        }
        return var0;
    }

    @Override
    protected void trimPath() {
        super.trimPath();
        if (this.avoidSun) {
            if (this.level.canSeeSky(BlockPos.containing(this.mob.getX(), this.mob.getY() + 0.5, this.mob.getZ()))) {
                return;
            }
            for (int var0 = 0; var0 < this.path.getNodeCount(); ++var0) {
                Node var1 = this.path.getNode(var0);
                if (!this.level.canSeeSky(new BlockPos(var1.x, var1.y, var1.z))) continue;
                this.path.truncateNodes(var0);
                return;
            }
        }
    }

    @Override
    public boolean canNavigateGround() {
        return true;
    }

    protected boolean hasValidPathType(PathType var0) {
        if (var0 == PathType.WATER) {
            return false;
        }
        if (var0 == PathType.LAVA) {
            return false;
        }
        return var0 != PathType.OPEN;
    }

    public void setAvoidSun(boolean var0) {
        this.avoidSun = var0;
    }

    public void setCanWalkOverFences(boolean var0) {
        this.nodeEvaluator.setCanWalkOverFences(var0);
    }
}

