/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.navigation;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;

public class WallClimberNavigation
extends GroundPathNavigation {
    @Nullable
    private BlockPos pathToPosition;

    public WallClimberNavigation(Mob var0, Level var1) {
        super(var0, var1);
    }

    @Override
    public Path createPath(BlockPos var0, int var1) {
        this.pathToPosition = var0;
        return super.createPath(var0, var1);
    }

    @Override
    public Path createPath(Entity var0, int var1) {
        this.pathToPosition = var0.blockPosition();
        return super.createPath(var0, var1);
    }

    @Override
    public boolean moveTo(Entity var0, double var1) {
        Path var3 = this.createPath(var0, 0);
        if (var3 != null) {
            return this.moveTo(var3, var1);
        }
        this.pathToPosition = var0.blockPosition();
        this.speedModifier = var1;
        return true;
    }

    @Override
    public void tick() {
        if (this.isDone()) {
            if (this.pathToPosition != null) {
                if (this.pathToPosition.closerToCenterThan(this.mob.position(), this.mob.getBbWidth()) || this.mob.getY() > (double)this.pathToPosition.getY() && BlockPos.containing(this.pathToPosition.getX(), this.mob.getY(), this.pathToPosition.getZ()).closerToCenterThan(this.mob.position(), this.mob.getBbWidth())) {
                    this.pathToPosition = null;
                } else {
                    this.mob.getMoveControl().setWantedPosition(this.pathToPosition.getX(), this.pathToPosition.getY(), this.pathToPosition.getZ(), this.speedModifier);
                }
            }
            return;
        }
        super.tick();
    }
}

