/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;

public class HoglinSpecificSensor
extends Sensor<Hoglin> {
    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_REPELLENT, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, (Object[])new MemoryModuleType[0]);
    }

    @Override
    protected void doTick(ServerLevel var02, Hoglin var1) {
        Brain<Hoglin> var2 = var1.getBrain();
        var2.setMemory(MemoryModuleType.NEAREST_REPELLENT, this.findNearestRepellent(var02, var1));
        Optional<Object> var3 = Optional.empty();
        int var4 = 0;
        ArrayList var5 = Lists.newArrayList();
        NearestVisibleLivingEntities var6 = var2.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
        for (LivingEntity var8 : var6.findAll(var0 -> !var0.isBaby() && (var0 instanceof Piglin || var0 instanceof Hoglin))) {
            PathfinderMob var9;
            if (var8 instanceof Piglin) {
                var9 = (Piglin)var8;
                ++var4;
                if (var3.isEmpty()) {
                    var3 = Optional.of(var9);
                }
            }
            if (!(var8 instanceof Hoglin)) continue;
            var9 = (Hoglin)var8;
            var5.add(var9);
        }
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, var3);
        var2.setMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS, var5);
        var2.setMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, var4);
        var2.setMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, var5.size());
    }

    private Optional<BlockPos> findNearestRepellent(ServerLevel var0, Hoglin var12) {
        return BlockPos.findClosestMatch(var12.blockPosition(), 8, 4, var1 -> var0.getBlockState((BlockPos)var1).is(BlockTags.HOGLIN_REPELLENTS));
    }
}

