/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;

public abstract class NearestVisibleLivingEntitySensor
extends Sensor<LivingEntity> {
    protected abstract boolean isMatchingEntity(ServerLevel var1, LivingEntity var2, LivingEntity var3);

    protected abstract MemoryModuleType<LivingEntity> getMemory();

    @Override
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(this.getMemory());
    }

    @Override
    protected void doTick(ServerLevel var0, LivingEntity var1) {
        var1.getBrain().setMemory(this.getMemory(), this.getNearestEntity(var0, var1));
    }

    private Optional<LivingEntity> getNearestEntity(ServerLevel var0, LivingEntity var1) {
        return this.getVisibleEntities(var1).flatMap(var22 -> var22.findClosest(var2 -> this.isMatchingEntity(var0, var1, (LivingEntity)var2)));
    }

    protected Optional<NearestVisibleLivingEntities> getVisibleEntities(LivingEntity var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
    }
}

