/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.SectionTracker;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiSection;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;

public class PoiManager
extends SectionStorage<PoiSection, PoiSection.Packed> {
    public static final int MAX_VILLAGE_DISTANCE = 6;
    public static final int VILLAGE_SECTION_SIZE = 1;
    private final DistanceTracker distanceTracker;
    private final LongSet loadedChunks = new LongOpenHashSet();

    public PoiManager(RegionStorageInfo var0, Path var1, DataFixer var2, boolean var3, RegistryAccess var4, ChunkIOErrorReporter var5, LevelHeightAccessor var6) {
        super(new SimpleRegionStorage(var0, var1, var2, var3, DataFixTypes.POI_CHUNK), PoiSection.Packed.CODEC, PoiSection::pack, PoiSection.Packed::unpack, PoiSection::new, var4, var5, var6);
        this.distanceTracker = new DistanceTracker();
    }

    public void add(BlockPos var0, Holder<PoiType> var1) {
        ((PoiSection)this.getOrCreate(SectionPos.asLong(var0))).add(var0, var1);
    }

    public void remove(BlockPos var0) {
        this.getOrLoad(SectionPos.asLong(var0)).ifPresent(var1 -> var1.remove(var0));
    }

    public long getCountInRange(Predicate<Holder<PoiType>> var0, BlockPos var1, int var2, Occupancy var3) {
        return this.getInRange(var0, var1, var2, var3).count();
    }

    public boolean existsAtPosition(ResourceKey<PoiType> var0, BlockPos var12) {
        return this.exists(var12, var1 -> var1.is(var0));
    }

    public Stream<PoiRecord> getInSquare(Predicate<Holder<PoiType>> var0, BlockPos var1, int var22, Occupancy var3) {
        int var4 = Math.floorDiv(var22, 16) + 1;
        return ChunkPos.rangeClosed(new ChunkPos(var1), var4).flatMap(var2 -> this.getInChunk(var0, (ChunkPos)var2, var3)).filter(var2 -> {
            BlockPos var3 = var2.getPos();
            return Math.abs(var3.getX() - var1.getX()) <= var22 && Math.abs(var3.getZ() - var1.getZ()) <= var22;
        });
    }

    public Stream<PoiRecord> getInRange(Predicate<Holder<PoiType>> var0, BlockPos var1, int var22, Occupancy var3) {
        int var4 = var22 * var22;
        return this.getInSquare(var0, var1, var22, var3).filter(var2 -> var2.getPos().distSqr(var1) <= (double)var4);
    }

    @VisibleForDebug
    public Stream<PoiRecord> getInChunk(Predicate<Holder<PoiType>> var0, ChunkPos var12, Occupancy var22) {
        return IntStream.rangeClosed(this.levelHeightAccessor.getMinSectionY(), this.levelHeightAccessor.getMaxSectionY()).boxed().map(var1 -> this.getOrLoad(SectionPos.of(var12, var1).asLong())).filter(Optional::isPresent).flatMap(var2 -> ((PoiSection)var2.get()).getRecords(var0, var22));
    }

    public Stream<BlockPos> findAll(Predicate<Holder<PoiType>> var0, Predicate<BlockPos> var1, BlockPos var2, int var3, Occupancy var4) {
        return this.getInRange(var0, var2, var3, var4).map(PoiRecord::getPos).filter(var1);
    }

    public Stream<Pair<Holder<PoiType>, BlockPos>> findAllWithType(Predicate<Holder<PoiType>> var02, Predicate<BlockPos> var12, BlockPos var2, int var3, Occupancy var4) {
        return this.getInRange(var02, var2, var3, var4).filter(var1 -> var12.test(var1.getPos())).map(var0 -> Pair.of(var0.getPoiType(), (Object)var0.getPos()));
    }

    public Stream<Pair<Holder<PoiType>, BlockPos>> findAllClosestFirstWithType(Predicate<Holder<PoiType>> var0, Predicate<BlockPos> var12, BlockPos var2, int var3, Occupancy var4) {
        return this.findAllWithType(var0, var12, var2, var3, var4).sorted(Comparator.comparingDouble(var1 -> ((BlockPos)var1.getSecond()).distSqr(var2)));
    }

    public Optional<BlockPos> find(Predicate<Holder<PoiType>> var0, Predicate<BlockPos> var1, BlockPos var2, int var3, Occupancy var4) {
        return this.findAll(var0, var1, var2, var3, var4).findFirst();
    }

    public Optional<BlockPos> findClosest(Predicate<Holder<PoiType>> var0, BlockPos var12, int var2, Occupancy var3) {
        return this.getInRange(var0, var12, var2, var3).map(PoiRecord::getPos).min(Comparator.comparingDouble(var1 -> var1.distSqr(var12)));
    }

    public Optional<Pair<Holder<PoiType>, BlockPos>> findClosestWithType(Predicate<Holder<PoiType>> var02, BlockPos var12, int var2, Occupancy var3) {
        return this.getInRange(var02, var12, var2, var3).min(Comparator.comparingDouble(var1 -> var1.getPos().distSqr(var12))).map(var0 -> Pair.of(var0.getPoiType(), (Object)var0.getPos()));
    }

    public Optional<BlockPos> findClosest(Predicate<Holder<PoiType>> var0, Predicate<BlockPos> var12, BlockPos var2, int var3, Occupancy var4) {
        return this.getInRange(var0, var2, var3, var4).map(PoiRecord::getPos).filter(var12).min(Comparator.comparingDouble(var1 -> var1.distSqr(var2)));
    }

    public Optional<BlockPos> take(Predicate<Holder<PoiType>> var02, BiPredicate<Holder<PoiType>, BlockPos> var12, BlockPos var2, int var3) {
        return this.getInRange(var02, var2, var3, Occupancy.HAS_SPACE).filter(var1 -> var12.test(var1.getPoiType(), var1.getPos())).findFirst().map(var0 -> {
            var0.acquireTicket();
            return var0.getPos();
        });
    }

    public Optional<BlockPos> getRandom(Predicate<Holder<PoiType>> var0, Predicate<BlockPos> var12, Occupancy var2, BlockPos var3, int var4, RandomSource var5) {
        List<PoiRecord> var6 = Util.toShuffledList(this.getInRange(var0, var3, var4, var2), var5);
        return var6.stream().filter(var1 -> var12.test(var1.getPos())).findFirst().map(PoiRecord::getPos);
    }

    public boolean release(BlockPos var0) {
        return this.getOrLoad(SectionPos.asLong(var0)).map(var1 -> var1.release(var0)).orElseThrow(() -> Util.pauseInIde(new IllegalStateException("POI never registered at " + String.valueOf(var0))));
    }

    public boolean exists(BlockPos var0, Predicate<Holder<PoiType>> var1) {
        return this.getOrLoad(SectionPos.asLong(var0)).map(var2 -> var2.exists(var0, var1)).orElse(false);
    }

    public Optional<Holder<PoiType>> getType(BlockPos var0) {
        return this.getOrLoad(SectionPos.asLong(var0)).flatMap(var1 -> var1.getType(var0));
    }

    @Deprecated
    @VisibleForDebug
    public int getFreeTickets(BlockPos var0) {
        return this.getOrLoad(SectionPos.asLong(var0)).map(var1 -> var1.getFreeTickets(var0)).orElse(0);
    }

    public int sectionsToVillage(SectionPos var0) {
        this.distanceTracker.runAllUpdates();
        return this.distanceTracker.getLevel(var0.asLong());
    }

    boolean isVillageCenter(long var0) {
        Optional var2 = this.get(var0);
        if (var2 == null) {
            return false;
        }
        return var2.map(var02 -> var02.getRecords(var0 -> var0.is(PoiTypeTags.VILLAGE), Occupancy.IS_OCCUPIED).findAny().isPresent()).orElse(false);
    }

    @Override
    public void tick(BooleanSupplier var0) {
        super.tick(var0);
        this.distanceTracker.runAllUpdates();
    }

    @Override
    protected void setDirty(long var0) {
        super.setDirty(var0);
        this.distanceTracker.update(var0, this.distanceTracker.getLevelFromSource(var0), false);
    }

    @Override
    protected void onSectionLoad(long var0) {
        this.distanceTracker.update(var0, this.distanceTracker.getLevelFromSource(var0), false);
    }

    public void checkConsistencyWithBlocks(SectionPos var0, LevelChunkSection var1) {
        Util.ifElse(this.getOrLoad(var0.asLong()), var22 -> var22.refresh(var2 -> {
            if (PoiManager.mayHavePoi(var1)) {
                this.updateFromSection(var1, var0, (BiConsumer<BlockPos, Holder<PoiType>>)var2);
            }
        }), () -> {
            if (PoiManager.mayHavePoi(var1)) {
                PoiSection var2 = (PoiSection)this.getOrCreate(var0.asLong());
                this.updateFromSection(var1, var0, var2::add);
            }
        });
    }

    private static boolean mayHavePoi(LevelChunkSection var0) {
        return var0.maybeHas(PoiTypes::hasPoi);
    }

    private void updateFromSection(LevelChunkSection var0, SectionPos var1, BiConsumer<BlockPos, Holder<PoiType>> var2) {
        var1.blocksInside().forEach(var22 -> {
            BlockState var3 = var0.getBlockState(SectionPos.sectionRelative(var22.getX()), SectionPos.sectionRelative(var22.getY()), SectionPos.sectionRelative(var22.getZ()));
            PoiTypes.forState(var3).ifPresent(var2 -> var2.accept((BlockPos)var22, (Holder<PoiType>)var2));
        });
    }

    public void ensureLoadedAndValid(LevelReader var02, BlockPos var12, int var2) {
        SectionPos.aroundChunk(new ChunkPos(var12), Math.floorDiv(var2, 16), this.levelHeightAccessor.getMinSectionY(), this.levelHeightAccessor.getMaxSectionY()).map(var0 -> Pair.of((Object)var0, this.getOrLoad(var0.asLong()))).filter(var0 -> ((Optional)var0.getSecond()).map(PoiSection::isValid).orElse(false) == false).map(var0 -> ((SectionPos)var0.getFirst()).chunk()).filter(var0 -> this.loadedChunks.add(var0.toLong())).forEach(var1 -> var02.getChunk(var1.x, var1.z, ChunkStatus.EMPTY));
    }

    final class DistanceTracker
    extends SectionTracker {
        private final Long2ByteMap levels;

        protected DistanceTracker() {
            super(7, 16, 256);
            this.levels = new Long2ByteOpenHashMap();
            this.levels.defaultReturnValue((byte)7);
        }

        @Override
        protected int getLevelFromSource(long var0) {
            return PoiManager.this.isVillageCenter(var0) ? 0 : 7;
        }

        @Override
        protected int getLevel(long var0) {
            return this.levels.get(var0);
        }

        @Override
        protected void setLevel(long var0, int var2) {
            if (var2 > 6) {
                this.levels.remove(var0);
            } else {
                this.levels.put(var0, (byte)var2);
            }
        }

        public void runAllUpdates() {
            super.runUpdates(Integer.MAX_VALUE);
        }
    }

    public static enum Occupancy {
        HAS_SPACE(PoiRecord::hasSpace),
        IS_OCCUPIED(PoiRecord::isOccupied),
        ANY(var0 -> true);

        private final Predicate<? super PoiRecord> test;

        private Occupancy(Predicate var2) {
            this.test = var2;
        }

        public Predicate<? super PoiRecord> getTest() {
            return this.test;
        }
    }
}

