/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.village.poi;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import org.slf4j.Logger;

public class PoiSection {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Short2ObjectMap<PoiRecord> records = new Short2ObjectOpenHashMap();
    private final Map<Holder<PoiType>, Set<PoiRecord>> byType = Maps.newHashMap();
    private final Runnable setDirty;
    private boolean isValid;

    public PoiSection(Runnable var0) {
        this(var0, true, (List<PoiRecord>)ImmutableList.of());
    }

    PoiSection(Runnable var0, boolean var1, List<PoiRecord> var2) {
        this.setDirty = var0;
        this.isValid = var1;
        var2.forEach(this::add);
    }

    public Packed pack() {
        return new Packed(this.isValid, this.records.values().stream().map(PoiRecord::pack).toList());
    }

    public Stream<PoiRecord> getRecords(Predicate<Holder<PoiType>> var02, PoiManager.Occupancy var12) {
        return this.byType.entrySet().stream().filter(var1 -> var02.test((Holder)var1.getKey())).flatMap(var0 -> ((Set)var0.getValue()).stream()).filter(var12.getTest());
    }

    public void add(BlockPos var0, Holder<PoiType> var1) {
        if (this.add(new PoiRecord(var0, var1, this.setDirty))) {
            LOGGER.debug("Added POI of type {} @ {}", (Object)var1.getRegisteredName(), (Object)var0);
            this.setDirty.run();
        }
    }

    private boolean add(PoiRecord var02) {
        BlockPos var1 = var02.getPos();
        Holder<PoiType> var2 = var02.getPoiType();
        short var3 = SectionPos.sectionRelativePos(var1);
        PoiRecord var4 = (PoiRecord)this.records.get(var3);
        if (var4 != null) {
            if (var2.equals(var4.getPoiType())) {
                return false;
            }
            Util.logAndPauseIfInIde("POI data mismatch: already registered at " + String.valueOf(var1));
        }
        this.records.put(var3, (Object)var02);
        this.byType.computeIfAbsent(var2, var0 -> Sets.newHashSet()).add(var02);
        return true;
    }

    public void remove(BlockPos var0) {
        PoiRecord var1 = (PoiRecord)this.records.remove(SectionPos.sectionRelativePos(var0));
        if (var1 == null) {
            LOGGER.error("POI data mismatch: never registered at {}", (Object)var0);
            return;
        }
        this.byType.get(var1.getPoiType()).remove(var1);
        LOGGER.debug("Removed POI of type {} @ {}", LogUtils.defer(var1::getPoiType), LogUtils.defer(var1::getPos));
        this.setDirty.run();
    }

    @Deprecated
    @VisibleForDebug
    public int getFreeTickets(BlockPos var0) {
        return this.getPoiRecord(var0).map(PoiRecord::getFreeTickets).orElse(0);
    }

    public boolean release(BlockPos var0) {
        PoiRecord var1 = (PoiRecord)this.records.get(SectionPos.sectionRelativePos(var0));
        if (var1 == null) {
            throw Util.pauseInIde(new IllegalStateException("POI never registered at " + String.valueOf(var0)));
        }
        boolean var2 = var1.releaseTicket();
        this.setDirty.run();
        return var2;
    }

    public boolean exists(BlockPos var0, Predicate<Holder<PoiType>> var1) {
        return this.getType(var0).filter(var1).isPresent();
    }

    public Optional<Holder<PoiType>> getType(BlockPos var0) {
        return this.getPoiRecord(var0).map(PoiRecord::getPoiType);
    }

    private Optional<PoiRecord> getPoiRecord(BlockPos var0) {
        return Optional.ofNullable((PoiRecord)this.records.get(SectionPos.sectionRelativePos(var0)));
    }

    public void refresh(Consumer<BiConsumer<BlockPos, Holder<PoiType>>> var0) {
        if (!this.isValid) {
            Short2ObjectOpenHashMap var1 = new Short2ObjectOpenHashMap(this.records);
            this.clear();
            var0.accept((arg_0, arg_1) -> this.lambda$refresh$4((Short2ObjectMap)var1, arg_0, arg_1));
            this.isValid = true;
            this.setDirty.run();
        }
    }

    private void clear() {
        this.records.clear();
        this.byType.clear();
    }

    boolean isValid() {
        return this.isValid;
    }

    private /* synthetic */ void lambda$refresh$4(Short2ObjectMap var0, BlockPos var1, Holder var22) {
        short var3 = SectionPos.sectionRelativePos(var1);
        PoiRecord var4 = (PoiRecord)var0.computeIfAbsent(var3, var2 -> new PoiRecord(var1, var22, this.setDirty));
        this.add(var4);
    }

    public record Packed(boolean isValid, List<PoiRecord.Packed> records) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.BOOL.lenientOptionalFieldOf("Valid", (Object)false).forGetter(Packed::isValid), (App)PoiRecord.Packed.CODEC.listOf().fieldOf("Records").forGetter(Packed::records)).apply((Applicative)var0, Packed::new));

        public PoiSection unpack(Runnable var0) {
            return new PoiSection(var0, this.isValid, this.records.stream().map(var1 -> var1.unpack(var0)).toList());
        }
    }
}

