/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ambient;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;

public class Bat
extends AmbientCreature {
    public static final float FLAP_LENGTH_SECONDS = 0.5f;
    public static final float TICKS_PER_FLAP = 10.0f;
    private static final EntityDataAccessor<Byte> DATA_ID_FLAGS = SynchedEntityData.defineId(Bat.class, EntityDataSerializers.BYTE);
    private static final int FLAG_RESTING = 1;
    private static final TargetingConditions BAT_RESTING_TARGETING = TargetingConditions.forNonCombat().range(4.0);
    private static final byte DEFAULT_FLAGS = 0;
    public final AnimationState flyAnimationState = new AnimationState();
    public final AnimationState restAnimationState = new AnimationState();
    @Nullable
    private BlockPos targetPosition;

    public Bat(EntityType<? extends Bat> entitytypes, Level world) {
        super((EntityType<? extends AmbientCreature>)entitytypes, world);
        if (!world.isClientSide) {
            this.setResting(true);
        }
    }

    @Override
    public boolean isFlapping() {
        return !this.isResting() && (float)this.tickCount % 10.0f == 0.0f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_ID_FLAGS, (byte)0);
    }

    @Override
    protected float getSoundVolume() {
        return 0.1f;
    }

    @Override
    public float getVoicePitch() {
        return super.getVoicePitch() * 0.95f;
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound() {
        return this.isResting() && this.random.nextInt(4) != 0 ? null : SoundEvents.BAT_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.BAT_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.BAT_DEATH;
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    protected void doPush(Entity entity) {
    }

    @Override
    protected void pushEntities() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 6.0);
    }

    public boolean isResting() {
        return (this.entityData.get(DATA_ID_FLAGS) & 1) != 0;
    }

    public void setResting(boolean flag) {
        byte b0 = this.entityData.get(DATA_ID_FLAGS);
        if (flag) {
            this.entityData.set(DATA_ID_FLAGS, (byte)(b0 | 1));
        } else {
            this.entityData.set(DATA_ID_FLAGS, (byte)(b0 & 0xFFFFFFFE));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isResting()) {
            this.setDeltaMovement(Vec3.ZERO);
            this.setPosRaw(this.getX(), (double)Mth.floor(this.getY()) + 1.0 - (double)this.getBbHeight(), this.getZ());
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, 0.6, 1.0));
        }
        this.setupAnimationStates();
    }

    @Override
    protected void customServerAiStep(ServerLevel worldserver) {
        super.customServerAiStep(worldserver);
        BlockPos blockposition = this.blockPosition();
        BlockPos blockposition1 = blockposition.above();
        if (this.isResting()) {
            boolean flag = this.isSilent();
            if (worldserver.getBlockState(blockposition1).isRedstoneConductor(worldserver, blockposition)) {
                if (this.random.nextInt(200) == 0) {
                    this.yHeadRot = this.random.nextInt(360);
                }
                if (worldserver.getNearestPlayer(BAT_RESTING_TARGETING, this) != null && CraftEventFactory.handleBatToggleSleepEvent(this, true)) {
                    this.setResting(false);
                    if (!flag) {
                        worldserver.levelEvent(null, 1025, blockposition, 0);
                    }
                }
            } else if (CraftEventFactory.handleBatToggleSleepEvent(this, true)) {
                this.setResting(false);
                if (!flag) {
                    worldserver.levelEvent(null, 1025, blockposition, 0);
                }
            }
        } else {
            if (!(this.targetPosition == null || worldserver.isEmptyBlock(this.targetPosition) && this.targetPosition.getY() > worldserver.getMinY())) {
                this.targetPosition = null;
            }
            if (this.targetPosition == null || this.random.nextInt(30) == 0 || this.targetPosition.closerToCenterThan(this.position(), 2.0)) {
                this.targetPosition = BlockPos.containing(this.getX() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7), this.getY() + (double)this.random.nextInt(6) - 2.0, this.getZ() + (double)this.random.nextInt(7) - (double)this.random.nextInt(7));
            }
            double d0 = (double)this.targetPosition.getX() + 0.5 - this.getX();
            double d1 = (double)this.targetPosition.getY() + 0.1 - this.getY();
            double d2 = (double)this.targetPosition.getZ() + 0.5 - this.getZ();
            Vec3 vec3d = this.getDeltaMovement();
            Vec3 vec3d1 = vec3d.add((Math.signum(d0) * 0.5 - vec3d.x) * (double)0.1f, (Math.signum(d1) * (double)0.7f - vec3d.y) * (double)0.1f, (Math.signum(d2) * 0.5 - vec3d.z) * (double)0.1f);
            this.setDeltaMovement(vec3d1);
            float f = (float)(Mth.atan2(vec3d1.z, vec3d1.x) * 57.2957763671875) - 90.0f;
            float f1 = Mth.wrapDegrees(f - this.getYRot());
            this.zza = 0.5f;
            this.setYRot(this.getYRot() + f1);
            if (this.random.nextInt(100) == 0 && worldserver.getBlockState(blockposition1).isRedstoneConductor(worldserver, blockposition1) && CraftEventFactory.handleBatToggleSleepEvent(this, false)) {
                this.setResting(true);
            }
        }
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    protected void checkFallDamage(double d0, boolean flag, BlockState iblockdata, BlockPos blockposition) {
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (this.isInvulnerableTo(worldserver, damagesource)) {
            return false;
        }
        if (this.isResting() && CraftEventFactory.handleBatToggleSleepEvent(this, true)) {
            this.setResting(false);
        }
        return super.hurtServer(worldserver, damagesource, f);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.entityData.set(DATA_ID_FLAGS, valueinput.getByteOr("BatFlags", (byte)0));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putByte("BatFlags", this.entityData.get(DATA_ID_FLAGS));
    }

    public static boolean checkBatSpawnRules(EntityType<Bat> entitytypes, LevelAccessor generatoraccess, EntitySpawnReason entityspawnreason, BlockPos blockposition, RandomSource randomsource) {
        if (blockposition.getY() >= generatoraccess.getHeightmapPos(Heightmap.Types.WORLD_SURFACE, blockposition).getY()) {
            return false;
        }
        int i = generatoraccess.getMaxLocalRawBrightness(blockposition);
        int j = 4;
        if (Bat.isHalloween()) {
            j = 7;
        } else if (randomsource.nextBoolean()) {
            return false;
        }
        return i > randomsource.nextInt(j) ? false : (!generatoraccess.getBlockState(blockposition.below()).is(BlockTags.BATS_SPAWNABLE_ON) ? false : Bat.checkMobSpawnRules(entitytypes, generatoraccess, entityspawnreason, blockposition, randomsource));
    }

    private static boolean isHalloween() {
        LocalDate localdate = LocalDate.now();
        int i = localdate.get(ChronoField.DAY_OF_MONTH);
        int j = localdate.get(ChronoField.MONTH_OF_YEAR);
        return j == 10 && i >= 20 || j == 11 && i <= 3;
    }

    private void setupAnimationStates() {
        if (this.isResting()) {
            this.flyAnimationState.stop();
            this.restAnimationState.startIfStopped(this.tickCount);
        } else {
            this.restAnimationState.stop();
            this.flyAnimationState.startIfStopped(this.tickCount);
        }
    }
}

