/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.ChickenVariant;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.Biome;

public class ChickenVariants {
    public static final ResourceKey<ChickenVariant> TEMPERATE = ChickenVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<ChickenVariant> WARM = ChickenVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<ChickenVariant> COLD = ChickenVariants.createKey(TemperatureVariants.COLD);
    public static final ResourceKey<ChickenVariant> DEFAULT = TEMPERATE;

    private static ResourceKey<ChickenVariant> createKey(ResourceLocation var0) {
        return ResourceKey.create(Registries.CHICKEN_VARIANT, var0);
    }

    public static void bootstrap(BootstrapContext<ChickenVariant> var0) {
        ChickenVariants.register(var0, TEMPERATE, ChickenVariant.ModelType.NORMAL, "temperate_chicken", SpawnPrioritySelectors.fallback(0));
        ChickenVariants.register(var0, WARM, ChickenVariant.ModelType.NORMAL, "warm_chicken", BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS);
        ChickenVariants.register(var0, COLD, ChickenVariant.ModelType.COLD, "cold_chicken", BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS);
    }

    private static void register(BootstrapContext<ChickenVariant> var0, ResourceKey<ChickenVariant> var1, ChickenVariant.ModelType var2, String var3, TagKey<Biome> var4) {
        HolderSet.Named<Biome> var5 = var0.lookup(Registries.BIOME).getOrThrow(var4);
        ChickenVariants.register(var0, var1, var2, var3, SpawnPrioritySelectors.single(new BiomeCheck(var5), 1));
    }

    private static void register(BootstrapContext<ChickenVariant> var0, ResourceKey<ChickenVariant> var1, ChickenVariant.ModelType var2, String var3, SpawnPrioritySelectors var4) {
        ResourceLocation var5 = ResourceLocation.withDefaultNamespace("entity/chicken/" + var3);
        var0.register(var1, new ChickenVariant(new ModelAndTexture<ChickenVariant.ModelType>(var2, var5), var4));
    }
}

