/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.PigVariants;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.variant.SpawnContext;
import net.minecraft.world.entity.variant.VariantUtils;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;

public class Pig
extends Animal
implements ItemSteerable {
    private static final EntityDataAccessor<Integer> DATA_BOOST_TIME = SynchedEntityData.defineId(Pig.class, EntityDataSerializers.INT);
    private static final EntityDataAccessor<Holder<PigVariant>> DATA_VARIANT_ID = SynchedEntityData.defineId(Pig.class, EntityDataSerializers.PIG_VARIANT);
    public final ItemBasedSteering steering;

    public Pig(EntityType<? extends Pig> entitytypes, Level world) {
        super((EntityType<? extends Animal>)entitytypes, world);
        this.steering = new ItemBasedSteering(this.entityData, DATA_BOOST_TIME);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new FloatGoal(this));
        this.goalSelector.addGoal(1, new PanicGoal(this, 1.25));
        this.goalSelector.addGoal(3, new BreedGoal(this, 1.0));
        this.goalSelector.addGoal(4, new TemptGoal(this, 1.2, itemstack -> itemstack.is(Items.CARROT_ON_A_STICK), false));
        this.goalSelector.addGoal(4, new TemptGoal(this, 1.2, itemstack -> itemstack.is(ItemTags.PIG_FOOD), false));
        this.goalSelector.addGoal(5, new FollowParentGoal(this, 1.1));
        this.goalSelector.addGoal(6, new WaterAvoidingRandomStrollGoal(this, 1.0));
        this.goalSelector.addGoal(7, new LookAtPlayerGoal(this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, new RandomLookAroundGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    @Nullable
    public LivingEntity getControllingPassenger() {
        Player entityhuman;
        Entity entity;
        if (this.isSaddled() && (entity = this.getFirstPassenger()) instanceof Player && (entityhuman = (Player)entity).isHolding(Items.CARROT_ON_A_STICK)) {
            return entityhuman;
        }
        return super.getControllingPassenger();
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        if (DATA_BOOST_TIME.equals(datawatcherobject) && this.level().isClientSide) {
            this.steering.onSynced();
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(DATA_BOOST_TIME, 0);
        datawatcher_a.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.registryAccess(), PigVariants.DEFAULT));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        VariantUtils.writeVariant(valueoutput, this.getVariant());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        VariantUtils.readVariant(valueinput, Registries.PIG_VARIANT).ifPresent(this::setVariant);
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return SoundEvents.PIG_AMBIENT;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return SoundEvents.PIG_HURT;
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.PIG_DEATH;
    }

    @Override
    protected void playStepSound(BlockPos blockposition, BlockState iblockdata) {
        this.playSound(SoundEvents.PIG_STEP, 0.15f, 1.0f);
    }

    @Override
    public InteractionResult mobInteract(Player entityhuman, InteractionHand enumhand) {
        boolean flag = this.isFood(entityhuman.getItemInHand(enumhand));
        if (!flag && this.isSaddled() && !this.isVehicle() && !entityhuman.isSecondaryUseActive()) {
            if (!this.level().isClientSide) {
                entityhuman.startRiding(this);
            }
            return InteractionResult.SUCCESS;
        }
        InteractionResult enuminteractionresult = super.mobInteract(entityhuman, enumhand);
        if (!enuminteractionresult.consumesAction()) {
            ItemStack itemstack = entityhuman.getItemInHand(enumhand);
            return this.isEquippableInSlot(itemstack, EquipmentSlot.SADDLE) ? itemstack.interactLivingEntity(entityhuman, this, enumhand) : InteractionResult.PASS;
        }
        return enuminteractionresult;
    }

    @Override
    public boolean canUseSlot(EquipmentSlot enumitemslot) {
        return enumitemslot != EquipmentSlot.SADDLE ? super.canUseSlot(enumitemslot) : this.isAlive() && !this.isBaby();
    }

    @Override
    protected boolean canDispenserEquipIntoSlot(EquipmentSlot enumitemslot) {
        return enumitemslot == EquipmentSlot.SADDLE || super.canDispenserEquipIntoSlot(enumitemslot);
    }

    @Override
    protected Holder<SoundEvent> getEquipSound(EquipmentSlot enumitemslot, ItemStack itemstack, Equippable equippable) {
        return enumitemslot == EquipmentSlot.SADDLE ? SoundEvents.PIG_SADDLE : super.getEquipSound(enumitemslot, itemstack, equippable);
    }

    @Override
    public Vec3 getDismountLocationForPassenger(LivingEntity entityliving) {
        Direction enumdirection = this.getMotionDirection();
        if (enumdirection.getAxis() == Direction.Axis.Y) {
            return super.getDismountLocationForPassenger(entityliving);
        }
        int[][] aint = DismountHelper.offsetsForDirection(enumdirection);
        BlockPos blockposition = this.blockPosition();
        BlockPos.MutableBlockPos blockposition_mutableblockposition = new BlockPos.MutableBlockPos();
        for (Pose entitypose : entityliving.getDismountPoses()) {
            AABB axisalignedbb = entityliving.getLocalBoundsForPose(entitypose);
            for (int[] aint1 : aint) {
                blockposition_mutableblockposition.set(blockposition.getX() + aint1[0], blockposition.getY(), blockposition.getZ() + aint1[1]);
                double d0 = this.level().getBlockFloorHeight(blockposition_mutableblockposition);
                if (!DismountHelper.isBlockFloorValid(d0)) continue;
                Vec3 vec3d = Vec3.upFromBottomCenterOf(blockposition_mutableblockposition, d0);
                if (!DismountHelper.canDismountTo(this.level(), entityliving, axisalignedbb.move(vec3d))) continue;
                entityliving.setPose(entitypose);
                return vec3d;
            }
        }
        return super.getDismountLocationForPassenger(entityliving);
    }

    @Override
    public void thunderHit(ServerLevel worldserver, LightningBolt entitylightning) {
        if (worldserver.getDifficulty() != Difficulty.PEACEFUL) {
            ZombifiedPiglin entitypigzombie = this.convertTo(EntityType.ZOMBIFIED_PIGLIN, ConversionParams.single(this, false, true), entitypigzombie1 -> {
                if (this.getMainHandItem().isEmpty()) {
                    entitypigzombie1.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack(Items.GOLDEN_SWORD));
                }
                entitypigzombie1.setPersistenceRequired();
            }, null, null);
            if (CraftEventFactory.callPigZapEvent(this, entitylightning, entitypigzombie).isCancelled()) {
                return;
            }
            worldserver.addFreshEntity(entitypigzombie, CreatureSpawnEvent.SpawnReason.LIGHTNING);
            this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            if (entitypigzombie == null) {
                super.thunderHit(worldserver, entitylightning);
            }
        } else {
            super.thunderHit(worldserver, entitylightning);
        }
    }

    @Override
    protected void tickRidden(Player entityhuman, Vec3 vec3d) {
        super.tickRidden(entityhuman, vec3d);
        this.setRot(entityhuman.getYRot(), entityhuman.getXRot() * 0.5f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
        this.steering.tickBoost();
    }

    @Override
    protected Vec3 getRiddenInput(Player entityhuman, Vec3 vec3d) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    @Override
    protected float getRiddenSpeed(Player entityhuman) {
        return (float)(this.getAttributeValue(Attributes.MOVEMENT_SPEED) * 0.225 * (double)this.steering.boostFactor());
    }

    @Override
    public boolean boost() {
        return this.steering.boost(this.getRandom());
    }

    @Override
    @Nullable
    public Pig getBreedOffspring(ServerLevel worldserver, AgeableMob entityageable) {
        Pig entitypig = EntityType.PIG.create(worldserver, EntitySpawnReason.BREEDING);
        if (entitypig != null && entityageable instanceof Pig) {
            Pig entitypig1 = (Pig)entityageable;
            entitypig.setVariant(this.random.nextBoolean() ? this.getVariant() : entitypig1.getVariant());
        }
        return entitypig;
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(ItemTags.PIG_FOOD);
    }

    @Override
    public Vec3 getLeashOffset() {
        return new Vec3(0.0, 0.6f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    public void setVariant(Holder<PigVariant> holder) {
        this.entityData.set(DATA_VARIANT_ID, holder);
    }

    public Holder<PigVariant> getVariant() {
        return this.entityData.get(DATA_VARIANT_ID);
    }

    @Override
    @Nullable
    public <T> T get(DataComponentType<? extends T> datacomponenttype) {
        return datacomponenttype == DataComponents.PIG_VARIANT ? Pig.castComponentValue(datacomponenttype, this.getVariant()) : super.get(datacomponenttype);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
        this.applyImplicitComponentIfPresent(datacomponentgetter, DataComponents.PIG_VARIANT);
        super.applyImplicitComponents(datacomponentgetter);
    }

    @Override
    protected <T> boolean applyImplicitComponent(DataComponentType<T> datacomponenttype, T t0) {
        if (datacomponenttype == DataComponents.PIG_VARIANT) {
            this.setVariant(Pig.castComponentValue(DataComponents.PIG_VARIANT, t0));
            return true;
        }
        return super.applyImplicitComponent(datacomponenttype, t0);
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldaccess, DifficultyInstance difficultydamagescaler, EntitySpawnReason entityspawnreason, @Nullable SpawnGroupData groupdataentity) {
        VariantUtils.selectVariantToSpawn(SpawnContext.create(worldaccess, this.blockPosition()), Registries.PIG_VARIANT).ifPresent(this::setVariant);
        return super.finalizeSpawn(worldaccess, difficultydamagescaler, entityspawnreason, groupdataentity);
    }
}

