/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.armadillo;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.armadillo.ArmadilloAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import org.bukkit.event.entity.EntityDamageEvent;

public class Armadillo
extends Animal {
    public static final float BABY_SCALE = 0.6f;
    public static final float MAX_HEAD_ROTATION_EXTENT = 32.5f;
    public static final int SCARE_CHECK_INTERVAL = 80;
    private static final double SCARE_DISTANCE_HORIZONTAL = 7.0;
    private static final double SCARE_DISTANCE_VERTICAL = 2.0;
    private static final EntityDataAccessor<ArmadilloState> ARMADILLO_STATE = SynchedEntityData.defineId(Armadillo.class, EntityDataSerializers.ARMADILLO_STATE);
    private long inStateTicks = 0L;
    public final AnimationState rollOutAnimationState = new AnimationState();
    public final AnimationState rollUpAnimationState = new AnimationState();
    public final AnimationState peekAnimationState = new AnimationState();
    private int scuteTime;
    private boolean peekReceivedClient = false;

    public Armadillo(EntityType<? extends Animal> entitytypes, Level world) {
        super(entitytypes, world);
        this.getNavigation().setCanFloat(true);
        this.scuteTime = this.pickNextScuteDropTime();
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel worldserver, AgeableMob entityageable) {
        return EntityType.ARMADILLO.create(worldserver, EntitySpawnReason.BREEDING);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 12.0).add(Attributes.MOVEMENT_SPEED, 0.14);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        super.defineSynchedData(datawatcher_a);
        datawatcher_a.define(ARMADILLO_STATE, ArmadilloState.IDLE);
    }

    public boolean isScared() {
        return this.entityData.get(ARMADILLO_STATE) != ArmadilloState.IDLE;
    }

    public boolean shouldHideInShell() {
        return this.getState().shouldHideInShell(this.inStateTicks);
    }

    public boolean shouldSwitchToScaredState() {
        return this.getState() == ArmadilloState.ROLLING && this.inStateTicks > (long)ArmadilloState.ROLLING.animationDuration();
    }

    public ArmadilloState getState() {
        return this.entityData.get(ARMADILLO_STATE);
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain(this);
    }

    public void switchToState(ArmadilloState armadillo_a) {
        this.entityData.set(ARMADILLO_STATE, armadillo_a);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> datawatcherobject) {
        if (ARMADILLO_STATE.equals(datawatcherobject)) {
            this.inStateTicks = 0L;
        }
        super.onSyncedDataUpdated(datawatcherobject);
    }

    protected Brain.Provider<Armadillo> brainProvider() {
        return ArmadilloAi.brainProvider();
    }

    @Override
    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return ArmadilloAi.makeBrain(this.brainProvider().makeBrain(dynamic));
    }

    @Override
    protected void customServerAiStep(ServerLevel worldserver) {
        ProfilerFiller gameprofilerfiller = Profiler.get();
        gameprofilerfiller.push("armadilloBrain");
        this.brain.tick(worldserver, this);
        gameprofilerfiller.pop();
        gameprofilerfiller.push("armadilloActivityUpdate");
        ArmadilloAi.updateActivity(this);
        gameprofilerfiller.pop();
        if (this.isAlive() && !this.isBaby() && --this.scuteTime <= 0) {
            this.forceDrops = true;
            if (this.dropFromGiftLootTable(worldserver, BuiltInLootTables.ARMADILLO_SHED, this::spawnAtLocation)) {
                this.playSound(SoundEvents.ARMADILLO_SCUTE_DROP, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                this.gameEvent(GameEvent.ENTITY_PLACE);
            }
            this.forceDrops = false;
            this.scuteTime = this.pickNextScuteDropTime();
        }
        super.customServerAiStep(worldserver);
    }

    private int pickNextScuteDropTime() {
        return this.random.nextInt(20 * TimeUtil.SECONDS_PER_MINUTE * 5) + 20 * TimeUtil.SECONDS_PER_MINUTE * 5;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
        if (this.isScared()) {
            this.clampHeadRotationToBody();
        }
        ++this.inStateTicks;
    }

    @Override
    public float getAgeScale() {
        return this.isBaby() ? 0.6f : 1.0f;
    }

    private void setupAnimationStates() {
        switch (this.getState().ordinal()) {
            case 0: {
                this.rollOutAnimationState.stop();
                this.rollUpAnimationState.stop();
                this.peekAnimationState.stop();
                break;
            }
            case 1: {
                this.rollOutAnimationState.stop();
                this.rollUpAnimationState.startIfStopped(this.tickCount);
                this.peekAnimationState.stop();
                break;
            }
            case 2: {
                this.rollOutAnimationState.stop();
                this.rollUpAnimationState.stop();
                if (this.peekReceivedClient) {
                    this.peekAnimationState.stop();
                    this.peekReceivedClient = false;
                }
                if (this.inStateTicks == 0L) {
                    this.peekAnimationState.start(this.tickCount);
                    this.peekAnimationState.fastForward(ArmadilloState.SCARED.animationDuration(), 1.0f);
                    break;
                }
                this.peekAnimationState.startIfStopped(this.tickCount);
                break;
            }
            case 3: {
                this.rollOutAnimationState.startIfStopped(this.tickCount);
                this.rollUpAnimationState.stop();
                this.peekAnimationState.stop();
            }
        }
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 64 && this.level().isClientSide) {
            this.peekReceivedClient = true;
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMADILLO_PEEK, this.getSoundSource(), 1.0f, 1.0f, false);
        } else {
            super.handleEntityEvent(b0);
        }
    }

    @Override
    public boolean isFood(ItemStack itemstack) {
        return itemstack.is(ItemTags.ARMADILLO_FOOD);
    }

    public static boolean checkArmadilloSpawnRules(EntityType<Armadillo> entitytypes, LevelAccessor generatoraccess, EntitySpawnReason entityspawnreason, BlockPos blockposition, RandomSource randomsource) {
        return generatoraccess.getBlockState(blockposition.below()).is(BlockTags.ARMADILLO_SPAWNABLE_ON) && Armadillo.isBrightEnoughToSpawn(generatoraccess, blockposition);
    }

    public boolean isScaredBy(LivingEntity entityliving) {
        if (!this.getBoundingBox().inflate(7.0, 2.0, 7.0).intersects(entityliving.getBoundingBox())) {
            return false;
        }
        if (entityliving.getType().is(EntityTypeTags.UNDEAD)) {
            return true;
        }
        if (this.getLastHurtByMob() == entityliving) {
            return true;
        }
        if (entityliving instanceof Player) {
            Player entityhuman = (Player)entityliving;
            return entityhuman.isSpectator() ? false : entityhuman.isSprinting() || entityhuman.isPassenger();
        }
        return false;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.store("state", ArmadilloState.CODEC, this.getState());
        valueoutput.putInt("scute_time", this.scuteTime);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.switchToState(valueinput.read("state", ArmadilloState.CODEC).orElse(ArmadilloState.IDLE));
        valueinput.getInt("scute_time").ifPresent(integer -> {
            this.scuteTime = integer;
        });
    }

    public void rollUp() {
        if (!this.isScared()) {
            this.stopInPlace();
            this.resetLove();
            this.gameEvent(GameEvent.ENTITY_ACTION);
            this.makeSound(SoundEvents.ARMADILLO_ROLL);
            this.switchToState(ArmadilloState.ROLLING);
        }
    }

    public void rollOut() {
        if (this.isScared()) {
            this.gameEvent(GameEvent.ENTITY_ACTION);
            this.makeSound(SoundEvents.ARMADILLO_UNROLL_FINISH);
            this.switchToState(ArmadilloState.IDLE);
        }
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (this.isScared()) {
            f = (f - 1.0f) / 2.0f;
        }
        return super.hurtServer(worldserver, damagesource, f);
    }

    @Override
    public boolean actuallyHurt(ServerLevel worldserver, DamageSource damagesource, float f, EntityDamageEvent event) {
        boolean damageResult = super.actuallyHurt(worldserver, damagesource, f, event);
        if (!damageResult) {
            return false;
        }
        if (!this.isNoAi() && !this.isDeadOrDying()) {
            if (damagesource.getEntity() instanceof LivingEntity) {
                this.getBrain().setMemoryWithExpiry(MemoryModuleType.DANGER_DETECTED_RECENTLY, true, 80L);
                if (this.canStayRolledUp()) {
                    this.rollUp();
                }
            } else if (damagesource.is(DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES)) {
                this.rollOut();
            }
        }
        return true;
    }

    @Override
    public InteractionResult mobInteract(Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        if (itemstack.is(Items.BRUSH) && this.brushOffScute()) {
            itemstack.hurtAndBreak(16, (LivingEntity)entityhuman, Armadillo.getSlotForHand(enumhand));
            return InteractionResult.SUCCESS;
        }
        return this.isScared() ? InteractionResult.FAIL : super.mobInteract(entityhuman, enumhand);
    }

    public boolean brushOffScute() {
        if (this.isBaby()) {
            return false;
        }
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.forceDrops = true;
            this.spawnAtLocation(worldserver, new ItemStack(Items.ARMADILLO_SCUTE));
            this.forceDrops = false;
            this.gameEvent(GameEvent.ENTITY_INTERACT);
            this.playSound(SoundEvents.ARMADILLO_BRUSH);
        }
        return true;
    }

    public boolean canStayRolledUp() {
        return !this.isPanicking() && !this.isInLiquid() && !this.isLeashed() && !this.isPassenger() && !this.isVehicle();
    }

    @Override
    public boolean canFallInLove() {
        return super.canFallInLove() && !this.isScared();
    }

    @Override
    protected SoundEvent getAmbientSound() {
        return this.isScared() ? null : SoundEvents.ARMADILLO_AMBIENT;
    }

    @Override
    protected void playEatingSound() {
        this.makeSound(SoundEvents.ARMADILLO_EAT);
    }

    @Override
    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMADILLO_DEATH;
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource damagesource) {
        return this.isScared() ? SoundEvents.ARMADILLO_HURT_REDUCED : SoundEvents.ARMADILLO_HURT;
    }

    @Override
    protected void playStepSound(BlockPos blockposition, BlockState iblockdata) {
        this.playSound(SoundEvents.ARMADILLO_STEP, 0.15f, 1.0f);
    }

    @Override
    public int getMaxHeadYRot() {
        return this.isScared() ? 0 : 32;
    }

    @Override
    protected BodyRotationControl createBodyControl() {
        return new BodyRotationControl(this){

            @Override
            public void clientTick() {
                if (!Armadillo.this.isScared()) {
                    super.clientTick();
                }
            }
        };
    }

    public static enum ArmadilloState implements StringRepresentable
    {
        IDLE("idle", false, 0, 0){

            @Override
            public boolean shouldHideInShell(long i) {
                return false;
            }
        }
        ,
        ROLLING("rolling", true, 10, 1){

            @Override
            public boolean shouldHideInShell(long i) {
                return i > 5L;
            }
        }
        ,
        SCARED("scared", true, 50, 2){

            @Override
            public boolean shouldHideInShell(long i) {
                return true;
            }
        }
        ,
        UNROLLING("unrolling", true, 30, 3){

            @Override
            public boolean shouldHideInShell(long i) {
                return i < 26L;
            }
        };

        static final Codec<ArmadilloState> CODEC;
        private static final IntFunction<ArmadilloState> BY_ID;
        public static final StreamCodec<ByteBuf, ArmadilloState> STREAM_CODEC;
        private final String name;
        private final boolean isThreatened;
        private final int animationDuration;
        private final int id;

        private ArmadilloState(String s, boolean flag, int i, int j) {
            this.name = s;
            this.isThreatened = flag;
            this.animationDuration = i;
            this.id = j;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private int id() {
            return this.id;
        }

        public abstract boolean shouldHideInShell(long var1);

        public boolean isThreatened() {
            return this.isThreatened;
        }

        public int animationDuration() {
            return this.animationDuration;
        }

        static {
            CODEC = StringRepresentable.fromEnum(ArmadilloState::values);
            BY_ID = ByIdMap.continuous(ArmadilloState::id, ArmadilloState.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, ArmadilloState::id);
        }
    }
}

