/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.BlockAttachedEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class LeashFenceKnotEntity
extends BlockAttachedEntity {
    public static final double OFFSET_Y = 0.375;

    public LeashFenceKnotEntity(EntityType<? extends LeashFenceKnotEntity> entitytypes, Level world) {
        super((EntityType<? extends BlockAttachedEntity>)entitytypes, world);
    }

    public LeashFenceKnotEntity(Level world, BlockPos blockposition) {
        super(EntityType.LEASH_KNOT, world, blockposition);
        this.setPos(blockposition.getX(), blockposition.getY(), blockposition.getZ());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
    }

    @Override
    protected void recalculateBoundingBox() {
        this.setPosRaw((double)this.pos.getX() + 0.5, (double)this.pos.getY() + 0.375, (double)this.pos.getZ() + 0.5);
        double d0 = (double)this.getType().getWidth() / 2.0;
        double d1 = this.getType().getHeight();
        this.setBoundingBox(new AABB(this.getX() - d0, this.getY(), this.getZ() - d0, this.getX() + d0, this.getY() + d1, this.getZ() + d0));
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double d0) {
        return d0 < 1024.0;
    }

    @Override
    public void dropItem(ServerLevel worldserver, @Nullable Entity entity) {
        this.playSound(SoundEvents.LEAD_UNTIED, 1.0f, 1.0f);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
    }

    @Override
    public InteractionResult interact(Player entityhuman, InteractionHand enumhand) {
        Object enuminteractionresult_d;
        InteractionResult enuminteractionresult;
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (entityhuman.getItemInHand(enumhand).is(Items.SHEARS) && (enuminteractionresult = super.interact(entityhuman, enumhand)) instanceof InteractionResult.Success && ((InteractionResult.Success)(enuminteractionresult_d = (InteractionResult.Success)enuminteractionresult)).wasItemInteraction()) {
            return enuminteractionresult;
        }
        boolean flag = false;
        for (Leashable leashable : Leashable.leashableLeashedTo(entityhuman)) {
            Entity leashed;
            if (!leashable.canHaveALeashAttachedTo(this)) continue;
            if (leashable instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable), this, entityhuman, enumhand).isCancelled()) {
                ((ServerPlayer)entityhuman).connection.send(new ClientboundSetEntityLinkPacket(leashed, leashable.getLeashHolder()));
                flag = true;
                continue;
            }
            leashable.setLeashedTo(this, true);
            flag = true;
        }
        boolean flag1 = false;
        if (!flag && !entityhuman.isSecondaryUseActive()) {
            for (Leashable leashable1 : Leashable.leashableLeashedTo(this)) {
                if (!leashable1.canHaveALeashAttachedTo(entityhuman)) continue;
                if (leashable1 instanceof Entity) {
                    Entity leashed = (Entity)((Object)leashable1);
                    if (CraftEventFactory.callPlayerUnleashEntityEvent(leashed, entityhuman, enumhand).isCancelled()) continue;
                    if (CraftEventFactory.callPlayerLeashEntityEvent(leashed, this, entityhuman, enumhand).isCancelled()) {
                        ((ServerPlayer)entityhuman).connection.send(new ClientboundSetEntityLinkPacket(leashed, leashable1.getLeashHolder()));
                        flag1 = true;
                        continue;
                    }
                }
                leashable1.setLeashedTo(entityhuman, true);
                flag1 = true;
            }
        }
        if (!flag && !flag1) {
            return super.interact(entityhuman, enumhand);
        }
        this.gameEvent(GameEvent.BLOCK_ATTACH, entityhuman);
        this.playSound(SoundEvents.LEAD_TIED);
        return InteractionResult.SUCCESS;
    }

    @Override
    public void notifyLeasheeRemoved(Leashable leashable) {
        if (Leashable.leashableLeashedTo(this).isEmpty()) {
            this.discard(EntityRemoveEvent.Cause.DROP);
        }
    }

    @Override
    public boolean survives() {
        return this.level().getBlockState(this.pos).is(BlockTags.FENCES);
    }

    public static LeashFenceKnotEntity getOrCreateKnot(Level world, BlockPos blockposition) {
        int i = blockposition.getX();
        int j = blockposition.getY();
        int k = blockposition.getZ();
        for (LeashFenceKnotEntity entityleash : world.getEntitiesOfClass(LeashFenceKnotEntity.class, new AABB((double)i - 1.0, (double)j - 1.0, (double)k - 1.0, (double)i + 1.0, (double)j + 1.0, (double)k + 1.0))) {
            if (!entityleash.getPos().equals(blockposition)) continue;
            return entityleash;
        }
        LeashFenceKnotEntity entityleash1 = new LeashFenceKnotEntity(world, blockposition);
        world.addFreshEntity(entityleash1);
        return entityleash1;
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.LEAD_TIED, 1.0f, 1.0f);
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entitytrackerentry) {
        return new ClientboundAddEntityPacket((Entity)this, 0, this.getPos());
    }

    @Override
    public Vec3 getRopeHoldPosition(float f) {
        return this.getPosition(f).add(0.0, 0.2, 0.0);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.LEAD);
    }
}

