/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public abstract class PatrollingMonster
extends Monster {
    private static final boolean DEFAULT_PATROL_LEADER = false;
    private static final boolean DEFAULT_PATROLLING = false;
    @Nullable
    private BlockPos patrolTarget;
    private boolean patrolLeader = false;
    private boolean patrolling = false;

    protected PatrollingMonster(EntityType<? extends PatrollingMonster> var0, Level var1) {
        super((EntityType<? extends Monster>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, new LongDistancePatrolGoal<PatrollingMonster>(this, 0.7, 0.595));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.storeNullable("patrol_target", BlockPos.CODEC, this.patrolTarget);
        var0.putBoolean("PatrolLeader", this.patrolLeader);
        var0.putBoolean("Patrolling", this.patrolling);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.patrolTarget = var0.read("patrol_target", BlockPos.CODEC).orElse(null);
        this.patrolLeader = var0.getBooleanOr("PatrolLeader", false);
        this.patrolling = var0.getBooleanOr("Patrolling", false);
    }

    public boolean canBeLeader() {
        return true;
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor var0, DifficultyInstance var1, EntitySpawnReason var2, @Nullable SpawnGroupData var3) {
        if (var2 != EntitySpawnReason.PATROL && var2 != EntitySpawnReason.EVENT && var2 != EntitySpawnReason.STRUCTURE && var0.getRandom().nextFloat() < 0.06f && this.canBeLeader()) {
            this.patrolLeader = true;
        }
        if (this.isPatrolLeader()) {
            this.setItemSlot(EquipmentSlot.HEAD, Raid.getOminousBannerInstance(this.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
            this.setDropChance(EquipmentSlot.HEAD, 2.0f);
        }
        if (var2 == EntitySpawnReason.PATROL) {
            this.patrolling = true;
        }
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    public static boolean checkPatrollingMonsterSpawnRules(EntityType<? extends PatrollingMonster> var0, LevelAccessor var1, EntitySpawnReason var2, BlockPos var3, RandomSource var4) {
        if (var1.getBrightness(LightLayer.BLOCK, var3) > 8) {
            return false;
        }
        return PatrollingMonster.checkAnyLightMonsterSpawnRules(var0, var1, var2, var3, var4);
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.patrolling || var0 > 16384.0;
    }

    public void setPatrolTarget(BlockPos var0) {
        this.patrolTarget = var0;
        this.patrolling = true;
    }

    public BlockPos getPatrolTarget() {
        return this.patrolTarget;
    }

    public boolean hasPatrolTarget() {
        return this.patrolTarget != null;
    }

    public void setPatrolLeader(boolean var0) {
        this.patrolLeader = var0;
        this.patrolling = true;
    }

    public boolean isPatrolLeader() {
        return this.patrolLeader;
    }

    public boolean canJoinPatrol() {
        return true;
    }

    public void findPatrolTarget() {
        this.patrolTarget = this.blockPosition().offset(-500 + this.random.nextInt(1000), 0, -500 + this.random.nextInt(1000));
        this.patrolling = true;
    }

    protected boolean isPatrolling() {
        return this.patrolling;
    }

    protected void setPatrolling(boolean var0) {
        this.patrolling = var0;
    }

    public static class LongDistancePatrolGoal<T extends PatrollingMonster>
    extends Goal {
        private static final int NAVIGATION_FAILED_COOLDOWN = 200;
        private final T mob;
        private final double speedModifier;
        private final double leaderSpeedModifier;
        private long cooldownUntil;

        public LongDistancePatrolGoal(T var0, double var1, double var3) {
            this.mob = var0;
            this.speedModifier = var1;
            this.leaderSpeedModifier = var3;
            this.cooldownUntil = -1L;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean canUse() {
            boolean var0 = ((Entity)this.mob).level().getGameTime() < this.cooldownUntil;
            return ((PatrollingMonster)this.mob).isPatrolling() && ((Mob)this.mob).getTarget() == null && !((Entity)this.mob).hasControllingPassenger() && ((PatrollingMonster)this.mob).hasPatrolTarget() && !var0;
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        @Override
        public void tick() {
            boolean var0 = ((PatrollingMonster)this.mob).isPatrolLeader();
            PathNavigation var1 = ((Mob)this.mob).getNavigation();
            if (var1.isDone()) {
                List<PatrollingMonster> var2 = this.findPatrolCompanions();
                if (((PatrollingMonster)this.mob).isPatrolling() && var2.isEmpty()) {
                    ((PatrollingMonster)this.mob).setPatrolling(false);
                } else if (!var0 || !((PatrollingMonster)this.mob).getPatrolTarget().closerToCenterThan(((Entity)this.mob).position(), 10.0)) {
                    Vec3 var3 = Vec3.atBottomCenterOf(((PatrollingMonster)this.mob).getPatrolTarget());
                    Vec3 var4 = ((Entity)this.mob).position();
                    Vec3 var5 = var4.subtract(var3);
                    var3 = var5.yRot(90.0f).scale(0.4).add(var3);
                    Vec3 var6 = var3.subtract(var4).normalize().scale(10.0).add(var4);
                    BlockPos var7 = BlockPos.containing(var6);
                    var7 = ((Entity)this.mob).level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, var7);
                    if (!var1.moveTo(var7.getX(), var7.getY(), var7.getZ(), var0 ? this.leaderSpeedModifier : this.speedModifier)) {
                        this.moveRandomly();
                        this.cooldownUntil = ((Entity)this.mob).level().getGameTime() + 200L;
                    } else if (var0) {
                        for (PatrollingMonster var9 : var2) {
                            var9.setPatrolTarget(var7);
                        }
                    }
                } else {
                    ((PatrollingMonster)this.mob).findPatrolTarget();
                }
            }
        }

        private List<PatrollingMonster> findPatrolCompanions() {
            return ((Entity)this.mob).level().getEntitiesOfClass(PatrollingMonster.class, ((Entity)this.mob).getBoundingBox().inflate(16.0), var0 -> var0.canJoinPatrol() && !var0.is((Entity)this.mob));
        }

        private boolean moveRandomly() {
            RandomSource var0 = ((Entity)this.mob).getRandom();
            BlockPos var1 = ((Entity)this.mob).level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ((Entity)this.mob).blockPosition().offset(-8 + var0.nextInt(16), 0, -8 + var0.nextInt(16)));
            return ((Mob)this.mob).getNavigation().moveTo(var1.getX(), var1.getY(), var1.getZ(), this.speedModifier);
        }
    }
}

