/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.windcharge.BreezeWindCharge;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class Shoot
extends Behavior<Breeze> {
    private static final int ATTACK_RANGE_MAX_SQRT = 256;
    private static final int UNCERTAINTY_BASE = 5;
    private static final int UNCERTAINTY_MULTIPLIER = 4;
    private static final float PROJECTILE_MOVEMENT_SCALE = 0.7f;
    private static final int SHOOT_INITIAL_DELAY_TICKS = Math.round(15.0f);
    private static final int SHOOT_RECOVER_DELAY_TICKS = Math.round(4.0f);
    private static final int SHOOT_COOLDOWN_TICKS = Math.round(10.0f);

    @VisibleForTesting
    public Shoot() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.BREEZE_SHOOT_COOLDOWN, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.BREEZE_SHOOT_CHARGING, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.BREEZE_SHOOT_RECOVERING, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.BREEZE_SHOOT, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.BREEZE_JUMP_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), SHOOT_INITIAL_DELAY_TICKS + 1 + SHOOT_RECOVER_DELAY_TICKS);
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel var0, Breeze var12) {
        if (var12.getPose() != Pose.STANDING) {
            return false;
        }
        return var12.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).map(var1 -> Shoot.isTargetWithinRange(var12, var1)).map(var1 -> {
            if (!var1.booleanValue()) {
                var12.getBrain().eraseMemory(MemoryModuleType.BREEZE_SHOOT);
            }
            return var1;
        }).orElse(false);
    }

    @Override
    protected boolean canStillUse(ServerLevel var0, Breeze var1, long var2) {
        return var1.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && var1.getBrain().hasMemoryValue(MemoryModuleType.BREEZE_SHOOT);
    }

    @Override
    protected void start(ServerLevel var0, Breeze var12, long var2) {
        var12.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(var1 -> var12.setPose(Pose.SHOOTING));
        var12.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_CHARGING, Unit.INSTANCE, SHOOT_INITIAL_DELAY_TICKS);
        var12.playSound(SoundEvents.BREEZE_INHALE, 1.0f, 1.0f);
    }

    @Override
    protected void stop(ServerLevel var0, Breeze var1, long var2) {
        if (var1.getPose() == Pose.SHOOTING) {
            var1.setPose(Pose.STANDING);
        }
        var1.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_COOLDOWN, Unit.INSTANCE, SHOOT_COOLDOWN_TICKS);
        var1.getBrain().eraseMemory(MemoryModuleType.BREEZE_SHOOT);
    }

    @Override
    protected void tick(ServerLevel var0, Breeze var1, long var2) {
        Brain<Breeze> var4 = var1.getBrain();
        LivingEntity var5 = var4.getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (var5 == null) {
            return;
        }
        var1.lookAt(EntityAnchorArgument.Anchor.EYES, var5.position());
        if (var4.getMemory(MemoryModuleType.BREEZE_SHOOT_CHARGING).isPresent() || var4.getMemory(MemoryModuleType.BREEZE_SHOOT_RECOVERING).isPresent()) {
            return;
        }
        var4.setMemoryWithExpiry(MemoryModuleType.BREEZE_SHOOT_RECOVERING, Unit.INSTANCE, SHOOT_RECOVER_DELAY_TICKS);
        double var6 = var5.getX() - var1.getX();
        double var8 = var5.getY(var5.isPassenger() ? 0.8 : 0.3) - var1.getFiringYPosition();
        double var10 = var5.getZ() - var1.getZ();
        Projectile.spawnProjectileUsingShoot(new BreezeWindCharge(var1, (Level)var0), var0, ItemStack.EMPTY, var6, var8, var10, 0.7f, 5 - var0.getDifficulty().getId() * 4);
        var1.playSound(SoundEvents.BREEZE_SHOOT, 1.5f, 1.0f);
    }

    private static boolean isTargetWithinRange(Breeze var0, LivingEntity var1) {
        double var2 = var0.position().distanceToSqr(var1.position());
        return var2 < 256.0;
    }

    @Override
    protected /* synthetic */ void stop(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.stop(serverLevel, (Breeze)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void tick(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.tick(serverLevel, (Breeze)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void start(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.start(serverLevel, (Breeze)livingEntity, l);
    }
}

