/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundSetPlayerInventoryPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class Inventory
implements Container,
Nameable {
    public static final int POP_TIME_DURATION = 5;
    public static final int INVENTORY_SIZE = 36;
    public static final int SELECTION_SIZE = 9;
    public static final int SLOT_OFFHAND = 40;
    public static final int SLOT_BODY_ARMOR = 41;
    public static final int SLOT_SADDLE = 42;
    public static final int NOT_FOUND_INDEX = -1;
    public static final Int2ObjectMap<EquipmentSlot> EQUIPMENT_SLOT_MAPPING = new Int2ObjectArrayMap(Map.of(EquipmentSlot.FEET.getIndex(36), EquipmentSlot.FEET, EquipmentSlot.LEGS.getIndex(36), EquipmentSlot.LEGS, EquipmentSlot.CHEST.getIndex(36), EquipmentSlot.CHEST, EquipmentSlot.HEAD.getIndex(36), EquipmentSlot.HEAD, 40, EquipmentSlot.OFFHAND, 41, EquipmentSlot.BODY, 42, EquipmentSlot.SADDLE));
    private final NonNullList<ItemStack> items;
    private int selected;
    public final Player player;
    private final EntityEquipment equipment;
    private int timesChanged;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 99;

    @Override
    public List<ItemStack> getContents() {
        ArrayList<ItemStack> combined = new ArrayList<ItemStack>(this.getContainerSize());
        for (ItemStack sub : this) {
            combined.add(sub);
        }
        return combined;
    }

    public List<ItemStack> getArmorContents() {
        ArrayList<ItemStack> combined = new ArrayList<ItemStack>(4);
        for (int i = 36; i < 40; ++i) {
            combined.add(this.getItem(i));
        }
        return combined;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.player.getBukkitEntity();
    }

    @Override
    public int getMaxStackSize() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return this.player.getBukkitEntity().getLocation();
    }

    public Inventory(Player entityhuman, EntityEquipment entityequipment) {
        this.items = NonNullList.withSize(36, ItemStack.EMPTY);
        this.player = entityhuman;
        this.equipment = entityequipment;
    }

    public int getSelectedSlot() {
        return this.selected;
    }

    public void setSelectedSlot(int i) {
        if (!Inventory.isHotbarSlot(i)) {
            throw new IllegalArgumentException("Invalid selected slot");
        }
        this.selected = i;
    }

    public ItemStack getSelectedItem() {
        return this.items.get(this.selected);
    }

    public ItemStack setSelectedItem(ItemStack itemstack) {
        return this.items.set(this.selected, itemstack);
    }

    public static int getSelectionSize() {
        return 9;
    }

    public NonNullList<ItemStack> getNonEquipmentItems() {
        return this.items;
    }

    private boolean hasRemainingSpaceForItem(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack.isEmpty() && ItemStack.isSameItemSameComponents(itemstack, itemstack1) && itemstack.isStackable() && itemstack.getCount() < this.getMaxStackSize(itemstack);
    }

    public int canHold(ItemStack itemstack) {
        int remains = itemstack.getCount();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack1 = this.getItem(i);
            if (itemstack1.isEmpty()) {
                return itemstack.getCount();
            }
            if (this.hasRemainingSpaceForItem(itemstack1, itemstack)) {
                remains -= (itemstack1.getMaxStackSize() < this.getMaxStackSize() ? itemstack1.getMaxStackSize() : this.getMaxStackSize()) - itemstack1.getCount();
            }
            if (remains > 0) continue;
            return itemstack.getCount();
        }
        ItemStack offhandItemStack = this.equipment.get(EquipmentSlot.OFFHAND);
        if (this.hasRemainingSpaceForItem(offhandItemStack, itemstack)) {
            remains -= (offhandItemStack.getMaxStackSize() < this.getMaxStackSize() ? offhandItemStack.getMaxStackSize() : this.getMaxStackSize()) - offhandItemStack.getCount();
        }
        if (remains <= 0) {
            return itemstack.getCount();
        }
        return itemstack.getCount() - remains;
    }

    public int getFreeSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public void addAndPickItem(ItemStack itemstack) {
        int i;
        this.setSelectedSlot(this.getSuitableHotbarSlot());
        if (!this.items.get(this.selected).isEmpty() && (i = this.getFreeSlot()) != -1) {
            this.items.set(i, this.items.get(this.selected));
        }
        this.items.set(this.selected, itemstack);
    }

    public void pickSlot(int i) {
        this.setSelectedSlot(this.getSuitableHotbarSlot());
        ItemStack itemstack = this.items.get(this.selected);
        this.items.set(this.selected, this.items.get(i));
        this.items.set(i, itemstack);
    }

    public static boolean isHotbarSlot(int i) {
        return i >= 0 && i < 9;
    }

    public int findSlotMatchingItem(ItemStack itemstack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).isEmpty() || !ItemStack.isSameItemSameComponents(itemstack, this.items.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static boolean isUsableForCrafting(ItemStack itemstack) {
        return !itemstack.isDamaged() && !itemstack.isEnchanted() && !itemstack.has(DataComponents.CUSTOM_NAME);
    }

    public int findSlotMatchingCraftingIngredient(Holder<Item> holder, ItemStack itemstack) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack1 = this.items.get(i);
            if (itemstack1.isEmpty() || !itemstack1.is(holder) || !Inventory.isUsableForCrafting(itemstack1) || !itemstack.isEmpty() && !ItemStack.isSameItemSameComponents(itemstack, itemstack1)) continue;
            return i;
        }
        return -1;
    }

    public int getSuitableHotbarSlot() {
        for (int i = 0; i < 9; ++i) {
            int j = (this.selected + i) % 9;
            if (!this.items.get(j).isEmpty()) continue;
            return j;
        }
        for (int k = 0; k < 9; ++k) {
            int l = (this.selected + k) % 9;
            if (this.items.get(l).isEnchanted()) continue;
            return l;
        }
        return this.selected;
    }

    public int clearOrCountMatchingItems(Predicate<ItemStack> predicate, int i, Container iinventory) {
        int j = 0;
        boolean flag = i == 0;
        j += ContainerHelper.clearOrCountMatchingItems(this, predicate, i - j, flag);
        j += ContainerHelper.clearOrCountMatchingItems(iinventory, predicate, i - j, flag);
        ItemStack itemstack = this.player.containerMenu.getCarried();
        j += ContainerHelper.clearOrCountMatchingItems(itemstack, predicate, i - j, flag);
        if (itemstack.isEmpty()) {
            this.player.containerMenu.setCarried(ItemStack.EMPTY);
        }
        return j;
    }

    private int addResource(ItemStack itemstack) {
        int i = this.getSlotWithRemainingSpace(itemstack);
        if (i == -1) {
            i = this.getFreeSlot();
        }
        return i == -1 ? itemstack.getCount() : this.addResource(i, itemstack);
    }

    private int addResource(int i, ItemStack itemstack) {
        int k;
        int l;
        int j = itemstack.getCount();
        ItemStack itemstack1 = this.getItem(i);
        if (itemstack1.isEmpty()) {
            itemstack1 = itemstack.copyWithCount(0);
            this.setItem(i, itemstack1);
        }
        if ((l = Math.min(j, k = this.getMaxStackSize(itemstack1) - itemstack1.getCount())) == 0) {
            return j;
        }
        itemstack1.grow(l);
        itemstack1.setPopTime(5);
        return j -= l;
    }

    public int getSlotWithRemainingSpace(ItemStack itemstack) {
        if (this.hasRemainingSpaceForItem(this.getItem(this.selected), itemstack)) {
            return this.selected;
        }
        if (this.hasRemainingSpaceForItem(this.getItem(40), itemstack)) {
            return 40;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!this.hasRemainingSpaceForItem(this.items.get(i), itemstack)) continue;
            return i;
        }
        return -1;
    }

    public void tick() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = this.getItem(i);
            if (itemstack.isEmpty()) continue;
            itemstack.inventoryTick(this.player.level(), this.player, i == this.selected ? EquipmentSlot.MAINHAND : null);
        }
    }

    public boolean add(ItemStack itemstack) {
        return this.add(-1, itemstack);
    }

    public boolean add(int i, ItemStack itemstack) {
        if (itemstack.isEmpty()) {
            return false;
        }
        try {
            int j;
            if (itemstack.isDamaged()) {
                if (i == -1) {
                    i = this.getFreeSlot();
                }
                if (i >= 0) {
                    this.items.set(i, itemstack.copyAndClear());
                    this.items.get(i).setPopTime(5);
                    return true;
                }
                if (this.player.hasInfiniteMaterials()) {
                    itemstack.setCount(0);
                    return true;
                }
                return false;
            }
            do {
                j = itemstack.getCount();
                if (i == -1) {
                    itemstack.setCount(this.addResource(itemstack));
                    continue;
                }
                itemstack.setCount(this.addResource(i, itemstack));
            } while (!itemstack.isEmpty() && itemstack.getCount() < j);
            if (itemstack.getCount() == j && this.player.hasInfiniteMaterials()) {
                itemstack.setCount(0);
                return true;
            }
            return itemstack.getCount() < j;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable(throwable, "Adding item to inventory");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Item being added");
            crashreportsystemdetails.setDetail("Item ID", Item.getId(itemstack.getItem()));
            crashreportsystemdetails.setDetail("Item data", itemstack.getDamageValue());
            crashreportsystemdetails.setDetail("Item name", () -> itemstack.getHoverName().getString());
            throw new ReportedException(crashreport);
        }
    }

    public void placeItemBackInInventory(ItemStack itemstack) {
        this.placeItemBackInInventory(itemstack, true);
    }

    public void placeItemBackInInventory(ItemStack itemstack, boolean flag) {
        while (!itemstack.isEmpty()) {
            int i = this.getSlotWithRemainingSpace(itemstack);
            if (i == -1) {
                i = this.getFreeSlot();
            }
            if (i != -1) {
                Player entityhuman;
                int j = itemstack.getMaxStackSize() - this.getItem(i).getCount();
                if (!this.add(i, itemstack.split(j)) || !flag || !((entityhuman = this.player) instanceof ServerPlayer)) continue;
                ServerPlayer entityplayer = (ServerPlayer)entityhuman;
                entityplayer.connection.send(this.createInventoryUpdatePacket(i));
                continue;
            }
            this.player.drop(itemstack, false);
            break;
        }
    }

    public ClientboundSetPlayerInventoryPacket createInventoryUpdatePacket(int i) {
        return new ClientboundSetPlayerInventoryPacket(i, this.getItem(i).copy());
    }

    @Override
    public ItemStack removeItem(int i, int j) {
        ItemStack itemstack;
        if (i < this.items.size()) {
            return ContainerHelper.removeItem(this.items, i, j);
        }
        EquipmentSlot enumitemslot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(i);
        if (enumitemslot != null && !(itemstack = this.equipment.get(enumitemslot)).isEmpty()) {
            return itemstack.split(j);
        }
        return ItemStack.EMPTY;
    }

    public void removeItem(ItemStack itemstack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) != itemstack) continue;
            this.items.set(i, ItemStack.EMPTY);
            return;
        }
        for (EquipmentSlot enumitemslot : EQUIPMENT_SLOT_MAPPING.values()) {
            ItemStack itemstack1 = this.equipment.get(enumitemslot);
            if (itemstack1 != itemstack) continue;
            this.equipment.set(enumitemslot, ItemStack.EMPTY);
            return;
        }
    }

    @Override
    public ItemStack removeItemNoUpdate(int i) {
        if (i < this.items.size()) {
            ItemStack itemstack = this.items.get(i);
            this.items.set(i, ItemStack.EMPTY);
            return itemstack;
        }
        EquipmentSlot enumitemslot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(i);
        return enumitemslot != null ? this.equipment.set(enumitemslot, ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    @Override
    public void setItem(int i, ItemStack itemstack) {
        EquipmentSlot enumitemslot;
        if (i < this.items.size()) {
            this.items.set(i, itemstack);
        }
        if ((enumitemslot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(i)) != null) {
            this.equipment.set(enumitemslot, itemstack);
        }
    }

    public void save(ValueOutput.TypedOutputList<ItemStackWithSlot> valueoutput_a) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = this.items.get(i);
            if (itemstack.isEmpty()) continue;
            valueoutput_a.add(new ItemStackWithSlot(i, itemstack));
        }
    }

    public void load(ValueInput.TypedInputList<ItemStackWithSlot> valueinput_a) {
        this.items.clear();
        for (ItemStackWithSlot itemstackwithslot : valueinput_a) {
            if (!itemstackwithslot.isValidInContainer(this.items.size())) continue;
            this.setItem(itemstackwithslot.slot(), itemstackwithslot.stack());
        }
    }

    @Override
    public int getContainerSize() {
        return this.items.size() + EQUIPMENT_SLOT_MAPPING.size();
    }

    @Override
    public boolean isEmpty() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        for (EquipmentSlot enumitemslot : EQUIPMENT_SLOT_MAPPING.values()) {
            if (this.equipment.get(enumitemslot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack getItem(int i) {
        if (i < this.items.size()) {
            return this.items.get(i);
        }
        EquipmentSlot enumitemslot = (EquipmentSlot)EQUIPMENT_SLOT_MAPPING.get(i);
        return enumitemslot != null ? this.equipment.get(enumitemslot) : ItemStack.EMPTY;
    }

    @Override
    public Component getName() {
        return Component.translatable("container.inventory");
    }

    public void dropAll() {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = this.items.get(i);
            if (itemstack.isEmpty()) continue;
            this.player.drop(itemstack, true, false);
            this.items.set(i, ItemStack.EMPTY);
        }
        this.equipment.dropAll(this.player);
    }

    @Override
    public void setChanged() {
        ++this.timesChanged;
    }

    public int getTimesChanged() {
        return this.timesChanged;
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        return true;
    }

    public boolean contains(ItemStack itemstack) {
        for (ItemStack itemstack1 : this) {
            if (itemstack1.isEmpty() || !ItemStack.isSameItemSameComponents(itemstack1, itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(TagKey<Item> tagkey) {
        for (ItemStack itemstack : this) {
            if (itemstack.isEmpty() || !itemstack.is(tagkey)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Predicate<ItemStack> predicate) {
        for (ItemStack itemstack : this) {
            if (!predicate.test(itemstack)) continue;
            return true;
        }
        return false;
    }

    public void replaceWith(Inventory playerinventory) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, playerinventory.getItem(i));
        }
        this.setSelectedSlot(playerinventory.getSelectedSlot());
    }

    @Override
    public void clearContent() {
        this.items.clear();
        this.equipment.clear();
    }

    public void fillStackedContents(StackedItemContents stackeditemcontents) {
        for (ItemStack itemstack : this.items) {
            stackeditemcontents.accountSimpleStack(itemstack);
        }
    }

    public ItemStack removeFromSelected(boolean flag) {
        ItemStack itemstack = this.getSelectedItem();
        return itemstack.isEmpty() ? ItemStack.EMPTY : this.removeItem(this.selected, flag ? itemstack.getCount() : 1);
    }
}

