/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.projectiles.ProjectileSource;

public abstract class Projectile
extends Entity
implements TraceableEntity {
    private static final boolean DEFAULT_LEFT_OWNER = false;
    private static final boolean DEFAULT_HAS_BEEN_SHOT = false;
    @Nullable
    protected EntityReference<Entity> owner;
    private boolean leftOwner = false;
    private boolean hasBeenShot = false;
    @Nullable
    private Entity lastDeflectedBy;
    private boolean hitCancelled = false;

    Projectile(EntityType<? extends Projectile> entitytypes, Level world) {
        super(entitytypes, world);
    }

    protected void setOwner(@Nullable EntityReference<Entity> entityreference) {
        this.owner = entityreference;
    }

    public void setOwner(@Nullable Entity entity) {
        this.setOwner(entity != null ? new EntityReference<Entity>(entity) : null);
        this.projectileSource = entity != null && entity.getBukkitEntity() instanceof ProjectileSource ? (ProjectileSource)entity.getBukkitEntity() : null;
    }

    @Override
    @Nullable
    public Entity getOwner() {
        return EntityReference.get(this.owner, this.level(), Entity.class);
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)this);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        EntityReference.store(this.owner, valueoutput, "Owner");
        if (this.leftOwner) {
            valueoutput.putBoolean("LeftOwner", true);
        }
        valueoutput.putBoolean("HasBeenShot", this.hasBeenShot);
    }

    protected boolean ownedBy(Entity entity) {
        return this.owner != null && this.owner.matches(entity);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        this.setOwner(EntityReference.read(valueinput, "Owner"));
        this.leftOwner = valueinput.getBooleanOr("LeftOwner", false);
        this.hasBeenShot = valueinput.getBooleanOr("HasBeenShot", false);
    }

    @Override
    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof Projectile) {
            Projectile iprojectile = (Projectile)entity;
            this.owner = iprojectile.owner;
        }
    }

    @Override
    public void tick() {
        if (!this.hasBeenShot) {
            this.gameEvent(GameEvent.PROJECTILE_SHOOT, this.getOwner());
            this.hasBeenShot = true;
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        super.tick();
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            AABB axisalignedbb = this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0);
            return entity.getRootVehicle().getSelfAndPassengers().filter(EntitySelector.CAN_BE_PICKED).noneMatch(entity1 -> axisalignedbb.intersects(entity1.getBoundingBox()));
        }
        return true;
    }

    public Vec3 getMovementToShoot(double d0, double d1, double d2, float f, float f1) {
        return new Vec3(d0, d1, d2).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)f1), this.random.triangle(0.0, 0.0172275 * (double)f1), this.random.triangle(0.0, 0.0172275 * (double)f1)).scale(f);
    }

    public void shoot(double d0, double d1, double d2, float f, float f1) {
        Vec3 vec3d = this.getMovementToShoot(d0, d1, d2, f, f1);
        this.setDeltaMovement(vec3d);
        this.hasImpulse = true;
        double d3 = vec3d.horizontalDistance();
        this.setYRot((float)(Mth.atan2(vec3d.x, vec3d.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2(vec3d.y, d3) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public void shootFromRotation(Entity entity, float f, float f1, float f2, float f3, float f4) {
        float f5 = -Mth.sin(f1 * ((float)Math.PI / 180)) * Mth.cos(f * ((float)Math.PI / 180));
        float f6 = -Mth.sin((f + f2) * ((float)Math.PI / 180));
        float f7 = Mth.cos(f1 * ((float)Math.PI / 180)) * Mth.cos(f * ((float)Math.PI / 180));
        this.shoot(f5, f6, f7, f3, f4);
        Vec3 vec3d = entity.getKnownMovement();
        this.setDeltaMovement(this.getDeltaMovement().add(vec3d.x, entity.onGround() ? 0.0 : vec3d.y, vec3d.z));
    }

    @Override
    public void onAboveBubbleColumn(boolean flag, BlockPos blockposition) {
        double d0 = flag ? -0.03 : 0.1;
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, d0, 0.0));
        Projectile.sendBubbleColumnParticles(this.level(), blockposition);
    }

    @Override
    public void onInsideBubbleColumn(boolean flag) {
        double d0 = flag ? -0.03 : 0.06;
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, d0, 0.0));
        this.resetFallDistance();
    }

    public static <T extends Projectile> T spawnProjectileFromRotation(ProjectileFactory<T> iprojectile_a, ServerLevel worldserver, ItemStack itemstack, LivingEntity entityliving, float f, float f1, float f2) {
        return (T)Projectile.spawnProjectile(iprojectile_a.create(worldserver, entityliving, itemstack), worldserver, itemstack, iprojectile -> iprojectile.shootFromRotation(entityliving, entityliving.getXRot(), entityliving.getYRot(), f, f1, f2));
    }

    public static <T extends Projectile> T spawnProjectileUsingShoot(ProjectileFactory<T> iprojectile_a, ServerLevel worldserver, ItemStack itemstack, LivingEntity entityliving, double d0, double d1, double d2, float f, float f1) {
        return (T)Projectile.spawnProjectile(iprojectile_a.create(worldserver, entityliving, itemstack), worldserver, itemstack, iprojectile -> iprojectile.shoot(d0, d1, d2, f, f1));
    }

    public static <T extends Projectile> T spawnProjectileUsingShoot(T t0, ServerLevel worldserver, ItemStack itemstack, double d0, double d1, double d2, float f, float f1) {
        return (T)Projectile.spawnProjectile(t0, worldserver, itemstack, iprojectile -> t0.shoot(d0, d1, d2, f, f1));
    }

    public static <T extends Projectile> T spawnProjectile(T t0, ServerLevel worldserver, ItemStack itemstack) {
        return (T)Projectile.spawnProjectile(t0, worldserver, itemstack, iprojectile -> {});
    }

    public static <T extends Projectile> T spawnProjectile(T t0, ServerLevel worldserver, ItemStack itemstack, Consumer<T> consumer) {
        consumer.accept(t0);
        if (worldserver.addFreshEntity(t0)) {
            t0.applyOnProjectileSpawned(worldserver, itemstack);
        }
        return t0;
    }

    public void applyOnProjectileSpawned(ServerLevel worldserver, ItemStack itemstack) {
        AbstractArrow entityarrow;
        ItemStack itemstack1;
        EnchantmentHelper.onProjectileSpawned(worldserver, itemstack, this, item -> {});
        Projectile projectile = this;
        if (projectile instanceof AbstractArrow && (itemstack1 = (entityarrow = (AbstractArrow)projectile).getWeaponItem()) != null && !itemstack1.isEmpty() && !itemstack.getItem().equals(itemstack1.getItem())) {
            Objects.requireNonNull(entityarrow);
            EnchantmentHelper.onProjectileSpawned(worldserver, itemstack1, this, entityarrow::onItemBreak);
        }
    }

    protected ProjectileDeflection preHitTargetOrDeflectSelf(HitResult movingobjectposition) {
        ProjectileHitEvent event = CraftEventFactory.callProjectileHitEvent(this, movingobjectposition);
        boolean bl = this.hitCancelled = event != null && event.isCancelled();
        if (movingobjectposition.getType() == HitResult.Type.BLOCK || !this.hitCancelled) {
            return this.hitTargetOrDeflectSelf(movingobjectposition);
        }
        return ProjectileDeflection.NONE;
    }

    protected ProjectileDeflection hitTargetOrDeflectSelf(HitResult movingobjectposition) {
        ProjectileDeflection projectiledeflection1;
        BlockHitResult movingobjectpositionblock;
        if (movingobjectposition.getType() == HitResult.Type.ENTITY) {
            EntityHitResult movingobjectpositionentity = (EntityHitResult)movingobjectposition;
            Entity entity = movingobjectpositionentity.getEntity();
            ProjectileDeflection projectiledeflection = entity.deflection(this);
            if (projectiledeflection != ProjectileDeflection.NONE) {
                if (entity != this.lastDeflectedBy && this.deflect(projectiledeflection, entity, this.getOwner(), false)) {
                    this.lastDeflectedBy = entity;
                }
                return projectiledeflection;
            }
        } else if (this.shouldBounceOnWorldBorder() && movingobjectposition instanceof BlockHitResult && (movingobjectpositionblock = (BlockHitResult)movingobjectposition).isWorldBorderHit() && this.deflect(projectiledeflection1 = ProjectileDeflection.REVERSE, null, this.getOwner(), false)) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.2));
            return projectiledeflection1;
        }
        this.onHit(movingobjectposition);
        return ProjectileDeflection.NONE;
    }

    protected boolean shouldBounceOnWorldBorder() {
        return false;
    }

    public boolean deflect(ProjectileDeflection projectiledeflection, @Nullable Entity entity, @Nullable Entity entity1, boolean flag) {
        projectiledeflection.deflect(this, entity, this.random);
        if (!this.level().isClientSide) {
            this.setOwner(entity1);
            this.onDeflection(entity, flag);
        }
        return true;
    }

    protected void onDeflection(@Nullable Entity entity, boolean flag) {
    }

    protected void onItemBreak(Item item) {
    }

    protected void onHit(HitResult movingobjectposition) {
        HitResult.Type movingobjectposition_enummovingobjecttype = movingobjectposition.getType();
        if (movingobjectposition_enummovingobjecttype == HitResult.Type.ENTITY) {
            EntityHitResult movingobjectpositionentity = (EntityHitResult)movingobjectposition;
            Entity entity = movingobjectpositionentity.getEntity();
            if (entity.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE) && entity instanceof Projectile) {
                Projectile iprojectile = (Projectile)entity;
                iprojectile.deflect(ProjectileDeflection.AIM_DEFLECT, this.getOwner(), this.getOwner(), true);
            }
            this.onHitEntity(movingobjectpositionentity);
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, movingobjectposition.getLocation(), GameEvent.Context.of(this, null));
        } else if (movingobjectposition_enummovingobjecttype == HitResult.Type.BLOCK) {
            BlockHitResult movingobjectpositionblock = (BlockHitResult)movingobjectposition;
            this.onHitBlock(movingobjectpositionblock);
            BlockPos blockposition = movingobjectpositionblock.getBlockPos();
            this.level().gameEvent(GameEvent.PROJECTILE_LAND, blockposition, GameEvent.Context.of(this, this.level().getBlockState(blockposition)));
        }
    }

    protected void onHitEntity(EntityHitResult movingobjectpositionentity) {
    }

    protected void onHitBlock(BlockHitResult movingobjectpositionblock) {
        if (this.hitCancelled) {
            return;
        }
        BlockState iblockdata = this.level().getBlockState(movingobjectpositionblock.getBlockPos());
        iblockdata.onProjectileHit(this.level(), iblockdata, movingobjectpositionblock, this);
    }

    protected boolean canHitEntity(Entity entity) {
        if (!entity.canBeHitByProjectile()) {
            return false;
        }
        Entity entity1 = this.getOwner();
        return entity1 == null || this.leftOwner || !entity1.isPassengerOfSameVehicle(entity);
    }

    protected void updateRotation() {
        Vec3 vec3d = this.getDeltaMovement();
        double d0 = vec3d.horizontalDistance();
        this.setXRot(Projectile.lerpRotation(this.xRotO, (float)(Mth.atan2(vec3d.y, d0) * 57.2957763671875)));
        this.setYRot(Projectile.lerpRotation(this.yRotO, (float)(Mth.atan2(vec3d.x, vec3d.z) * 57.2957763671875)));
    }

    protected static float lerpRotation(float f, float f1) {
        while (f1 - f < -180.0f) {
            f -= 360.0f;
        }
        while (f1 - f >= 180.0f) {
            f += 360.0f;
        }
        return Mth.lerp(0.2f, f, f1);
    }

    @Override
    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entitytrackerentry) {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, entitytrackerentry, entity == null ? 0 : entity.getId());
    }

    @Override
    public void recreateFromPacket(ClientboundAddEntityPacket packetplayoutspawnentity) {
        super.recreateFromPacket(packetplayoutspawnentity);
        Entity entity = this.level().getEntity(packetplayoutspawnentity.getData());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    @Override
    public boolean mayInteract(ServerLevel worldserver, BlockPos blockposition) {
        Entity entity = this.getOwner();
        return entity instanceof Player ? entity.mayInteract(worldserver, blockposition) : entity == null || worldserver.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING);
    }

    public boolean mayBreak(ServerLevel worldserver) {
        return this.getType().is(EntityTypeTags.IMPACT_PROJECTILES) && worldserver.getGameRules().getBoolean(GameRules.RULE_PROJECTILESCANBREAKBLOCKS);
    }

    @Override
    public boolean isPickable() {
        return this.getType().is(EntityTypeTags.REDIRECTABLE_PROJECTILE);
    }

    @Override
    public float getPickRadius() {
        return this.isPickable() ? 1.0f : 0.0f;
    }

    public DoubleDoubleImmutablePair calculateHorizontalHurtKnockbackDirection(LivingEntity entityliving, DamageSource damagesource) {
        double d0 = this.getDeltaMovement().x;
        double d1 = this.getDeltaMovement().z;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }

    @Override
    public int getDimensionChangingDelay() {
        return 2;
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        if (!this.isInvulnerableToBase(damagesource)) {
            this.markHurt();
        }
        return false;
    }

    @FunctionalInterface
    public static interface ProjectileFactory<T extends Projectile> {
        public T create(ServerLevel var1, LivingEntity var2, ItemStack var3);
    }
}

