/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class ThrowableItemProjectile
extends ThrowableProjectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.defineId(ThrowableItemProjectile.class, EntityDataSerializers.ITEM_STACK);

    public ThrowableItemProjectile(EntityType<? extends ThrowableItemProjectile> entitytypes, Level world) {
        super((EntityType<? extends ThrowableProjectile>)entitytypes, world);
    }

    public ThrowableItemProjectile(EntityType<? extends ThrowableItemProjectile> entitytypes, double d0, double d1, double d2, Level world, ItemStack itemstack) {
        super(entitytypes, d0, d1, d2, world);
        this.setItem(itemstack);
    }

    public ThrowableItemProjectile(EntityType<? extends ThrowableItemProjectile> entitytypes, LivingEntity entityliving, Level world, ItemStack itemstack) {
        this(entitytypes, entityliving.getX(), entityliving.getEyeY() - (double)0.1f, entityliving.getZ(), world, itemstack);
        this.setOwner(entityliving);
    }

    public void setItem(ItemStack itemstack) {
        this.getEntityData().set(DATA_ITEM_STACK, itemstack.copyWithCount(1));
    }

    protected abstract Item getDefaultItem();

    public Item getDefaultItemPublic() {
        return this.getDefaultItem();
    }

    @Override
    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM_STACK);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder datawatcher_a) {
        datawatcher_a.define(DATA_ITEM_STACK, new ItemStack(this.getDefaultItem()));
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.store("Item", ItemStack.CODEC, this.getItem());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.setItem(valueinput.read("Item", ItemStack.CODEC).orElseGet(() -> new ItemStack(this.getDefaultItem())));
    }
}

