/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.PotionSplashEvent;

public class ThrownSplashPotion
extends AbstractThrownPotion {
    public ThrownSplashPotion(EntityType<? extends ThrownSplashPotion> entitytypes, Level world) {
        super((EntityType<? extends AbstractThrownPotion>)entitytypes, world);
    }

    public ThrownSplashPotion(Level world, LivingEntity entityliving, ItemStack itemstack) {
        super(EntityType.SPLASH_POTION, world, entityliving, itemstack);
    }

    public ThrownSplashPotion(Level world, double d0, double d1, double d2, ItemStack itemstack) {
        super(EntityType.SPLASH_POTION, world, d0, d1, d2, itemstack);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    public void onHitAsPotion(ServerLevel worldserver, ItemStack itemstack, HitResult movingobjectposition) {
        PotionSplashEvent event;
        double d1;
        PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        float f = itemstack.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue();
        Iterable<MobEffectInstance> iterable = potioncontents.getAllEffects();
        AABB axisalignedbb = this.getBoundingBox().move(movingobjectposition.getLocation().subtract(this.position()));
        AABB axisalignedbb1 = axisalignedbb.inflate(4.0, 2.0, 4.0);
        List<LivingEntity> list = this.level().getEntitiesOfClass(LivingEntity.class, axisalignedbb1);
        float f1 = ProjectileUtil.computeMargin(this);
        HashMap<org.bukkit.entity.LivingEntity, Double> affected = new HashMap<org.bukkit.entity.LivingEntity, Double>();
        if (!list.isEmpty()) {
            Entity entity = this.getEffectSource();
            for (LivingEntity entityliving : list) {
                double d0;
                if (!entityliving.isAffectedByPotions() || !((d0 = axisalignedbb.distanceToSqr(entityliving.getBoundingBox().inflate(f1))) < 16.0)) continue;
                d1 = 1.0 - Math.sqrt(d0) / 4.0;
                affected.put((org.bukkit.entity.LivingEntity)entityliving.getBukkitEntity(), d1);
            }
        }
        if (!(event = CraftEventFactory.callPotionSplashEvent(this, movingobjectposition, affected)).isCancelled() && list != null && !list.isEmpty()) {
            Entity entity1 = this.getEffectSource();
            for (org.bukkit.entity.LivingEntity victim : event.getAffectedEntities()) {
                if (!(victim instanceof CraftLivingEntity)) continue;
                LivingEntity entityliving = ((CraftLivingEntity)victim).getHandle();
                d1 = event.getIntensity(victim);
                for (MobEffectInstance mobeffect : iterable) {
                    MobEffect mobeffectlist;
                    Holder<MobEffect> holder = mobeffect.getEffect();
                    if (!this.level().pvpMode && this.getOwner() instanceof ServerPlayer && entityliving instanceof ServerPlayer && entityliving != this.getOwner() && ((mobeffectlist = holder.value()) == MobEffects.SLOWNESS || mobeffectlist == MobEffects.MINING_FATIGUE || mobeffectlist == MobEffects.INSTANT_DAMAGE || mobeffectlist == MobEffects.BLINDNESS || mobeffectlist == MobEffects.HUNGER || mobeffectlist == MobEffects.WEAKNESS || mobeffectlist == MobEffects.POISON)) continue;
                    if (holder.value().isInstantenous()) {
                        holder.value().applyInstantenousEffect(worldserver, this, this.getOwner(), entityliving, mobeffect.getAmplifier(), d1);
                        continue;
                    }
                    int i = mobeffect.mapDuration(j -> (int)(d1 * (double)j * (double)f + 0.5));
                    MobEffectInstance mobeffect1 = new MobEffectInstance(holder, i, mobeffect.getAmplifier(), mobeffect.isAmbient(), mobeffect.isVisible());
                    if (mobeffect1.endsWithin(20)) continue;
                    entityliving.addEffect(mobeffect1, entity1, EntityPotionEffectEvent.Cause.POTION_SPLASH);
                }
            }
        }
    }
}

