/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class MinecartTNT
extends AbstractMinecart {
    private static final byte EVENT_PRIME = 10;
    private static final String TAG_EXPLOSION_POWER = "explosion_power";
    private static final String TAG_EXPLOSION_SPEED_FACTOR = "explosion_speed_factor";
    private static final String TAG_FUSE = "fuse";
    private static final float DEFAULT_EXPLOSION_POWER_BASE = 4.0f;
    private static final float DEFAULT_EXPLOSION_SPEED_FACTOR = 1.0f;
    private static final int NO_FUSE = -1;
    @Nullable
    private DamageSource ignitionSource;
    public int fuse = -1;
    public float explosionPowerBase = 4.0f;
    public float explosionSpeedFactor = 1.0f;
    public boolean isIncendiary = false;

    public MinecartTNT(EntityType<? extends MinecartTNT> entitytypes, Level world) {
        super(entitytypes, world);
    }

    @Override
    public BlockState getDefaultDisplayBlockState() {
        return Blocks.TNT.defaultBlockState();
    }

    @Override
    public void tick() {
        double d0;
        super.tick();
        if (this.fuse > 0) {
            --this.fuse;
            this.level().addParticle(ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explode(this.ignitionSource, this.getDeltaMovement().horizontalDistanceSqr());
        }
        if (this.horizontalCollision && (d0 = this.getDeltaMovement().horizontalDistanceSqr()) >= (double)0.01f) {
            this.explode(d0);
        }
    }

    @Override
    public boolean hurtServer(ServerLevel worldserver, DamageSource damagesource, float f) {
        AbstractArrow entityarrow;
        Entity entity = damagesource.getDirectEntity();
        if (entity instanceof AbstractArrow && (entityarrow = (AbstractArrow)entity).isOnFire()) {
            DamageSource damagesource1 = this.damageSources().explosion(this, damagesource.getEntity());
            this.explode(damagesource1, entityarrow.getDeltaMovement().lengthSqr());
        }
        return super.hurtServer(worldserver, damagesource, f);
    }

    @Override
    public void destroy(ServerLevel worldserver, DamageSource damagesource) {
        double d0 = this.getDeltaMovement().horizontalDistanceSqr();
        if (!MinecartTNT.damageSourceIgnitesTnt(damagesource) && d0 < (double)0.01f) {
            this.destroy(worldserver, this.getDropItem());
        } else if (this.fuse < 0) {
            this.primeFuse(damagesource);
            this.fuse = this.random.nextInt(20) + this.random.nextInt(20);
        }
    }

    @Override
    protected Item getDropItem() {
        return Items.TNT_MINECART;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.TNT_MINECART);
    }

    public void explode(double d0) {
        this.explode(null, d0);
    }

    protected void explode(@Nullable DamageSource damagesource, double d0) {
        Level world = this.level();
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            if (worldserver.getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
                double d1 = Math.min(Math.sqrt(d0), 5.0);
                ExplosionPrimeEvent event = new ExplosionPrimeEvent((org.bukkit.entity.Entity)this.getBukkitEntity(), (float)((double)this.explosionPowerBase + (double)this.explosionSpeedFactor * this.random.nextDouble() * 1.5 * d1), this.isIncendiary);
                worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    this.fuse = -1;
                    return;
                }
                worldserver.explode(this, damagesource, null, this.getX(), this.getY(), this.getZ(), event.getRadius(), event.getFire(), Level.ExplosionInteraction.TNT);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else if (this.isPrimed()) {
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            }
        }
    }

    @Override
    public boolean causeFallDamage(double d0, float f, DamageSource damagesource) {
        if (d0 >= 3.0) {
            double d1 = d0 / 10.0;
            this.explode(d1 * d1);
        }
        return super.causeFallDamage(d0, f, damagesource);
    }

    @Override
    public void activateMinecart(int i, int j, int k, boolean flag) {
        if (flag && this.fuse < 0) {
            this.primeFuse(null);
        }
    }

    @Override
    public void handleEntityEvent(byte b0) {
        if (b0 == 10) {
            this.primeFuse(null);
        } else {
            super.handleEntityEvent(b0);
        }
    }

    public void primeFuse(@Nullable DamageSource damagesource) {
        ServerLevel worldserver;
        Level world = this.level();
        if (world instanceof ServerLevel && !(worldserver = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_TNT_EXPLODES)) {
            return;
        }
        this.fuse = 80;
        if (!this.level().isClientSide) {
            if (damagesource != null && this.ignitionSource == null) {
                this.ignitionSource = this.damageSources().explosion(this, damagesource.getEntity());
            }
            this.level().broadcastEntityEvent(this, (byte)10);
            if (!this.isSilent()) {
                this.level().playSound((Entity)null, this.getX(), this.getY(), this.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    @Override
    public float getBlockExplosionResistance(Explosion explosion, BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata, FluidState fluid, float f) {
        return !this.isPrimed() || !iblockdata.is(BlockTags.RAILS) && !iblockaccess.getBlockState(blockposition.above()).is(BlockTags.RAILS) ? super.getBlockExplosionResistance(explosion, iblockaccess, blockposition, iblockdata, fluid, f) : 0.0f;
    }

    @Override
    public boolean shouldBlockExplode(Explosion explosion, BlockGetter iblockaccess, BlockPos blockposition, BlockState iblockdata, float f) {
        return !this.isPrimed() || !iblockdata.is(BlockTags.RAILS) && !iblockaccess.getBlockState(blockposition.above()).is(BlockTags.RAILS) ? super.shouldBlockExplode(explosion, iblockaccess, blockposition, iblockdata, f) : false;
    }

    @Override
    protected void readAdditionalSaveData(ValueInput valueinput) {
        super.readAdditionalSaveData(valueinput);
        this.fuse = valueinput.getIntOr(TAG_FUSE, -1);
        this.explosionPowerBase = Mth.clamp(valueinput.getFloatOr(TAG_EXPLOSION_POWER, 4.0f), 0.0f, 128.0f);
        this.explosionSpeedFactor = Mth.clamp(valueinput.getFloatOr(TAG_EXPLOSION_SPEED_FACTOR, 1.0f), 0.0f, 128.0f);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput valueoutput) {
        super.addAdditionalSaveData(valueoutput);
        valueoutput.putInt(TAG_FUSE, this.fuse);
        if (this.explosionPowerBase != 4.0f) {
            valueoutput.putFloat(TAG_EXPLOSION_POWER, this.explosionPowerBase);
        }
        if (this.explosionSpeedFactor != 1.0f) {
            valueoutput.putFloat(TAG_EXPLOSION_SPEED_FACTOR, this.explosionSpeedFactor);
        }
    }

    @Override
    boolean shouldSourceDestroy(DamageSource damagesource) {
        return MinecartTNT.damageSourceIgnitesTnt(damagesource);
    }

    private static boolean damageSourceIgnitesTnt(DamageSource damagesource) {
        Entity entity = damagesource.getDirectEntity();
        if (entity instanceof Projectile) {
            Projectile iprojectile = (Projectile)entity;
            return iprojectile.isOnFire();
        }
        return damagesource.is(DamageTypeTags.IS_FIRE) || damagesource.is(DamageTypeTags.IS_EXPLOSION);
    }
}

