/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryBeacon;
import org.bukkit.craftbukkit.v1_21_R5.inventory.view.CraftBeaconView;
import org.bukkit.entity.HumanEntity;

public class BeaconMenu
extends AbstractContainerMenu {
    private static final int PAYMENT_SLOT = 0;
    private static final int SLOT_COUNT = 1;
    private static final int DATA_COUNT = 3;
    private static final int INV_SLOT_START = 1;
    private static final int INV_SLOT_END = 28;
    private static final int USE_ROW_SLOT_START = 28;
    private static final int USE_ROW_SLOT_END = 37;
    private static final int NO_EFFECT = 0;
    private final Container beacon;
    private final PaymentSlot paymentSlot;
    private final ContainerLevelAccess access;
    private final ContainerData beaconData;
    private CraftBeaconView bukkitEntity = null;
    private Inventory player;

    public BeaconMenu(int i, Container iinventory) {
        this(i, iinventory, new SimpleContainerData(3), ContainerLevelAccess.NULL);
    }

    public BeaconMenu(int i, Container iinventory, ContainerData icontainerproperties, ContainerLevelAccess containeraccess) {
        super(MenuType.BEACON, i);
        this.player = (Inventory)iinventory;
        this.beacon = new SimpleContainer(this, 1){

            @Override
            public boolean canPlaceItem(int j, ItemStack itemstack) {
                return itemstack.is(ItemTags.BEACON_PAYMENT_ITEMS);
            }

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        };
        BeaconMenu.checkContainerDataCount(icontainerproperties, 3);
        this.beaconData = icontainerproperties;
        this.access = containeraccess;
        this.paymentSlot = new PaymentSlot(this.beacon, 0, 136, 110);
        this.addSlot(this.paymentSlot);
        this.addDataSlots(icontainerproperties);
        this.addStandardInventorySlots(iinventory, 36, 137);
    }

    @Override
    public void removed(Player entityhuman) {
        ItemStack itemstack;
        super.removed(entityhuman);
        if (!entityhuman.level().isClientSide && !(itemstack = this.paymentSlot.remove(this.paymentSlot.getMaxStackSize())).isEmpty()) {
            entityhuman.drop(itemstack, false);
        }
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return BeaconMenu.stillValid(this.access, entityhuman, Blocks.BEACON);
    }

    @Override
    public void setData(int i, int j) {
        super.setData(i, j);
        this.broadcastChanges();
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (i == 0) {
                if (!this.moveItemStackTo(itemstack1, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.paymentSlot.hasItem() && this.paymentSlot.mayPlace(itemstack1) && itemstack1.getCount() == 1 ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (i >= 1 && i < 28 ? !this.moveItemStackTo(itemstack1, 28, 37, false) : (i >= 28 && i < 37 ? !this.moveItemStackTo(itemstack1, 1, 28, false) : !this.moveItemStackTo(itemstack1, 1, 37, false)))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack1);
        }
        return itemstack;
    }

    public int getLevels() {
        return this.beaconData.get(0);
    }

    public static int encodeEffect(@Nullable Holder<MobEffect> holder) {
        return holder == null ? 0 : BuiltInRegistries.MOB_EFFECT.asHolderIdMap().getId(holder) + 1;
    }

    @Nullable
    public static Holder<MobEffect> decodeEffect(int i) {
        return i == 0 ? null : BuiltInRegistries.MOB_EFFECT.asHolderIdMap().byId(i - 1);
    }

    @Nullable
    public Holder<MobEffect> getPrimaryEffect() {
        return BeaconMenu.decodeEffect(this.beaconData.get(1));
    }

    @Nullable
    public Holder<MobEffect> getSecondaryEffect() {
        return BeaconMenu.decodeEffect(this.beaconData.get(2));
    }

    public void updateEffects(Optional<Holder<MobEffect>> optional, Optional<Holder<MobEffect>> optional1) {
        if (this.paymentSlot.hasItem()) {
            this.beaconData.set(1, BeaconMenu.encodeEffect(optional.orElse(null)));
            this.beaconData.set(2, BeaconMenu.encodeEffect(optional1.orElse(null)));
            this.paymentSlot.remove(1);
            this.access.execute(Level::blockEntityChanged);
        }
    }

    public boolean hasPayment() {
        return !this.beacon.getItem(0).isEmpty();
    }

    @Override
    public CraftBeaconView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryBeacon inventory = new CraftInventoryBeacon(this.beacon);
        this.bukkitEntity = new CraftBeaconView((HumanEntity)this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }

    private static class PaymentSlot
    extends Slot {
        public PaymentSlot(Container iinventory, int i, int j, int k) {
            super(iinventory, i, j, k);
        }

        @Override
        public boolean mayPlace(ItemStack itemstack) {
            return itemstack.is(ItemTags.BEACON_PAYMENT_ITEMS);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }
    }
}

