/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryBrewer;
import org.bukkit.craftbukkit.v1_21_R5.inventory.view.CraftBrewingStandView;
import org.bukkit.entity.HumanEntity;

public class BrewingStandMenu
extends AbstractContainerMenu {
    static final ResourceLocation EMPTY_SLOT_FUEL = ResourceLocation.withDefaultNamespace("container/slot/brewing_fuel");
    static final ResourceLocation EMPTY_SLOT_POTION = ResourceLocation.withDefaultNamespace("container/slot/potion");
    private static final int BOTTLE_SLOT_START = 0;
    private static final int BOTTLE_SLOT_END = 2;
    private static final int INGREDIENT_SLOT = 3;
    private static final int FUEL_SLOT = 4;
    private static final int SLOT_COUNT = 5;
    private static final int DATA_COUNT = 2;
    private static final int INV_SLOT_START = 5;
    private static final int INV_SLOT_END = 32;
    private static final int USE_ROW_SLOT_START = 32;
    private static final int USE_ROW_SLOT_END = 41;
    private final Container brewingStand;
    private final ContainerData brewingStandData;
    private final Slot ingredientSlot;
    private CraftBrewingStandView bukkitEntity = null;
    private Inventory player;

    public BrewingStandMenu(int i, Inventory playerinventory) {
        this(i, playerinventory, new SimpleContainer(5), new SimpleContainerData(2));
    }

    public BrewingStandMenu(int i, Inventory playerinventory, Container iinventory, ContainerData icontainerproperties) {
        super(MenuType.BREWING_STAND, i);
        this.player = playerinventory;
        BrewingStandMenu.checkContainerSize(iinventory, 5);
        BrewingStandMenu.checkContainerDataCount(icontainerproperties, 2);
        this.brewingStand = iinventory;
        this.brewingStandData = icontainerproperties;
        PotionBrewing potionbrewer = playerinventory.player.level().potionBrewing();
        this.addSlot(new PotionSlot(iinventory, 0, 56, 51));
        this.addSlot(new PotionSlot(iinventory, 1, 79, 58));
        this.addSlot(new PotionSlot(iinventory, 2, 102, 51));
        this.ingredientSlot = this.addSlot(new IngredientsSlot(potionbrewer, iinventory, 3, 79, 17));
        this.addSlot(new FuelSlot(iinventory, 4, 17, 17));
        this.addDataSlots(icontainerproperties);
        this.addStandardInventorySlots(playerinventory, 8, 84);
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        if (!this.checkReachable) {
            return true;
        }
        return this.brewingStand.stillValid(entityhuman);
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if ((i < 0 || i > 2) && i != 3 && i != 4) {
                if (FuelSlot.mayPlaceItem(itemstack) ? this.moveItemStackTo(itemstack1, 4, 5, false) || this.ingredientSlot.mayPlace(itemstack1) && !this.moveItemStackTo(itemstack1, 3, 4, false) : (this.ingredientSlot.mayPlace(itemstack1) ? !this.moveItemStackTo(itemstack1, 3, 4, false) : (PotionSlot.mayPlaceItem(itemstack) ? !this.moveItemStackTo(itemstack1, 0, 3, false) : (i >= 5 && i < 32 ? !this.moveItemStackTo(itemstack1, 32, 41, false) : (i >= 32 && i < 41 ? !this.moveItemStackTo(itemstack1, 5, 32, false) : !this.moveItemStackTo(itemstack1, 5, 41, false)))))) {
                    return ItemStack.EMPTY;
                }
            } else {
                if (!this.moveItemStackTo(itemstack1, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(entityhuman, itemstack);
        }
        return itemstack;
    }

    public int getFuel() {
        return this.brewingStandData.get(1);
    }

    public int getBrewingTicks() {
        return this.brewingStandData.get(0);
    }

    @Override
    public CraftBrewingStandView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        CraftInventoryBrewer inventory = new CraftInventoryBrewer(this.brewingStand);
        this.bukkitEntity = new CraftBrewingStandView((HumanEntity)this.player.player.getBukkitEntity(), inventory, this);
        return this.bukkitEntity;
    }

    private static class PotionSlot
    extends Slot {
        public PotionSlot(Container iinventory, int i, int j, int k) {
            super(iinventory, i, j, k);
        }

        @Override
        public boolean mayPlace(ItemStack itemstack) {
            return PotionSlot.mayPlaceItem(itemstack);
        }

        @Override
        public int getMaxStackSize() {
            return 1;
        }

        @Override
        public void onTake(Player entityhuman, ItemStack itemstack) {
            Optional<Holder<Potion>> optional = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).potion();
            if (optional.isPresent() && entityhuman instanceof ServerPlayer) {
                ServerPlayer entityplayer = (ServerPlayer)entityhuman;
                CriteriaTriggers.BREWED_POTION.trigger(entityplayer, optional.get());
            }
            super.onTake(entityhuman, itemstack);
        }

        public static boolean mayPlaceItem(ItemStack itemstack) {
            return itemstack.is(Items.POTION) || itemstack.is(Items.SPLASH_POTION) || itemstack.is(Items.LINGERING_POTION) || itemstack.is(Items.GLASS_BOTTLE);
        }

        @Override
        public ResourceLocation getNoItemIcon() {
            return EMPTY_SLOT_POTION;
        }
    }

    private static class IngredientsSlot
    extends Slot {
        private final PotionBrewing potionBrewing;

        public IngredientsSlot(PotionBrewing potionbrewer, Container iinventory, int i, int j, int k) {
            super(iinventory, i, j, k);
            this.potionBrewing = potionbrewer;
        }

        @Override
        public boolean mayPlace(ItemStack itemstack) {
            return this.potionBrewing.isIngredient(itemstack);
        }
    }

    private static class FuelSlot
    extends Slot {
        public FuelSlot(Container iinventory, int i, int j, int k) {
            super(iinventory, i, j, k);
        }

        @Override
        public boolean mayPlace(ItemStack itemstack) {
            return FuelSlot.mayPlaceItem(itemstack);
        }

        public static boolean mayPlaceItem(ItemStack itemstack) {
            return itemstack.is(ItemTags.BREWING_FUEL);
        }

        @Override
        public ResourceLocation getNoItemIcon() {
            return EMPTY_SLOT_FUEL;
        }
    }
}

