/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftInventoryView;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;

public class HorseInventoryMenu
extends AbstractContainerMenu {
    private static final ResourceLocation SADDLE_SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot/saddle");
    private static final ResourceLocation LLAMA_ARMOR_SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot/llama_armor");
    private static final ResourceLocation ARMOR_SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/slot/horse_armor");
    private final Container horseContainer;
    private final AbstractHorse horse;
    private static final int SLOT_SADDLE = 0;
    private static final int SLOT_BODY_ARMOR = 1;
    private static final int SLOT_HORSE_INVENTORY_START = 2;
    CraftInventoryView bukkitEntity;
    net.minecraft.world.entity.player.Inventory player;

    @Override
    public InventoryView getBukkitView() {
        if (this.bukkitEntity != null) {
            return this.bukkitEntity;
        }
        this.bukkitEntity = new CraftInventoryView<HorseInventoryMenu, Inventory>(this.player.player.getBukkitEntity(), this.horseContainer.getOwner().getInventory(), this);
        return this.bukkitEntity;
    }

    public HorseInventoryMenu(int i, net.minecraft.world.entity.player.Inventory playerinventory, Container iinventory, final AbstractHorse entityhorseabstract, int j) {
        super(null, i);
        this.player = playerinventory;
        this.horseContainer = iinventory;
        this.horse = entityhorseabstract;
        iinventory.startOpen(playerinventory.player);
        Container iinventory1 = entityhorseabstract.createEquipmentSlotContainer(EquipmentSlot.SADDLE);
        this.addSlot(new ArmorSlot(this, iinventory1, entityhorseabstract, EquipmentSlot.SADDLE, 0, 8, 18, SADDLE_SLOT_SPRITE){

            @Override
            public boolean isActive() {
                return entityhorseabstract.canUseSlot(EquipmentSlot.SADDLE) && entityhorseabstract.getType().is(EntityTypeTags.CAN_EQUIP_SADDLE);
            }
        });
        final boolean flag = entityhorseabstract instanceof Llama;
        ResourceLocation minecraftkey = flag ? LLAMA_ARMOR_SLOT_SPRITE : ARMOR_SLOT_SPRITE;
        Container iinventory2 = entityhorseabstract.createEquipmentSlotContainer(EquipmentSlot.BODY);
        this.addSlot(new ArmorSlot(this, iinventory2, entityhorseabstract, EquipmentSlot.BODY, 0, 8, 36, minecraftkey){

            @Override
            public boolean isActive() {
                return entityhorseabstract.canUseSlot(EquipmentSlot.BODY) && (entityhorseabstract.getType().is(EntityTypeTags.CAN_WEAR_HORSE_ARMOR) || flag);
            }
        });
        if (j > 0) {
            for (int k = 0; k < 3; ++k) {
                for (int l = 0; l < j; ++l) {
                    this.addSlot(new Slot(iinventory, l + k * j, 80 + l * 18, 18 + k * 18));
                }
            }
        }
        this.addStandardInventorySlots(playerinventory, 8, 84);
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        return !this.horse.hasInventoryChanged(this.horseContainer) && this.horseContainer.stillValid(entityhuman) && this.horse.isAlive() && entityhuman.canInteractWithEntity(this.horse, 4.0);
    }

    @Override
    public ItemStack quickMoveStack(Player entityhuman, int i) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(i);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            int j = 2 + this.horseContainer.getContainerSize();
            if (i < j) {
                if (!this.moveItemStackTo(itemstack1, j, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(itemstack1) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(itemstack1) && !this.getSlot(0).hasItem()) {
                if (!this.moveItemStackTo(itemstack1, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.horseContainer.getContainerSize() == 0 || !this.moveItemStackTo(itemstack1, 2, j, false)) {
                int k = j + 27;
                int l = k + 9;
                if (i >= k && i < l ? !this.moveItemStackTo(itemstack1, j, k, false) : (i >= j && i < k ? !this.moveItemStackTo(itemstack1, k, l, false) : !this.moveItemStackTo(itemstack1, k, k, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    @Override
    public void removed(Player entityhuman) {
        super.removed(entityhuman);
        this.horseContainer.stopOpen(entityhuman);
    }
}

