/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MerchantContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;

public class MerchantResultSlot
extends Slot {
    private final MerchantContainer slots;
    private final Player player;
    private int removeCount;
    private final Merchant merchant;

    public MerchantResultSlot(Player var0, Merchant var1, MerchantContainer var2, int var3, int var4, int var5) {
        super(var2, var3, var4, var5);
        this.player = var0;
        this.merchant = var1;
        this.slots = var2;
    }

    @Override
    public boolean mayPlace(ItemStack var0) {
        return false;
    }

    @Override
    public ItemStack remove(int var0) {
        if (this.hasItem()) {
            this.removeCount += Math.min(var0, this.getItem().getCount());
        }
        return super.remove(var0);
    }

    @Override
    protected void onQuickCraft(ItemStack var0, int var1) {
        this.removeCount += var1;
        this.checkTakeAchievements(var0);
    }

    @Override
    protected void checkTakeAchievements(ItemStack var0) {
        var0.onCraftedBy(this.player, this.removeCount);
        this.removeCount = 0;
    }

    @Override
    public void onTake(Player var0, ItemStack var1) {
        this.checkTakeAchievements(var1);
        MerchantOffer var2 = this.slots.getActiveOffer();
        if (var2 != null) {
            ItemStack var4;
            ItemStack var3 = this.slots.getItem(0);
            if (var2.take(var3, var4 = this.slots.getItem(1)) || var2.take(var4, var3)) {
                this.merchant.notifyTrade(var2);
                var0.awardStat(Stats.TRADED_WITH_VILLAGER);
                this.slots.setItem(0, var3);
                this.slots.setItem(1, var4);
            }
            this.merchant.overrideXp(this.merchant.getVillagerXp() + var2.getXp());
        }
    }
}

