/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.inventory.InventoryHolder;

public class PlayerEnderChestContainer
extends SimpleContainer {
    @Nullable
    private EnderChestBlockEntity activeChest;
    private final Player owner;

    public InventoryHolder getBukkitOwner() {
        return this.owner.getBukkitEntity();
    }

    @Override
    public Location getLocation() {
        return this.activeChest != null ? CraftLocation.toBukkit(this.activeChest.getBlockPos(), (World)this.activeChest.getLevel().getWorld()) : null;
    }

    public PlayerEnderChestContainer(Player owner) {
        super(27);
        this.owner = owner;
    }

    public void setActiveChest(EnderChestBlockEntity tileentityenderchest) {
        this.activeChest = tileentityenderchest;
    }

    public boolean isActiveChest(EnderChestBlockEntity tileentityenderchest) {
        return this.activeChest == tileentityenderchest;
    }

    public void fromSlots(ValueInput.TypedInputList<ItemStackWithSlot> valueinput_a) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.setItem(i, ItemStack.EMPTY);
        }
        for (ItemStackWithSlot itemstackwithslot : valueinput_a) {
            if (!itemstackwithslot.isValidInContainer(this.getContainerSize())) continue;
            this.setItem(itemstackwithslot.slot(), itemstackwithslot.stack());
        }
    }

    public void storeAsSlots(ValueOutput.TypedOutputList<ItemStackWithSlot> valueoutput_a) {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemstack = this.getItem(i);
            if (itemstack.isEmpty()) continue;
            valueoutput_a.add(new ItemStackWithSlot(i, itemstack));
        }
    }

    @Override
    public boolean stillValid(Player entityhuman) {
        return this.activeChest != null && !this.activeChest.stillValid(entityhuman) ? false : super.stillValid(entityhuman);
    }

    @Override
    public void startOpen(Player entityhuman) {
        if (this.activeChest != null) {
            this.activeChest.startOpen(entityhuman);
        }
        super.startOpen(entityhuman);
    }

    @Override
    public void stopOpen(Player entityhuman) {
        if (this.activeChest != null) {
            this.activeChest.stopOpen(entityhuman);
        }
        super.stopOpen(entityhuman);
        this.activeChest = null;
    }
}

