/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BottleItem
extends Item {
    public BottleItem(Item.Properties var0) {
        super(var0);
    }

    @Override
    public InteractionResult use(Level var02, Player var1, InteractionHand var2) {
        List<AreaEffectCloud> var3 = var02.getEntitiesOfClass(AreaEffectCloud.class, var1.getBoundingBox().inflate(2.0), var0 -> var0 != null && var0.isAlive() && var0.getOwner() instanceof EnderDragon);
        ItemStack var4 = var1.getItemInHand(var2);
        if (!var3.isEmpty()) {
            AreaEffectCloud var5 = var3.get(0);
            var5.setRadius(var5.getRadius() - 0.5f);
            var02.playSound(null, var1.getX(), var1.getY(), var1.getZ(), SoundEvents.BOTTLE_FILL_DRAGONBREATH, SoundSource.NEUTRAL, 1.0f, 1.0f);
            var02.gameEvent((Entity)var1, GameEvent.FLUID_PICKUP, var1.position());
            if (var1 instanceof ServerPlayer) {
                ServerPlayer var6 = (ServerPlayer)var1;
                CriteriaTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(var6, var4, var5);
            }
            return InteractionResult.SUCCESS.heldItemTransformedTo(this.turnBottleIntoItem(var4, var1, new ItemStack(Items.DRAGON_BREATH)));
        }
        BlockHitResult var5 = BottleItem.getPlayerPOVHitResult(var02, var1, ClipContext.Fluid.SOURCE_ONLY);
        if (var5.getType() == HitResult.Type.MISS) {
            return InteractionResult.PASS;
        }
        if (var5.getType() == HitResult.Type.BLOCK) {
            BlockPos var6 = var5.getBlockPos();
            if (!var02.mayInteract(var1, var6)) {
                return InteractionResult.PASS;
            }
            if (var02.getFluidState(var6).is(FluidTags.WATER)) {
                var02.playSound((Entity)var1, var1.getX(), var1.getY(), var1.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                var02.gameEvent((Entity)var1, GameEvent.FLUID_PICKUP, var6);
                return InteractionResult.SUCCESS.heldItemTransformedTo(this.turnBottleIntoItem(var4, var1, PotionContents.createItemStack(Items.POTION, Potions.WATER)));
            }
        }
        return InteractionResult.PASS;
    }

    protected ItemStack turnBottleIntoItem(ItemStack var0, Player var1, ItemStack var2) {
        var1.awardStat(Stats.ITEM_USED.get(this));
        return ItemUtils.createFilledResult(var0, var1, var2);
    }
}

