/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R5.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class HangingEntityItem
extends Item {
    private static final Component TOOLTIP_RANDOM_VARIANT = Component.translatable("painting.random").withStyle(ChatFormatting.GRAY);
    private final EntityType<? extends HangingEntity> type;

    public HangingEntityItem(EntityType<? extends HangingEntity> entitytypes, Item.Properties item_info) {
        super(item_info);
        this.type = entitytypes;
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        HangingEntity entityhanging;
        BlockPos blockposition = itemactioncontext.getClickedPos();
        Direction enumdirection = itemactioncontext.getClickedFace();
        BlockPos blockposition1 = blockposition.relative(enumdirection);
        Player entityhuman = itemactioncontext.getPlayer();
        ItemStack itemstack = itemactioncontext.getItemInHand();
        if (entityhuman != null && !this.mayPlace(entityhuman, enumdirection, itemstack, blockposition1)) {
            return InteractionResult.FAIL;
        }
        Level world = itemactioncontext.getLevel();
        if (this.type == EntityType.PAINTING) {
            Optional<Painting> optional = Painting.create(world, blockposition1, enumdirection);
            if (optional.isEmpty()) {
                return InteractionResult.CONSUME;
            }
            entityhanging = optional.get();
        } else if (this.type == EntityType.ITEM_FRAME) {
            entityhanging = new ItemFrame(world, blockposition1, enumdirection);
        } else {
            if (this.type != EntityType.GLOW_ITEM_FRAME) {
                return InteractionResult.SUCCESS;
            }
            entityhanging = new GlowItemFrame(world, blockposition1, enumdirection);
        }
        EntityType.createDefaultStackConfig(world, itemstack, entityhuman).accept(entityhanging);
        if (entityhanging.survives()) {
            if (!world.isClientSide) {
                org.bukkit.entity.Player who = itemactioncontext.getPlayer() == null ? null : (org.bukkit.entity.Player)itemactioncontext.getPlayer().getBukkitEntity();
                Block blockClicked = world.getWorld().getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
                BlockFace blockFace = CraftBlock.notchToBlockFace(enumdirection);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(itemactioncontext.getHand());
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)entityhanging.getBukkitEntity(), who, blockClicked, blockFace, hand, CraftItemStack.asBukkitCopy(itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return InteractionResult.FAIL;
                }
                entityhanging.playPlacementSound();
                world.gameEvent((Entity)entityhuman, GameEvent.ENTITY_PLACE, entityhanging.position());
                world.addFreshEntity(entityhanging);
            }
            itemstack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    protected boolean mayPlace(Player entityhuman, Direction enumdirection, ItemStack itemstack, BlockPos blockposition) {
        return !enumdirection.getAxis().isVertical() && entityhuman.mayUseItemAt(blockposition, enumdirection, itemstack);
    }

    @Override
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext item_b, TooltipDisplay tooltipdisplay, Consumer<Component> consumer, TooltipFlag tooltipflag) {
        if (this.type == EntityType.PAINTING && tooltipdisplay.shows(DataComponents.PAINTING_VARIANT)) {
            Holder<PaintingVariant> holder = itemstack.get(DataComponents.PAINTING_VARIANT);
            if (holder != null) {
                holder.value().title().ifPresent(consumer);
                holder.value().author().ifPresent(consumer);
                consumer.accept(Component.translatable("painting.dimensions", holder.value().width(), holder.value().height()));
            } else if (tooltipflag.isCreative()) {
                consumer.accept(TOOLTIP_RANDOM_VARIANT);
            }
        }
    }
}

