/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class HoeItem
extends Item {
    protected static final Map<Block, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>> TILLABLES = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.GRASS_BLOCK, (Object)Pair.of(HoeItem::onlyIfAirAbove, HoeItem.changeIntoState(Blocks.FARMLAND.defaultBlockState())), (Object)Blocks.DIRT_PATH, (Object)Pair.of(HoeItem::onlyIfAirAbove, HoeItem.changeIntoState(Blocks.FARMLAND.defaultBlockState())), (Object)Blocks.DIRT, (Object)Pair.of(HoeItem::onlyIfAirAbove, HoeItem.changeIntoState(Blocks.FARMLAND.defaultBlockState())), (Object)Blocks.COARSE_DIRT, (Object)Pair.of(HoeItem::onlyIfAirAbove, HoeItem.changeIntoState(Blocks.DIRT.defaultBlockState())), (Object)Blocks.ROOTED_DIRT, (Object)Pair.of(var0 -> true, HoeItem.changeIntoStateAndDropItem(Blocks.DIRT.defaultBlockState(), Items.HANGING_ROOTS))));

    public HoeItem(ToolMaterial var0, float var1, float var2, Item.Properties var3) {
        super(var3.hoe(var0, var1, var2));
    }

    @Override
    public InteractionResult useOn(UseOnContext var0) {
        BlockPos var2;
        Level var1 = var0.getLevel();
        Pair<Predicate<UseOnContext>, Consumer<UseOnContext>> var3 = TILLABLES.get(var1.getBlockState(var2 = var0.getClickedPos()).getBlock());
        if (var3 == null) {
            return InteractionResult.PASS;
        }
        Predicate var4 = (Predicate)var3.getFirst();
        Consumer var5 = (Consumer)var3.getSecond();
        if (var4.test(var0)) {
            Player var6 = var0.getPlayer();
            var1.playSound((Entity)var6, var2, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!var1.isClientSide) {
                var5.accept(var0);
                if (var6 != null) {
                    var0.getItemInHand().hurtAndBreak(1, (LivingEntity)var6, LivingEntity.getSlotForHand(var0.getHand()));
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Consumer<UseOnContext> changeIntoState(BlockState var0) {
        return var1 -> {
            var1.getLevel().setBlock(var1.getClickedPos(), var0, 11);
            var1.getLevel().gameEvent(GameEvent.BLOCK_CHANGE, var1.getClickedPos(), GameEvent.Context.of(var1.getPlayer(), var0));
        };
    }

    public static Consumer<UseOnContext> changeIntoStateAndDropItem(BlockState var0, ItemLike var1) {
        return var2 -> {
            var2.getLevel().setBlock(var2.getClickedPos(), var0, 11);
            var2.getLevel().gameEvent(GameEvent.BLOCK_CHANGE, var2.getClickedPos(), GameEvent.Context.of(var2.getPlayer(), var0));
            Block.popResourceFromFace(var2.getLevel(), var2.getClickedPos(), var2.getClickedFace(), new ItemStack(var1));
        };
    }

    public static boolean onlyIfAirAbove(UseOnContext var0) {
        return var0.getClickedFace() != Direction.DOWN && var0.getLevel().getBlockState(var0.getClickedPos().above()).isAir();
    }
}

