/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.EitherHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.BlocksAttacks;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ProvidesTrimMaterial;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class Item
implements FeatureElement,
ItemLike {
    public static final Codec<Holder<Item>> CODEC = BuiltInRegistries.ITEM.holderByNameCodec().validate(var0 -> var0.is(Items.AIR.builtInRegistryHolder()) ? DataResult.error(() -> "Item must not be minecraft:air") : DataResult.success((Object)var0));
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Item>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.ITEM);
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Map<Block, Item> BY_BLOCK = Maps.newHashMap();
    public static final ResourceLocation BASE_ATTACK_DAMAGE_ID = ResourceLocation.withDefaultNamespace("base_attack_damage");
    public static final ResourceLocation BASE_ATTACK_SPEED_ID = ResourceLocation.withDefaultNamespace("base_attack_speed");
    public static final int DEFAULT_MAX_STACK_SIZE = 64;
    public static final int ABSOLUTE_MAX_STACK_SIZE = 99;
    public static final int MAX_BAR_WIDTH = 13;
    protected static final int APPROXIMATELY_INFINITE_USE_DURATION = 72000;
    private final Holder.Reference<Item> builtInRegistryHolder = BuiltInRegistries.ITEM.createIntrusiveHolder(this);
    private final DataComponentMap components;
    @Nullable
    private final Item craftingRemainingItem;
    protected final String descriptionId;
    private final FeatureFlagSet requiredFeatures;

    public static int getId(Item var0) {
        return var0 == null ? 0 : BuiltInRegistries.ITEM.getId(var0);
    }

    public static Item byId(int var0) {
        return BuiltInRegistries.ITEM.byId(var0);
    }

    @Deprecated
    public static Item byBlock(Block var0) {
        return BY_BLOCK.getOrDefault(var0, Items.AIR);
    }

    public Item(Properties var0) {
        String var1;
        this.descriptionId = var0.effectiveDescriptionId();
        this.components = var0.buildAndValidateComponents(Component.translatable(this.descriptionId), var0.effectiveModel());
        this.craftingRemainingItem = var0.craftingRemainingItem;
        this.requiredFeatures = var0.requiredFeatures;
        if (SharedConstants.IS_RUNNING_IN_IDE && !(var1 = this.getClass().getSimpleName()).endsWith("Item")) {
            LOGGER.error("Item classes should end with Item and {} doesn't.", (Object)var1);
        }
    }

    @Deprecated
    public Holder.Reference<Item> builtInRegistryHolder() {
        return this.builtInRegistryHolder;
    }

    public DataComponentMap components() {
        return this.components;
    }

    public int getDefaultMaxStackSize() {
        return this.components.getOrDefault(DataComponents.MAX_STACK_SIZE, 1);
    }

    public void onUseTick(Level var0, LivingEntity var1, ItemStack var2, int var3) {
    }

    public void onDestroyed(ItemEntity var0) {
    }

    public void verifyComponentsAfterLoad(ItemStack var0) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canDestroyBlock(ItemStack var0, BlockState var1, Level var2, BlockPos var3, LivingEntity var4) {
        Tool var5 = var0.get(DataComponents.TOOL);
        if (var5 == null) return true;
        if (var5.canDestroyBlocksInCreative()) return true;
        if (!(var4 instanceof Player)) return true;
        Player var6 = (Player)var4;
        if (var6.getAbilities().instabuild) return false;
        return true;
    }

    @Override
    public Item asItem() {
        return this;
    }

    public InteractionResult useOn(UseOnContext var0) {
        return InteractionResult.PASS;
    }

    public float getDestroySpeed(ItemStack var0, BlockState var1) {
        Tool var2 = var0.get(DataComponents.TOOL);
        return var2 != null ? var2.getMiningSpeed(var1) : 1.0f;
    }

    public InteractionResult use(Level var0, Player var1, InteractionHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        Consumable var4 = var3.get(DataComponents.CONSUMABLE);
        if (var4 != null) {
            return var4.startConsuming(var1, var3, var2);
        }
        Equippable var5 = var3.get(DataComponents.EQUIPPABLE);
        if (var5 != null && var5.swappable()) {
            return var5.swapWithEquipmentSlot(var3, var1);
        }
        BlocksAttacks var6 = var3.get(DataComponents.BLOCKS_ATTACKS);
        if (var6 != null) {
            var1.startUsingItem(var2);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public ItemStack finishUsingItem(ItemStack var0, Level var1, LivingEntity var2) {
        Consumable var3 = var0.get(DataComponents.CONSUMABLE);
        if (var3 != null) {
            return var3.onConsume(var1, var2, var0);
        }
        return var0;
    }

    public boolean isBarVisible(ItemStack var0) {
        return var0.isDamaged();
    }

    public int getBarWidth(ItemStack var0) {
        return Mth.clamp(Math.round(13.0f - (float)var0.getDamageValue() * 13.0f / (float)var0.getMaxDamage()), 0, 13);
    }

    public int getBarColor(ItemStack var0) {
        int var1 = var0.getMaxDamage();
        float var2 = Math.max(0.0f, ((float)var1 - (float)var0.getDamageValue()) / (float)var1);
        return Mth.hsvToRgb(var2 / 3.0f, 1.0f, 1.0f);
    }

    public boolean overrideStackedOnOther(ItemStack var0, Slot var1, ClickAction var2, Player var3) {
        return false;
    }

    public boolean overrideOtherStackedOnMe(ItemStack var0, ItemStack var1, Slot var2, ClickAction var3, Player var4, SlotAccess var5) {
        return false;
    }

    public float getAttackDamageBonus(Entity var0, float var1, DamageSource var2) {
        return 0.0f;
    }

    @Nullable
    public DamageSource getDamageSource(LivingEntity var0) {
        return null;
    }

    public void hurtEnemy(ItemStack var0, LivingEntity var1, LivingEntity var2) {
    }

    public void postHurtEnemy(ItemStack var0, LivingEntity var1, LivingEntity var2) {
    }

    public boolean mineBlock(ItemStack var0, Level var1, BlockState var2, BlockPos var3, LivingEntity var4) {
        Tool var5 = var0.get(DataComponents.TOOL);
        if (var5 == null) {
            return false;
        }
        if (!var1.isClientSide && var2.getDestroySpeed(var1, var3) != 0.0f && var5.damagePerBlock() > 0) {
            var0.hurtAndBreak(var5.damagePerBlock(), var4, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack var0, BlockState var1) {
        Tool var2 = var0.get(DataComponents.TOOL);
        return var2 != null && var2.isCorrectForDrops(var1);
    }

    public InteractionResult interactLivingEntity(ItemStack var0, Player var1, LivingEntity var2, InteractionHand var3) {
        return InteractionResult.PASS;
    }

    public String toString() {
        return BuiltInRegistries.ITEM.wrapAsHolder(this).getRegisteredName();
    }

    public final ItemStack getCraftingRemainder() {
        return this.craftingRemainingItem == null ? ItemStack.EMPTY : new ItemStack(this.craftingRemainingItem);
    }

    public void inventoryTick(ItemStack var0, ServerLevel var1, Entity var2, @Nullable EquipmentSlot var3) {
    }

    public void onCraftedBy(ItemStack var0, Player var1) {
        this.onCraftedPostProcess(var0, var1.level());
    }

    public void onCraftedPostProcess(ItemStack var0, Level var1) {
    }

    public ItemUseAnimation getUseAnimation(ItemStack var0) {
        Consumable var1 = var0.get(DataComponents.CONSUMABLE);
        if (var1 != null) {
            return var1.animation();
        }
        BlocksAttacks var2 = var0.get(DataComponents.BLOCKS_ATTACKS);
        if (var2 != null) {
            return ItemUseAnimation.BLOCK;
        }
        return ItemUseAnimation.NONE;
    }

    public int getUseDuration(ItemStack var0, LivingEntity var1) {
        Consumable var2 = var0.get(DataComponents.CONSUMABLE);
        if (var2 != null) {
            return var2.consumeTicks();
        }
        BlocksAttacks var3 = var0.get(DataComponents.BLOCKS_ATTACKS);
        if (var3 != null) {
            return 72000;
        }
        return 0;
    }

    public boolean releaseUsing(ItemStack var0, Level var1, LivingEntity var2, int var3) {
        return false;
    }

    @Deprecated
    public void appendHoverText(ItemStack var0, TooltipContext var1, TooltipDisplay var2, Consumer<Component> var3, TooltipFlag var4) {
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack var0) {
        return Optional.empty();
    }

    @VisibleForTesting
    public final String getDescriptionId() {
        return this.descriptionId;
    }

    public final Component getName() {
        return this.components.getOrDefault(DataComponents.ITEM_NAME, CommonComponents.EMPTY);
    }

    public Component getName(ItemStack var0) {
        return var0.getComponents().getOrDefault(DataComponents.ITEM_NAME, CommonComponents.EMPTY);
    }

    public boolean isFoil(ItemStack var0) {
        return var0.isEnchanted();
    }

    protected static BlockHitResult getPlayerPOVHitResult(Level var0, Player var1, ClipContext.Fluid var2) {
        Vec3 var3 = var1.getEyePosition();
        Vec3 var4 = var3.add(var1.calculateViewVector(var1.getXRot(), var1.getYRot()).scale(var1.blockInteractionRange()));
        return var0.clip(new ClipContext(var3, var4, ClipContext.Block.OUTLINE, var2, var1));
    }

    public boolean useOnRelease(ItemStack var0) {
        return false;
    }

    public ItemStack getDefaultInstance() {
        return new ItemStack(this);
    }

    public boolean canFitInsideContainerItems() {
        return true;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.requiredFeatures;
    }

    public boolean shouldPrintOpWarning(ItemStack var0, @Nullable Player var1) {
        return false;
    }

    public static class Properties {
        private static final DependantName<Item, String> BLOCK_DESCRIPTION_ID = var0 -> Util.makeDescriptionId("block", var0.location());
        private static final DependantName<Item, String> ITEM_DESCRIPTION_ID = var0 -> Util.makeDescriptionId("item", var0.location());
        private final DataComponentMap.Builder components = DataComponentMap.builder().addAll(DataComponents.COMMON_ITEM_COMPONENTS);
        @Nullable
        Item craftingRemainingItem;
        FeatureFlagSet requiredFeatures = FeatureFlags.VANILLA_SET;
        @Nullable
        private ResourceKey<Item> id;
        private DependantName<Item, String> descriptionId = ITEM_DESCRIPTION_ID;
        private DependantName<Item, ResourceLocation> model = ResourceKey::location;

        public Properties food(FoodProperties var0) {
            return this.food(var0, Consumables.DEFAULT_FOOD);
        }

        public Properties food(FoodProperties var0, Consumable var1) {
            return this.component(DataComponents.FOOD, var0).component(DataComponents.CONSUMABLE, var1);
        }

        public Properties usingConvertsTo(Item var0) {
            return this.component(DataComponents.USE_REMAINDER, new UseRemainder(new ItemStack(var0)));
        }

        public Properties useCooldown(float var0) {
            return this.component(DataComponents.USE_COOLDOWN, new UseCooldown(var0));
        }

        public Properties stacksTo(int var0) {
            return this.component(DataComponents.MAX_STACK_SIZE, var0);
        }

        public Properties durability(int var0) {
            this.component(DataComponents.MAX_DAMAGE, var0);
            this.component(DataComponents.MAX_STACK_SIZE, 1);
            this.component(DataComponents.DAMAGE, 0);
            return this;
        }

        public Properties craftRemainder(Item var0) {
            this.craftingRemainingItem = var0;
            return this;
        }

        public Properties rarity(Rarity var0) {
            return this.component(DataComponents.RARITY, var0);
        }

        public Properties fireResistant() {
            return this.component(DataComponents.DAMAGE_RESISTANT, new DamageResistant(DamageTypeTags.IS_FIRE));
        }

        public Properties jukeboxPlayable(ResourceKey<JukeboxSong> var0) {
            return this.component(DataComponents.JUKEBOX_PLAYABLE, new JukeboxPlayable(new EitherHolder<JukeboxSong>(var0)));
        }

        public Properties enchantable(int var0) {
            return this.component(DataComponents.ENCHANTABLE, new Enchantable(var0));
        }

        public Properties repairable(Item var0) {
            return this.component(DataComponents.REPAIRABLE, new Repairable(HolderSet.direct(var0.builtInRegistryHolder())));
        }

        public Properties repairable(TagKey<Item> var0) {
            HolderGetter<Item> var1 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.ITEM);
            return this.component(DataComponents.REPAIRABLE, new Repairable(var1.getOrThrow(var0)));
        }

        public Properties equippable(EquipmentSlot var0) {
            return this.component(DataComponents.EQUIPPABLE, Equippable.builder(var0).build());
        }

        public Properties equippableUnswappable(EquipmentSlot var0) {
            return this.component(DataComponents.EQUIPPABLE, Equippable.builder(var0).setSwappable(false).build());
        }

        public Properties tool(ToolMaterial var0, TagKey<Block> var1, float var2, float var3, float var4) {
            return var0.applyToolProperties(this, var1, var2, var3, var4);
        }

        public Properties pickaxe(ToolMaterial var0, float var1, float var2) {
            return this.tool(var0, BlockTags.MINEABLE_WITH_PICKAXE, var1, var2, 0.0f);
        }

        public Properties axe(ToolMaterial var0, float var1, float var2) {
            return this.tool(var0, BlockTags.MINEABLE_WITH_AXE, var1, var2, 5.0f);
        }

        public Properties hoe(ToolMaterial var0, float var1, float var2) {
            return this.tool(var0, BlockTags.MINEABLE_WITH_HOE, var1, var2, 0.0f);
        }

        public Properties shovel(ToolMaterial var0, float var1, float var2) {
            return this.tool(var0, BlockTags.MINEABLE_WITH_SHOVEL, var1, var2, 0.0f);
        }

        public Properties sword(ToolMaterial var0, float var1, float var2) {
            return var0.applySwordProperties(this, var1, var2);
        }

        public Properties humanoidArmor(ArmorMaterial var0, ArmorType var1) {
            return this.durability(var1.getDurability(var0.durability())).attributes(var0.createAttributes(var1)).enchantable(var0.enchantmentValue()).component(DataComponents.EQUIPPABLE, Equippable.builder(var1.getSlot()).setEquipSound(var0.equipSound()).setAsset(var0.assetId()).build()).repairable(var0.repairIngredient());
        }

        public Properties wolfArmor(ArmorMaterial var0) {
            return this.durability(ArmorType.BODY.getDurability(var0.durability())).attributes(var0.createAttributes(ArmorType.BODY)).repairable(var0.repairIngredient()).component(DataComponents.EQUIPPABLE, Equippable.builder(EquipmentSlot.BODY).setEquipSound(var0.equipSound()).setAsset(var0.assetId()).setAllowedEntities(HolderSet.direct(EntityType.WOLF.builtInRegistryHolder())).setCanBeSheared(true).setShearingSound(BuiltInRegistries.SOUND_EVENT.wrapAsHolder(SoundEvents.ARMOR_UNEQUIP_WOLF)).build()).component(DataComponents.BREAK_SOUND, SoundEvents.WOLF_ARMOR_BREAK).stacksTo(1);
        }

        public Properties horseArmor(ArmorMaterial var0) {
            HolderGetter<EntityType<?>> var1 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.ENTITY_TYPE);
            return this.attributes(var0.createAttributes(ArmorType.BODY)).component(DataComponents.EQUIPPABLE, Equippable.builder(EquipmentSlot.BODY).setEquipSound(SoundEvents.HORSE_ARMOR).setAsset(var0.assetId()).setAllowedEntities(var1.getOrThrow(EntityTypeTags.CAN_WEAR_HORSE_ARMOR)).setDamageOnHurt(false).setCanBeSheared(true).setShearingSound(SoundEvents.HORSE_ARMOR_UNEQUIP).build()).stacksTo(1);
        }

        public Properties trimMaterial(ResourceKey<TrimMaterial> var0) {
            return this.component(DataComponents.PROVIDES_TRIM_MATERIAL, new ProvidesTrimMaterial(var0));
        }

        public Properties requiredFeatures(FeatureFlag ... var0) {
            this.requiredFeatures = FeatureFlags.REGISTRY.subset(var0);
            return this;
        }

        public Properties setId(ResourceKey<Item> var0) {
            this.id = var0;
            return this;
        }

        public Properties overrideDescription(String var0) {
            this.descriptionId = DependantName.fixed(var0);
            return this;
        }

        public Properties useBlockDescriptionPrefix() {
            this.descriptionId = BLOCK_DESCRIPTION_ID;
            return this;
        }

        public Properties useItemDescriptionPrefix() {
            this.descriptionId = ITEM_DESCRIPTION_ID;
            return this;
        }

        protected String effectiveDescriptionId() {
            return this.descriptionId.get(Objects.requireNonNull(this.id, "Item id not set"));
        }

        public ResourceLocation effectiveModel() {
            return this.model.get(Objects.requireNonNull(this.id, "Item id not set"));
        }

        public <T> Properties component(DataComponentType<T> var0, T var1) {
            this.components.set(var0, var1);
            return this;
        }

        public Properties attributes(ItemAttributeModifiers var0) {
            return this.component(DataComponents.ATTRIBUTE_MODIFIERS, var0);
        }

        DataComponentMap buildAndValidateComponents(Component var0, ResourceLocation var1) {
            DataComponentMap var2 = this.components.set(DataComponents.ITEM_NAME, var0).set(DataComponents.ITEM_MODEL, var1).build();
            if (var2.has(DataComponents.DAMAGE) && var2.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
                throw new IllegalStateException("Item cannot have both durability and be stackable");
            }
            return var2;
        }
    }

    public static interface TooltipContext {
        public static final TooltipContext EMPTY = new TooltipContext(){

            @Override
            @Nullable
            public HolderLookup.Provider registries() {
                return null;
            }

            @Override
            public float tickRate() {
                return 20.0f;
            }

            @Override
            @Nullable
            public MapItemSavedData mapData(MapId var0) {
                return null;
            }
        };

        @Nullable
        public HolderLookup.Provider registries();

        public float tickRate();

        @Nullable
        public MapItemSavedData mapData(MapId var1);

        public static TooltipContext of(final @Nullable Level var0) {
            if (var0 == null) {
                return EMPTY;
            }
            return new TooltipContext(){

                @Override
                public HolderLookup.Provider registries() {
                    return var0.registryAccess();
                }

                @Override
                public float tickRate() {
                    return var0.tickRateManager().tickrate();
                }

                @Override
                public MapItemSavedData mapData(MapId var02) {
                    return var0.getMapData(var02);
                }
            };
        }

        public static TooltipContext of(final HolderLookup.Provider var0) {
            return new TooltipContext(){

                @Override
                public HolderLookup.Provider registries() {
                    return var0;
                }

                @Override
                public float tickRate() {
                    return 20.0f;
                }

                @Override
                @Nullable
                public MapItemSavedData mapData(MapId var02) {
                    return null;
                }
            };
        }
    }
}

