/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.NullOps;
import net.minecraft.util.StringUtil;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.BedItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DamageResistant;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.component.UseCooldown;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.commons.lang3.function.TriConsumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R5.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftLocation;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.slf4j.Logger;

public final class ItemStack
implements DataComponentHolder {
    private static final List<Component> OP_NBT_WARNING = List.of(Component.translatable("item.op_warning.line1").withStyle(ChatFormatting.RED, ChatFormatting.BOLD), Component.translatable("item.op_warning.line2").withStyle(ChatFormatting.RED), Component.translatable("item.op_warning.line3").withStyle(ChatFormatting.RED));
    private static final Component UNBREAKABLE_TOOLTIP = Component.translatable("item.unbreakable").withStyle(ChatFormatting.BLUE);
    public static final MapCodec<ItemStack> MAP_CODEC = MapCodec.recursive((String)"ItemStack", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.intRange(1, 99).fieldOf("count").orElse((Object)1).forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(itemstack -> itemstack.components.asPatch())).apply((Applicative)instance, ItemStack::new)));
    public static final Codec<ItemStack> CODEC;
    public static final Codec<ItemStack> SINGLE_ITEM_CODEC;
    public static final Codec<ItemStack> STRICT_CODEC;
    public static final Codec<ItemStack> STRICT_SINGLE_ITEM_CODEC;
    public static final Codec<ItemStack> OPTIONAL_CODEC;
    public static final Codec<ItemStack> SIMPLE_ITEM_CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_STREAM_CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> OPTIONAL_UNTRUSTED_STREAM_CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemStack> STREAM_CODEC;
    public static final StreamCodec<RegistryFriendlyByteBuf, List<ItemStack>> OPTIONAL_LIST_STREAM_CODEC;
    private static final Logger LOGGER;
    public static final ItemStack EMPTY;
    private static final Component DISABLED_ITEM_TOOLTIP;
    private int count;
    private int popTime;
    @Deprecated
    @Nullable
    private Item item;
    final PatchedDataComponentMap components;
    @Nullable
    private Entity entityRepresentation;

    public static DataResult<ItemStack> validateStrict(ItemStack itemstack) {
        DataResult<Unit> dataresult = ItemStack.validateComponents(itemstack.getComponents());
        return dataresult.isError() ? dataresult.map(unit -> itemstack) : (itemstack.getCount() > itemstack.getMaxStackSize() ? DataResult.error(() -> {
            int i = itemstack.getCount();
            return "Item stack with stack size of " + i + " was larger than maximum: " + itemstack.getMaxStackSize();
        }) : DataResult.success((Object)itemstack));
    }

    private static StreamCodec<RegistryFriendlyByteBuf, ItemStack> createOptionalStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> streamcodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                int i = registryfriendlybytebuf.readVarInt();
                if (i <= 0) {
                    return EMPTY;
                }
                Holder holder = (Holder)Item.STREAM_CODEC.decode(registryfriendlybytebuf);
                DataComponentPatch datacomponentpatch = (DataComponentPatch)streamcodec.decode(registryfriendlybytebuf);
                ItemStack itemstack = new ItemStack(holder, i, datacomponentpatch);
                if (!datacomponentpatch.isEmpty()) {
                    CraftItemStack.setItemMeta(itemstack, CraftItemStack.getItemMeta(itemstack));
                }
                return itemstack;
            }

            @Override
            public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                if (itemstack.isEmpty() || itemstack.getItem() == null) {
                    registryfriendlybytebuf.writeVarInt(0);
                } else {
                    registryfriendlybytebuf.writeVarInt(itemstack.getCount());
                    itemstack = itemstack.copy();
                    CraftItemStack.setItemMeta(itemstack, CraftItemStack.getItemMeta(itemstack));
                    Item.STREAM_CODEC.encode(registryfriendlybytebuf, itemstack.getItemHolder());
                    streamcodec.encode(registryfriendlybytebuf, itemstack.components.asPatch());
                }
            }
        };
    }

    public static StreamCodec<RegistryFriendlyByteBuf, ItemStack> validatedStreamCodec(final StreamCodec<RegistryFriendlyByteBuf, ItemStack> streamcodec) {
        return new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                ItemStack itemstack = (ItemStack)streamcodec.decode(registryfriendlybytebuf);
                if (!itemstack.isEmpty()) {
                    RegistryOps<Unit> registryops = registryfriendlybytebuf.registryAccess().createSerializationContext(NullOps.INSTANCE);
                    CODEC.encodeStart(registryops, (Object)itemstack).getOrThrow(DecoderException::new);
                }
                return itemstack;
            }

            @Override
            public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                streamcodec.encode(registryfriendlybytebuf, itemstack);
            }
        };
    }

    public Optional<TooltipComponent> getTooltipImage() {
        return this.getItem().getTooltipImage(this);
    }

    @Override
    public DataComponentMap getComponents() {
        return !this.isEmpty() ? this.components : DataComponentMap.EMPTY;
    }

    public DataComponentMap getPrototype() {
        return !this.isEmpty() ? this.getItem().components() : DataComponentMap.EMPTY;
    }

    public DataComponentPatch getComponentsPatch() {
        return !this.isEmpty() ? this.components.asPatch() : DataComponentPatch.EMPTY;
    }

    public DataComponentMap immutableComponents() {
        return !this.isEmpty() ? this.components.toImmutableMap() : DataComponentMap.EMPTY;
    }

    public boolean hasNonDefault(DataComponentType<?> datacomponenttype) {
        return !this.isEmpty() && this.components.hasNonDefault(datacomponenttype);
    }

    public ItemStack(ItemLike imaterial) {
        this(imaterial, 1);
    }

    public ItemStack(Holder<Item> holder) {
        this(holder.value(), 1);
    }

    public ItemStack(Holder<Item> holder, int i, DataComponentPatch datacomponentpatch) {
        this(holder.value(), i, PatchedDataComponentMap.fromPatch(holder.value().components(), datacomponentpatch));
    }

    public ItemStack(Holder<Item> holder, int i) {
        this(holder.value(), i);
    }

    public ItemStack(ItemLike imaterial, int i) {
        this(imaterial, i, new PatchedDataComponentMap(imaterial.asItem().components()));
    }

    private ItemStack(ItemLike imaterial, int i, PatchedDataComponentMap patcheddatacomponentmap) {
        this.item = imaterial.asItem();
        this.count = i;
        this.components = patcheddatacomponentmap;
        this.getItem().verifyComponentsAfterLoad(this);
    }

    private ItemStack(@Nullable Void ovoid) {
        this.item = null;
        this.components = new PatchedDataComponentMap(DataComponentMap.EMPTY);
    }

    public static DataResult<Unit> validateComponents(DataComponentMap datacomponentmap) {
        if (datacomponentmap.has(DataComponents.MAX_DAMAGE) && datacomponentmap.getOrDefault(DataComponents.MAX_STACK_SIZE, 1) > 1) {
            return DataResult.error(() -> "Item cannot be both damageable and stackable");
        }
        ItemContainerContents itemcontainercontents = datacomponentmap.getOrDefault(DataComponents.CONTAINER, ItemContainerContents.EMPTY);
        for (ItemStack itemstack : itemcontainercontents.nonEmptyItems()) {
            int j;
            int i = itemstack.getCount();
            if (i <= (j = itemstack.getMaxStackSize())) continue;
            return DataResult.error(() -> "Item stack with count of " + i + " was larger than maximum: " + j);
        }
        return DataResult.success((Object)((Object)Unit.INSTANCE));
    }

    public boolean isEmpty() {
        return this == EMPTY || this.item == Items.AIR || this.count <= 0;
    }

    public boolean isItemEnabled(FeatureFlagSet featureflagset) {
        return this.isEmpty() || this.getItem().isEnabled(featureflagset);
    }

    public ItemStack split(int i) {
        int j = Math.min(i, this.getCount());
        ItemStack itemstack = this.copyWithCount(j);
        this.shrink(j);
        return itemstack;
    }

    public ItemStack copyAndClear() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = this.copy();
        this.setCount(0);
        return itemstack;
    }

    public Item getItem() {
        return this.isEmpty() ? Items.AIR : this.item;
    }

    public Holder<Item> getItemHolder() {
        return this.getItem().builtInRegistryHolder();
    }

    public boolean is(TagKey<Item> tagkey) {
        return this.getItem().builtInRegistryHolder().is(tagkey);
    }

    public boolean is(Item item) {
        return this.getItem() == item;
    }

    public boolean is(Predicate<Holder<Item>> predicate) {
        return predicate.test(this.getItem().builtInRegistryHolder());
    }

    public boolean is(Holder<Item> holder) {
        return this.getItem().builtInRegistryHolder() == holder;
    }

    public boolean is(HolderSet<Item> holderset) {
        return holderset.contains(this.getItemHolder());
    }

    public Stream<TagKey<Item>> getTags() {
        return this.getItem().builtInRegistryHolder().tags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        InteractionResult.Success enuminteractionresult_d;
        InteractionResult enuminteractionresult;
        Player entityhuman = itemactioncontext.getPlayer();
        BlockPos blockposition = itemactioncontext.getClickedPos();
        if (entityhuman != null && !entityhuman.getAbilities().mayBuild && !this.canPlaceOnBlockInAdventureMode(new BlockInWorld(itemactioncontext.getLevel(), blockposition, false))) {
            return InteractionResult.PASS;
        }
        Item item = this.getItem();
        DataComponentPatch oldData = this.components.asPatch();
        int oldCount = this.getCount();
        ServerLevel world = (ServerLevel)itemactioncontext.getLevel();
        if (!(item instanceof BucketItem) && !(item instanceof SolidBucketItem)) {
            world.captureBlockStates = true;
            if (item == Items.BONE_MEAL) {
                world.captureTreeGeneration = true;
            }
        }
        try {
            enuminteractionresult = item.useOn(itemactioncontext);
        }
        finally {
            world.captureBlockStates = false;
        }
        DataComponentPatch newData = this.components.asPatch();
        int newCount = this.getCount();
        this.setCount(oldCount);
        this.restorePatch(oldData);
        if (enuminteractionresult.consumesAction() && world.captureTreeGeneration && world.capturedBlockStates.size() > 0) {
            world.captureTreeGeneration = false;
            Location location = CraftLocation.toBukkit(blockposition, (World)world.getWorld());
            TreeType treeType = SaplingBlock.treeType;
            SaplingBlock.treeType = null;
            ArrayList blocks = new ArrayList(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            StructureGrowEvent structureEvent = null;
            if (treeType != null) {
                boolean isBonemeal = this.getItem() == Items.BONE_MEAL;
                structureEvent = new StructureGrowEvent(location, treeType, isBonemeal, (org.bukkit.entity.Player)entityhuman.getBukkitEntity(), blocks);
                Bukkit.getPluginManager().callEvent((Event)structureEvent);
            }
            BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent((org.bukkit.block.Block)CraftBlock.at(world, blockposition), (org.bukkit.entity.Player)entityhuman.getBukkitEntity(), blocks);
            fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
            Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
            if (!fertilizeEvent.isCancelled()) {
                if (this.getCount() == oldCount && Objects.equals(this.components.asPatch(), oldData)) {
                    this.restorePatch(newData);
                    this.setCount(newCount);
                }
                for (CraftBlockState blockstate : blocks) {
                    CapturedBlockState.setBlockState(blockstate);
                }
                entityhuman.awardStat(Stats.ITEM_USED.get(item));
            }
            SignItem.openSign = null;
            return enuminteractionresult;
        }
        world.captureTreeGeneration = false;
        if (entityhuman != null && enuminteractionresult instanceof InteractionResult.Success && (enuminteractionresult_d = (InteractionResult.Success)enuminteractionresult).wasItemInteraction()) {
            InteractionHand enumhand = itemactioncontext.getHand();
            BlockMultiPlaceEvent placeEvent = null;
            ArrayList<BlockState> blocks = new ArrayList<BlockState>(world.capturedBlockStates.values());
            world.capturedBlockStates.clear();
            if (blocks.size() > 1) {
                placeEvent = CraftEventFactory.callBlockMultiPlaceEvent(world, entityhuman, enumhand, blocks, blockposition.getX(), blockposition.getY(), blockposition.getZ());
            } else if (blocks.size() == 1) {
                placeEvent = CraftEventFactory.callBlockPlaceEvent(world, entityhuman, enumhand, (BlockState)blocks.get(0), blockposition.getX(), blockposition.getY(), blockposition.getZ());
            }
            if (placeEvent != null && (placeEvent.isCancelled() || !placeEvent.canBuild())) {
                enuminteractionresult = InteractionResult.FAIL;
                placeEvent.getPlayer().updateInventory();
                world.preventPoiUpdated = true;
                for (BlockState blockState : blocks) {
                    blockState.update(true, false);
                }
                world.preventPoiUpdated = false;
                BlockPos placedPos = ((CraftBlock)placeEvent.getBlock()).getPosition();
                for (Direction dir : Direction.values()) {
                    ((ServerPlayer)entityhuman).connection.send(new ClientboundBlockUpdatePacket(world, placedPos.relative(dir)));
                }
                SignItem.openSign = null;
            } else {
                BlockPos position;
                net.minecraft.world.level.block.state.BlockState blockState;
                if (this.getCount() == oldCount && Objects.equals(this.components.asPatch(), oldData)) {
                    this.restorePatch(newData);
                    this.setCount(newCount);
                }
                for (Map.Entry entry : world.capturedTileEntities.entrySet()) {
                    world.setBlockEntity((BlockEntity)entry.getValue());
                }
                for (BlockState blockState2 : blocks) {
                    int updateFlag = ((CraftBlockState)blockState2).getFlag();
                    net.minecraft.world.level.block.state.BlockState oldBlock = ((CraftBlockState)blockState2).getHandle();
                    BlockPos newblockposition = ((CraftBlockState)blockState2).getPosition();
                    net.minecraft.world.level.block.state.BlockState block = world.getBlockState(newblockposition);
                    if (!(block.getBlock() instanceof BaseEntityBlock)) {
                        block.onPlace(world, newblockposition, oldBlock, true, itemactioncontext);
                    }
                    world.notifyAndUpdatePhysics(newblockposition, null, oldBlock, block, world.getBlockState(newblockposition), updateFlag, 512);
                }
                if (this.item == Items.WITHER_SKELETON_SKULL) {
                    BlockEntity blockEntity;
                    BlockPos bp = blockposition;
                    if (!world.getBlockState(blockposition).canBeReplaced()) {
                        bp = !world.getBlockState(blockposition).isSolid() ? null : bp.relative(itemactioncontext.getClickedFace());
                    }
                    if (bp != null && (blockEntity = world.getBlockEntity(bp)) instanceof SkullBlockEntity) {
                        WitherSkullBlock.checkSpawn(world, bp, (SkullBlockEntity)blockEntity);
                    }
                }
                if (this.item instanceof SignItem && SignItem.openSign != null) {
                    try {
                        BlockEntity blockEntity = world.getBlockEntity(SignItem.openSign);
                        if (blockEntity instanceof SignBlockEntity) {
                            SignBlockEntity tileentitysign = (SignBlockEntity)blockEntity;
                            Block block = world.getBlockState(SignItem.openSign).getBlock();
                            if (block instanceof SignBlock) {
                                SignBlock signBlock = (SignBlock)block;
                                signBlock.openTextEdit(entityhuman, tileentitysign, true, PlayerSignOpenEvent.Cause.PLACE);
                            }
                        }
                    }
                    finally {
                        SignItem.openSign = null;
                    }
                }
                if (placeEvent != null && this.item instanceof BedItem && (blockState = world.getBlockState(position = ((CraftBlock)placeEvent.getBlock()).getPosition())).getBlock() instanceof BedBlock) {
                    world.updateNeighborsAt(position, Blocks.AIR);
                    blockState.updateNeighbourShapes(world, position, 3);
                }
                if (this.item instanceof BlockItem) {
                    SoundType soundeffecttype = ((BlockItem)this.item).getBlock().defaultBlockState().getSoundType();
                    world.playSound((Entity)entityhuman, blockposition, soundeffecttype.getPlaceSound(), SoundSource.BLOCKS, (soundeffecttype.getVolume() + 1.0f) / 2.0f, soundeffecttype.getPitch() * 0.8f);
                }
                entityhuman.awardStat(Stats.ITEM_USED.get(item));
            }
        }
        world.capturedTileEntities.clear();
        world.capturedBlockStates.clear();
        return enuminteractionresult;
    }

    public float getDestroySpeed(net.minecraft.world.level.block.state.BlockState iblockdata) {
        return this.getItem().getDestroySpeed(this, iblockdata);
    }

    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = this.copy();
        boolean flag = this.getUseDuration(entityhuman) <= 0;
        InteractionResult enuminteractionresult = this.getItem().use(world, entityhuman, enumhand);
        if (flag && enuminteractionresult instanceof InteractionResult.Success) {
            InteractionResult.Success enuminteractionresult_d;
            return enuminteractionresult_d.heldItemTransformedTo((enuminteractionresult_d = (InteractionResult.Success)enuminteractionresult).heldItemTransformedTo() == null ? this.applyAfterUseComponentSideEffects(entityhuman, itemstack) : enuminteractionresult_d.heldItemTransformedTo().applyAfterUseComponentSideEffects(entityhuman, itemstack));
        }
        return enuminteractionresult;
    }

    public ItemStack finishUsingItem(Level world, LivingEntity entityliving) {
        ItemStack itemstack = this.copy();
        ItemStack itemstack1 = this.getItem().finishUsingItem(this, world, entityliving);
        return itemstack1.applyAfterUseComponentSideEffects(entityliving, itemstack);
    }

    private ItemStack applyAfterUseComponentSideEffects(LivingEntity entityliving, ItemStack itemstack) {
        UseRemainder useremainder = itemstack.get(DataComponents.USE_REMAINDER);
        UseCooldown usecooldown = itemstack.get(DataComponents.USE_COOLDOWN);
        int i = itemstack.getCount();
        ItemStack itemstack1 = this;
        if (useremainder != null) {
            boolean flag = entityliving.hasInfiniteMaterials();
            Objects.requireNonNull(entityliving);
            itemstack1 = useremainder.convertIntoRemainder(this, i, flag, entityliving::handleExtraItemsCreatedOnUse);
        }
        if (usecooldown != null) {
            usecooldown.apply(itemstack, entityliving);
        }
        return itemstack1;
    }

    public int getMaxStackSize() {
        return this.getOrDefault(DataComponents.MAX_STACK_SIZE, 1);
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isDamageableItem() || !this.isDamaged());
    }

    public boolean isDamageableItem() {
        return this.has(DataComponents.MAX_DAMAGE) && !this.has(DataComponents.UNBREAKABLE) && this.has(DataComponents.DAMAGE);
    }

    public boolean isDamaged() {
        return this.isDamageableItem() && this.getDamageValue() > 0;
    }

    public int getDamageValue() {
        return Mth.clamp(this.getOrDefault(DataComponents.DAMAGE, 0), 0, this.getMaxDamage());
    }

    public void setDamageValue(int i) {
        this.set(DataComponents.DAMAGE, Mth.clamp(i, 0, this.getMaxDamage()));
    }

    public int getMaxDamage() {
        return this.getOrDefault(DataComponents.MAX_DAMAGE, 0);
    }

    public boolean isBroken() {
        return this.isDamageableItem() && this.getDamageValue() >= this.getMaxDamage();
    }

    public boolean nextDamageWillBreak() {
        return this.isDamageableItem() && this.getDamageValue() >= this.getMaxDamage() - 1;
    }

    public void hurtAndBreak(int i, ServerLevel worldserver, @Nullable ServerPlayer entityplayer, Consumer<Item> consumer) {
        int j = this.processDurabilityChange(i, worldserver, entityplayer);
        if (entityplayer != null) {
            PlayerItemDamageEvent event = new PlayerItemDamageEvent((org.bukkit.entity.Player)entityplayer.getBukkitEntity(), (org.bukkit.inventory.ItemStack)CraftItemStack.asCraftMirror(this), j);
            event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
            if (j != event.getDamage() || event.isCancelled()) {
                event.getPlayer().updateInventory();
            }
            if (event.isCancelled()) {
                return;
            }
            j = event.getDamage();
        }
        if (j != 0) {
            this.applyDamage(this.getDamageValue() + j, entityplayer, consumer);
        }
    }

    private int processDurabilityChange(int i, ServerLevel worldserver, @Nullable ServerPlayer entityplayer) {
        return !this.isDamageableItem() ? 0 : (entityplayer != null && entityplayer.hasInfiniteMaterials() ? 0 : (i > 0 ? EnchantmentHelper.processDurabilityChange(worldserver, this, i) : i));
    }

    private void applyDamage(int i, @Nullable ServerPlayer entityplayer, Consumer<Item> consumer) {
        if (entityplayer != null) {
            CriteriaTriggers.ITEM_DURABILITY_CHANGED.trigger(entityplayer, this, i);
        }
        this.setDamageValue(i);
        if (this.isBroken()) {
            Item item = this.getItem();
            if (this.count == 1 && entityplayer != null) {
                CraftEventFactory.callPlayerItemBreakEvent(entityplayer, this);
            }
            this.shrink(1);
            consumer.accept(item);
        }
    }

    public void hurtWithoutBreaking(int i, Player entityhuman) {
        if (entityhuman instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entityhuman;
            int j = this.processDurabilityChange(i, entityplayer.level(), entityplayer);
            if (j == 0) {
                return;
            }
            int k = Math.min(this.getDamageValue() + j, this.getMaxDamage() - 1);
            this.applyDamage(k, entityplayer, item -> {});
        }
    }

    public void hurtAndBreak(int i, LivingEntity entityliving, InteractionHand enumhand) {
        this.hurtAndBreak(i, entityliving, LivingEntity.getSlotForHand(enumhand));
    }

    public void hurtAndBreak(int i, LivingEntity entityliving, EquipmentSlot enumitemslot) {
        Level world = entityliving.level();
        if (world instanceof ServerLevel) {
            ServerPlayer entityplayer1;
            ServerLevel worldserver = (ServerLevel)world;
            ServerPlayer entityplayer = entityliving instanceof ServerPlayer ? (entityplayer1 = (ServerPlayer)entityliving) : null;
            this.hurtAndBreak(i, worldserver, entityplayer, item -> entityliving.onEquippedItemBroken((Item)item, enumitemslot));
        }
    }

    public ItemStack hurtAndConvertOnBreak(int i, ItemLike imaterial, LivingEntity entityliving, EquipmentSlot enumitemslot) {
        this.hurtAndBreak(i, entityliving, enumitemslot);
        if (this.isEmpty()) {
            ItemStack itemstack = this.transmuteCopyIgnoreEmpty(imaterial, 1);
            if (itemstack.isDamageableItem()) {
                itemstack.setDamageValue(0);
            }
            return itemstack;
        }
        return this;
    }

    public boolean isBarVisible() {
        return this.getItem().isBarVisible(this);
    }

    public int getBarWidth() {
        return this.getItem().getBarWidth(this);
    }

    public int getBarColor() {
        return this.getItem().getBarColor(this);
    }

    public boolean overrideStackedOnOther(Slot slot, ClickAction clickaction, Player entityhuman) {
        return this.getItem().overrideStackedOnOther(this, slot, clickaction, entityhuman);
    }

    public boolean overrideOtherStackedOnMe(ItemStack itemstack, Slot slot, ClickAction clickaction, Player entityhuman, SlotAccess slotaccess) {
        return this.getItem().overrideOtherStackedOnMe(this, itemstack, slot, clickaction, entityhuman, slotaccess);
    }

    public boolean hurtEnemy(LivingEntity entityliving, LivingEntity entityliving1) {
        Item item = this.getItem();
        item.hurtEnemy(this, entityliving, entityliving1);
        if (this.has(DataComponents.WEAPON)) {
            if (entityliving1 instanceof Player) {
                Player entityhuman = (Player)entityliving1;
                entityhuman.awardStat(Stats.ITEM_USED.get(item));
            }
            return true;
        }
        return false;
    }

    public void postHurtEnemy(LivingEntity entityliving, LivingEntity entityliving1) {
        this.getItem().postHurtEnemy(this, entityliving, entityliving1);
        Weapon weapon = this.get(DataComponents.WEAPON);
        if (weapon != null) {
            this.hurtAndBreak(weapon.itemDamagePerAttack(), entityliving1, EquipmentSlot.MAINHAND);
        }
    }

    public void mineBlock(Level world, net.minecraft.world.level.block.state.BlockState iblockdata, BlockPos blockposition, Player entityhuman) {
        Item item = this.getItem();
        if (item.mineBlock(this, world, iblockdata, blockposition, entityhuman)) {
            entityhuman.awardStat(Stats.ITEM_USED.get(item));
        }
    }

    public boolean isCorrectToolForDrops(net.minecraft.world.level.block.state.BlockState iblockdata) {
        return this.getItem().isCorrectToolForDrops(this, iblockdata);
    }

    public InteractionResult interactLivingEntity(Player entityhuman, LivingEntity entityliving, InteractionHand enumhand) {
        InteractionResult enuminteractionresult;
        Equippable equippable = this.get(DataComponents.EQUIPPABLE);
        if (equippable != null && equippable.equipOnInteract() && (enuminteractionresult = equippable.equipOnTarget(entityhuman, entityliving, this)) != InteractionResult.PASS) {
            return enuminteractionresult;
        }
        return this.getItem().interactLivingEntity(this, entityhuman, entityliving, enumhand);
    }

    public ItemStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = new ItemStack(this.getItem(), this.count, this.components.copy());
        itemstack.setPopTime(this.getPopTime());
        return itemstack;
    }

    public ItemStack copyWithCount(int i) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        ItemStack itemstack = this.copy();
        itemstack.setCount(i);
        return itemstack;
    }

    public ItemStack transmuteCopy(ItemLike imaterial) {
        return this.transmuteCopy(imaterial, this.getCount());
    }

    public ItemStack transmuteCopy(ItemLike imaterial, int i) {
        return this.isEmpty() ? EMPTY : this.transmuteCopyIgnoreEmpty(imaterial, i);
    }

    private ItemStack transmuteCopyIgnoreEmpty(ItemLike imaterial, int i) {
        return new ItemStack(imaterial.asItem().builtInRegistryHolder(), i, this.components.asPatch());
    }

    public static boolean matches(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack == itemstack1 ? true : (itemstack.getCount() != itemstack1.getCount() ? false : ItemStack.isSameItemSameComponents(itemstack, itemstack1));
    }

    @Deprecated
    public static boolean listMatches(List<ItemStack> list, List<ItemStack> list1) {
        if (list.size() != list1.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (ItemStack.matches(list.get(i), list1.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameItem(ItemStack itemstack, ItemStack itemstack1) {
        return itemstack.is(itemstack1.getItem());
    }

    public static boolean isSameItemSameComponents(ItemStack itemstack, ItemStack itemstack1) {
        return !itemstack.is(itemstack1.getItem()) ? false : (itemstack.isEmpty() && itemstack1.isEmpty() ? true : Objects.equals(itemstack.components, itemstack1.components));
    }

    public static MapCodec<ItemStack> lenientOptionalFieldOf(String s) {
        return CODEC.lenientOptionalFieldOf(s).xmap(optional -> optional.orElse(EMPTY), itemstack -> itemstack.isEmpty() ? Optional.empty() : Optional.of(itemstack));
    }

    public static int hashItemAndComponents(@Nullable ItemStack itemstack) {
        if (itemstack != null) {
            int i = 31 + itemstack.getItem().hashCode();
            return 31 * i + itemstack.getComponents().hashCode();
        }
        return 0;
    }

    @Deprecated
    public static int hashStackList(List<ItemStack> list) {
        int i = 0;
        for (ItemStack itemstack : list) {
            i = i * 31 + ItemStack.hashItemAndComponents(itemstack);
        }
        return i;
    }

    public String toString() {
        int i = this.getCount();
        return i + " " + String.valueOf(this.getItem());
    }

    public void inventoryTick(Level world, Entity entity, @Nullable EquipmentSlot enumitemslot) {
        if (this.popTime > 0) {
            --this.popTime;
        }
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            this.getItem().inventoryTick(this, worldserver, entity, enumitemslot);
        }
    }

    public void onCraftedBy(Player entityhuman, int i) {
        entityhuman.awardStat(Stats.ITEM_CRAFTED.get(this.getItem()), i);
        this.getItem().onCraftedBy(this, entityhuman);
    }

    public void onCraftedBySystem(Level world) {
        this.getItem().onCraftedPostProcess(this, world);
    }

    public int getUseDuration(LivingEntity entityliving) {
        return this.getItem().getUseDuration(this, entityliving);
    }

    public ItemUseAnimation getUseAnimation() {
        return this.getItem().getUseAnimation(this);
    }

    public void releaseUsing(Level world, LivingEntity entityliving, int i) {
        ItemStack itemstack1;
        ItemStack itemstack = this.copy();
        if (this.getItem().releaseUsing(this, world, entityliving, i) && (itemstack1 = this.applyAfterUseComponentSideEffects(entityliving, itemstack)) != this) {
            entityliving.setItemInHand(entityliving.getUsedItemHand(), itemstack1);
        }
    }

    public boolean useOnRelease() {
        return this.getItem().useOnRelease(this);
    }

    public void restorePatch(DataComponentPatch datacomponentpatch) {
        this.components.restorePatch(datacomponentpatch);
    }

    @Nullable
    public <T> T set(DataComponentType<T> datacomponenttype, @Nullable T t0) {
        return this.components.set(datacomponenttype, t0);
    }

    public <T> void copyFrom(DataComponentType<T> datacomponenttype, DataComponentGetter datacomponentgetter) {
        this.set(datacomponenttype, datacomponentgetter.get(datacomponenttype));
    }

    @Nullable
    public <T, U> T update(DataComponentType<T> datacomponenttype, T t0, U u0, BiFunction<T, U, T> bifunction) {
        return this.set(datacomponenttype, bifunction.apply(this.getOrDefault(datacomponenttype, t0), u0));
    }

    @Nullable
    public <T> T update(DataComponentType<T> datacomponenttype, T t0, UnaryOperator<T> unaryoperator) {
        T t1 = this.getOrDefault(datacomponenttype, t0);
        return this.set(datacomponenttype, unaryoperator.apply(t1));
    }

    @Nullable
    public <T> T remove(DataComponentType<? extends T> datacomponenttype) {
        return this.components.remove(datacomponenttype);
    }

    public void applyComponentsAndValidate(DataComponentPatch datacomponentpatch) {
        DataComponentPatch datacomponentpatch1 = this.components.asPatch();
        this.components.applyPatch(datacomponentpatch);
        Optional optional = ItemStack.validateStrict(this).error();
        if (optional.isPresent()) {
            LOGGER.error("Failed to apply component patch '{}' to item: '{}'", (Object)datacomponentpatch, (Object)((DataResult.Error)optional.get()).message());
            this.components.restorePatch(datacomponentpatch1);
        } else {
            this.getItem().verifyComponentsAfterLoad(this);
        }
    }

    public void applyComponents(DataComponentPatch datacomponentpatch) {
        this.components.applyPatch(datacomponentpatch);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public void applyComponents(DataComponentMap datacomponentmap) {
        this.components.setAll(datacomponentmap);
        this.getItem().verifyComponentsAfterLoad(this);
    }

    public Component getHoverName() {
        Component ichatbasecomponent = this.getCustomName();
        return ichatbasecomponent != null ? ichatbasecomponent : this.getItemName();
    }

    @Nullable
    public Component getCustomName() {
        String s;
        Component ichatbasecomponent = this.get(DataComponents.CUSTOM_NAME);
        if (ichatbasecomponent != null) {
            return ichatbasecomponent;
        }
        WrittenBookContent writtenbookcontent = this.get(DataComponents.WRITTEN_BOOK_CONTENT);
        if (writtenbookcontent != null && !StringUtil.isBlank(s = writtenbookcontent.title().raw())) {
            return Component.literal(s);
        }
        return null;
    }

    public Component getItemName() {
        return this.getItem().getName(this);
    }

    public Component getStyledHoverName() {
        MutableComponent ichatmutablecomponent = Component.empty().append(this.getHoverName()).withStyle(this.getRarity().color());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            ichatmutablecomponent.withStyle(ChatFormatting.ITALIC);
        }
        return ichatmutablecomponent;
    }

    public <T extends TooltipProvider> void addToTooltip(DataComponentType<T> datacomponenttype, Item.TooltipContext item_b, TooltipDisplay tooltipdisplay, Consumer<Component> consumer, TooltipFlag tooltipflag) {
        TooltipProvider t0 = (TooltipProvider)this.get(datacomponenttype);
        if (t0 != null && tooltipdisplay.shows(datacomponenttype)) {
            t0.addToTooltip(item_b, consumer, tooltipflag, this.components);
        }
    }

    public List<Component> getTooltipLines(Item.TooltipContext item_b, @Nullable Player entityhuman, TooltipFlag tooltipflag) {
        TooltipDisplay tooltipdisplay = this.getOrDefault(DataComponents.TOOLTIP_DISPLAY, TooltipDisplay.DEFAULT);
        if (!tooltipflag.isCreative() && tooltipdisplay.hideTooltip()) {
            boolean flag = this.getItem().shouldPrintOpWarning(this, entityhuman);
            return flag ? OP_NBT_WARNING : List.of();
        }
        ArrayList list = Lists.newArrayList();
        list.add(this.getStyledHoverName());
        Objects.requireNonNull(list);
        this.addDetailsToTooltip(item_b, tooltipdisplay, entityhuman, tooltipflag, list::add);
        return list;
    }

    public void addDetailsToTooltip(Item.TooltipContext item_b, TooltipDisplay tooltipdisplay, @Nullable Player entityhuman, TooltipFlag tooltipflag, Consumer<Component> consumer) {
        boolean flag;
        AdventureModePredicate adventuremodepredicate1;
        AdventureModePredicate adventuremodepredicate;
        this.getItem().appendHoverText(this, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.TROPICAL_FISH_PATTERN, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.INSTRUMENT, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.MAP_ID, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.BEES, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.CONTAINER_LOOT, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.CONTAINER, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.BANNER_PATTERNS, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.POT_DECORATIONS, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.WRITTEN_BOOK_CONTENT, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.CHARGED_PROJECTILES, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.FIREWORKS, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.FIREWORK_EXPLOSION, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.POTION_CONTENTS, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.JUKEBOX_PLAYABLE, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.TRIM, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.STORED_ENCHANTMENTS, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.ENCHANTMENTS, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.DYED_COLOR, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.LORE, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addAttributeTooltips(consumer, tooltipdisplay, entityhuman);
        if (this.has(DataComponents.UNBREAKABLE) && tooltipdisplay.shows(DataComponents.UNBREAKABLE)) {
            consumer.accept(UNBREAKABLE_TOOLTIP);
        }
        this.addToTooltip(DataComponents.OMINOUS_BOTTLE_AMPLIFIER, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.SUSPICIOUS_STEW_EFFECTS, item_b, tooltipdisplay, consumer, tooltipflag);
        this.addToTooltip(DataComponents.BLOCK_STATE, item_b, tooltipdisplay, consumer, tooltipflag);
        if ((this.is(Items.SPAWNER) || this.is(Items.TRIAL_SPAWNER)) && tooltipdisplay.shows(DataComponents.BLOCK_ENTITY_DATA)) {
            CustomData customdata = this.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, CustomData.EMPTY);
            Spawner.appendHoverText(customdata, consumer, "SpawnData");
        }
        if ((adventuremodepredicate = this.get(DataComponents.CAN_BREAK)) != null && tooltipdisplay.shows(DataComponents.CAN_BREAK)) {
            consumer.accept(CommonComponents.EMPTY);
            consumer.accept(AdventureModePredicate.CAN_BREAK_HEADER);
            adventuremodepredicate.addToTooltip(consumer);
        }
        if ((adventuremodepredicate1 = this.get(DataComponents.CAN_PLACE_ON)) != null && tooltipdisplay.shows(DataComponents.CAN_PLACE_ON)) {
            consumer.accept(CommonComponents.EMPTY);
            consumer.accept(AdventureModePredicate.CAN_PLACE_HEADER);
            adventuremodepredicate1.addToTooltip(consumer);
        }
        if (tooltipflag.isAdvanced()) {
            if (this.isDamaged() && tooltipdisplay.shows(DataComponents.DAMAGE)) {
                consumer.accept(Component.translatable("item.durability", this.getMaxDamage() - this.getDamageValue(), this.getMaxDamage()));
            }
            consumer.accept(Component.literal(BuiltInRegistries.ITEM.getKey(this.getItem()).toString()).withStyle(ChatFormatting.DARK_GRAY));
            int i = this.components.size();
            if (i > 0) {
                consumer.accept(Component.translatable("item.components", i).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (entityhuman != null && !this.getItem().isEnabled(entityhuman.level().enabledFeatures())) {
            consumer.accept(DISABLED_ITEM_TOOLTIP);
        }
        if (flag = this.getItem().shouldPrintOpWarning(this, entityhuman)) {
            OP_NBT_WARNING.forEach(consumer);
        }
    }

    private void addAttributeTooltips(Consumer<Component> consumer, TooltipDisplay tooltipdisplay, @Nullable Player entityhuman) {
        if (tooltipdisplay.shows(DataComponents.ATTRIBUTE_MODIFIERS)) {
            for (EquipmentSlotGroup equipmentslotgroup : EquipmentSlotGroup.values()) {
                MutableBoolean mutableboolean = new MutableBoolean(true);
                this.forEachModifier(equipmentslotgroup, (TriConsumer<Holder<Attribute>, AttributeModifier, ItemAttributeModifiers.Display>)((TriConsumer)(holder, attributemodifier, itemattributemodifiers_b) -> {
                    if (itemattributemodifiers_b != ItemAttributeModifiers.Display.hidden()) {
                        if (mutableboolean.isTrue()) {
                            consumer.accept(CommonComponents.EMPTY);
                            consumer.accept(Component.translatable("item.modifiers." + equipmentslotgroup.getSerializedName()).withStyle(ChatFormatting.GRAY));
                            mutableboolean.setFalse();
                        }
                        itemattributemodifiers_b.apply(consumer, entityhuman, (Holder<Attribute>)holder, (AttributeModifier)attributemodifier);
                    }
                }));
            }
        }
    }

    public boolean hasFoil() {
        Boolean obool = this.get(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
        return obool != null ? obool.booleanValue() : this.getItem().isFoil(this);
    }

    public Rarity getRarity() {
        Rarity enumitemrarity = this.getOrDefault(DataComponents.RARITY, Rarity.COMMON);
        if (!this.isEnchanted()) {
            return enumitemrarity;
        }
        return switch (enumitemrarity) {
            case Rarity.COMMON, Rarity.UNCOMMON -> Rarity.RARE;
            case Rarity.RARE -> Rarity.EPIC;
            default -> enumitemrarity;
        };
    }

    public boolean isEnchantable() {
        if (!this.has(DataComponents.ENCHANTABLE)) {
            return false;
        }
        ItemEnchantments itemenchantments = this.get(DataComponents.ENCHANTMENTS);
        return itemenchantments != null && itemenchantments.isEmpty();
    }

    public void enchant(Holder<Enchantment> holder, int i) {
        EnchantmentHelper.updateEnchantments(this, itemenchantments_a -> itemenchantments_a.upgrade(holder, i));
    }

    public boolean isEnchanted() {
        return !this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY).isEmpty();
    }

    public ItemEnchantments getEnchantments() {
        return this.getOrDefault(DataComponents.ENCHANTMENTS, ItemEnchantments.EMPTY);
    }

    public boolean isFramed() {
        return this.entityRepresentation instanceof ItemFrame;
    }

    public void setEntityRepresentation(@Nullable Entity entity) {
        if (!this.isEmpty()) {
            this.entityRepresentation = entity;
        }
    }

    @Nullable
    public ItemFrame getFrame() {
        return this.entityRepresentation instanceof ItemFrame ? (ItemFrame)this.getEntityRepresentation() : null;
    }

    @Nullable
    public Entity getEntityRepresentation() {
        return !this.isEmpty() ? this.entityRepresentation : null;
    }

    public void forEachModifier(EquipmentSlotGroup equipmentslotgroup, TriConsumer<Holder<Attribute>, AttributeModifier, ItemAttributeModifiers.Display> triconsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        itemattributemodifiers.forEach(equipmentslotgroup, triconsumer);
        EnchantmentHelper.forEachModifier(this, equipmentslotgroup, (holder, attributemodifier) -> triconsumer.accept(holder, attributemodifier, (Object)ItemAttributeModifiers.Display.attributeModifiers()));
    }

    public void forEachModifier(EquipmentSlot enumitemslot, BiConsumer<Holder<Attribute>, AttributeModifier> biconsumer) {
        ItemAttributeModifiers itemattributemodifiers = this.getOrDefault(DataComponents.ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY);
        itemattributemodifiers.forEach(enumitemslot, biconsumer);
        EnchantmentHelper.forEachModifier(this, enumitemslot, biconsumer);
    }

    @Deprecated
    public void setItem(Item item) {
        this.item = item;
    }

    public Component getDisplayName() {
        MutableComponent ichatmutablecomponent = Component.empty().append(this.getHoverName());
        if (this.has(DataComponents.CUSTOM_NAME)) {
            ichatmutablecomponent.withStyle(ChatFormatting.ITALIC);
        }
        MutableComponent ichatmutablecomponent1 = ComponentUtils.wrapInSquareBrackets(ichatmutablecomponent);
        if (!this.isEmpty()) {
            ichatmutablecomponent1.withStyle(this.getRarity().color()).withStyle(chatmodifier -> chatmodifier.withHoverEvent(new HoverEvent.ShowItem(this)));
        }
        return ichatmutablecomponent1;
    }

    public boolean canPlaceOnBlockInAdventureMode(BlockInWorld shapedetectorblock) {
        AdventureModePredicate adventuremodepredicate = this.get(DataComponents.CAN_PLACE_ON);
        return adventuremodepredicate != null && adventuremodepredicate.test(shapedetectorblock);
    }

    public boolean canBreakBlockInAdventureMode(BlockInWorld shapedetectorblock) {
        AdventureModePredicate adventuremodepredicate = this.get(DataComponents.CAN_BREAK);
        return adventuremodepredicate != null && adventuremodepredicate.test(shapedetectorblock);
    }

    public int getPopTime() {
        return this.popTime;
    }

    public void setPopTime(int i) {
        this.popTime = i;
    }

    public int getCount() {
        return this.isEmpty() ? 0 : this.count;
    }

    public void setCount(int i) {
        this.count = i;
    }

    public void limitSize(int i) {
        if (!this.isEmpty() && this.getCount() > i) {
            this.setCount(i);
        }
    }

    public void grow(int i) {
        this.setCount(this.getCount() + i);
    }

    public void shrink(int i) {
        this.grow(-i);
    }

    public void consume(int i, @Nullable LivingEntity entityliving) {
        if (!(entityliving != null && entityliving.hasInfiniteMaterials() || this == EMPTY)) {
            this.shrink(i);
        }
    }

    public ItemStack consumeAndReturn(int i, @Nullable LivingEntity entityliving) {
        ItemStack itemstack = this.copyWithCount(i);
        this.consume(i, entityliving);
        return itemstack;
    }

    public void onUseTick(Level world, LivingEntity entityliving, int i) {
        Consumable consumable = this.get(DataComponents.CONSUMABLE);
        if (consumable != null && consumable.shouldEmitParticlesAndSounds(i)) {
            consumable.emitParticlesAndSounds(entityliving.getRandom(), entityliving, this, 5);
        }
        this.getItem().onUseTick(world, entityliving, this, i);
    }

    public void onDestroyed(ItemEntity entityitem) {
        this.getItem().onDestroyed(entityitem);
    }

    public boolean canBeHurtBy(DamageSource damagesource) {
        DamageResistant damageresistant = this.get(DataComponents.DAMAGE_RESISTANT);
        return damageresistant == null || !damageresistant.isResistantTo(damagesource);
    }

    public boolean isValidRepairItem(ItemStack itemstack) {
        Repairable repairable = this.get(DataComponents.REPAIRABLE);
        return repairable != null && repairable.isValidRepairItem(itemstack);
    }

    public boolean canDestroyBlock(net.minecraft.world.level.block.state.BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman) {
        return this.getItem().canDestroyBlock(this, iblockdata, world, blockposition, entityhuman);
    }

    static {
        MapCodec<ItemStack> mapcodec = MAP_CODEC;
        Objects.requireNonNull(mapcodec);
        CODEC = Codec.lazyInitialized(() -> mapcodec.codec());
        SINGLE_ITEM_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(instance -> instance.group((App)Item.CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(itemstack -> itemstack.components.asPatch())).apply((Applicative)instance, (holder, datacomponentpatch) -> new ItemStack((Holder<Item>)holder, 1, (DataComponentPatch)datacomponentpatch))));
        STRICT_CODEC = CODEC.validate(ItemStack::validateStrict);
        STRICT_SINGLE_ITEM_CODEC = SINGLE_ITEM_CODEC.validate(ItemStack::validateStrict);
        OPTIONAL_CODEC = ExtraCodecs.optionalEmptyMap(CODEC).xmap(optional -> optional.orElse(EMPTY), itemstack -> itemstack.isEmpty() ? Optional.empty() : Optional.of(itemstack));
        SIMPLE_ITEM_CODEC = Item.CODEC.xmap(ItemStack::new, ItemStack::getItemHolder);
        OPTIONAL_STREAM_CODEC = ItemStack.createOptionalStreamCodec(DataComponentPatch.STREAM_CODEC);
        OPTIONAL_UNTRUSTED_STREAM_CODEC = ItemStack.createOptionalStreamCodec(DataComponentPatch.DELIMITED_STREAM_CODEC);
        STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemStack>(){

            @Override
            public ItemStack decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
                ItemStack itemstack = (ItemStack)OPTIONAL_STREAM_CODEC.decode(registryfriendlybytebuf);
                if (itemstack.isEmpty()) {
                    throw new DecoderException("Empty ItemStack not allowed");
                }
                return itemstack;
            }

            @Override
            public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, ItemStack itemstack) {
                if (itemstack.isEmpty()) {
                    throw new EncoderException("Empty ItemStack not allowed");
                }
                OPTIONAL_STREAM_CODEC.encode(registryfriendlybytebuf, itemstack);
            }
        };
        OPTIONAL_LIST_STREAM_CODEC = OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity));
        LOGGER = LogUtils.getLogger();
        EMPTY = new ItemStack((Void)null);
        DISABLED_ITEM_TOOLTIP = Component.translatable("item.disabled").withStyle(ChatFormatting.RED);
    }
}

