/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class ShearsItem
extends Item {
    public ShearsItem(Item.Properties var0) {
        super(var0);
    }

    public static Tool createToolProperties() {
        HolderGetter<Block> var0 = BuiltInRegistries.acquireBootstrapRegistrationLookup(BuiltInRegistries.BLOCK);
        return new Tool(List.of(Tool.Rule.minesAndDrops(HolderSet.direct(Blocks.COBWEB.builtInRegistryHolder()), 15.0f), Tool.Rule.overrideSpeed(var0.getOrThrow(BlockTags.LEAVES), 15.0f), Tool.Rule.overrideSpeed(var0.getOrThrow(BlockTags.WOOL), 5.0f), Tool.Rule.overrideSpeed(HolderSet.direct(Blocks.VINE.builtInRegistryHolder(), Blocks.GLOW_LICHEN.builtInRegistryHolder()), 2.0f)), 1.0f, 1, true);
    }

    @Override
    public boolean mineBlock(ItemStack var0, Level var1, BlockState var2, BlockPos var3, LivingEntity var4) {
        Tool var5 = var0.get(DataComponents.TOOL);
        if (var5 == null) {
            return false;
        }
        if (!var1.isClientSide() && !var2.is(BlockTags.FIRE) && var5.damagePerBlock() > 0) {
            var0.hurtAndBreak(var5.damagePerBlock(), var4, EquipmentSlot.MAINHAND);
        }
        return true;
    }

    @Override
    public InteractionResult useOn(UseOnContext var0) {
        GrowingPlantHeadBlock var5;
        BlockPos var2;
        Level var1 = var0.getLevel();
        BlockState var3 = var1.getBlockState(var2 = var0.getClickedPos());
        Block var4 = var3.getBlock();
        if (var4 instanceof GrowingPlantHeadBlock && !(var5 = (GrowingPlantHeadBlock)var4).isMaxAge(var3)) {
            Player var6 = var0.getPlayer();
            ItemStack var7 = var0.getItemInHand();
            if (var6 instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)var6, var2, var7);
            }
            var1.playSound((Entity)var6, var2, SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 1.0f);
            BlockState var8 = var5.getMaxAgeState(var3);
            var1.setBlockAndUpdate(var2, var8);
            var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.Context.of(var0.getPlayer(), var8));
            if (var6 != null) {
                var7.hurtAndBreak(1, (LivingEntity)var6, LivingEntity.getSlotForHand(var0.getHand()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(var0);
    }
}

