/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class SpawnEggItem
extends Item {
    private static final Map<EntityType<? extends Mob>, SpawnEggItem> BY_ID = Maps.newIdentityHashMap();
    private final EntityType<?> defaultType;

    public SpawnEggItem(EntityType<? extends Mob> entitytypes, Item.Properties item_info) {
        super(item_info);
        this.defaultType = entitytypes;
        BY_ID.put(entitytypes, this);
    }

    @Override
    public InteractionResult useOn(UseOnContext itemactioncontext) {
        Level world = itemactioncontext.getLevel();
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = itemactioncontext.getItemInHand();
        BlockPos blockposition = itemactioncontext.getClickedPos();
        Direction enumdirection = itemactioncontext.getClickedFace();
        BlockState iblockdata = world.getBlockState(blockposition);
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof Spawner) {
            Spawner spawner = (Spawner)((Object)tileentity);
            EntityType<?> entitytypes = this.getType(world.registryAccess(), itemstack);
            spawner.setEntityId(entitytypes, world.getRandom());
            world.sendBlockUpdated(blockposition, iblockdata, iblockdata, 3);
            world.gameEvent((Entity)itemactioncontext.getPlayer(), GameEvent.BLOCK_CHANGE, blockposition);
            itemstack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        BlockPos blockposition1 = iblockdata.getCollisionShape(world, blockposition).isEmpty() ? blockposition : blockposition.relative(enumdirection);
        EntityType<?> entitytypes1 = this.getType(world.registryAccess(), itemstack);
        if (entitytypes1.spawn((ServerLevel)world, itemstack, itemactioncontext.getPlayer(), blockposition1, EntitySpawnReason.SPAWN_ITEM_USE, true, !Objects.equals(blockposition, blockposition1) && enumdirection == Direction.UP) != null) {
            itemstack.shrink(1);
            world.gameEvent((Entity)itemactioncontext.getPlayer(), GameEvent.ENTITY_PLACE, blockposition);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public InteractionResult use(Level world, Player entityhuman, InteractionHand enumhand) {
        ItemStack itemstack = entityhuman.getItemInHand(enumhand);
        BlockHitResult movingobjectpositionblock = SpawnEggItem.getPlayerPOVHitResult(world, entityhuman, ClipContext.Fluid.SOURCE_ONLY);
        if (movingobjectpositionblock.getType() != HitResult.Type.BLOCK) {
            return InteractionResult.PASS;
        }
        if (world instanceof ServerLevel) {
            ServerLevel worldserver = (ServerLevel)world;
            BlockPos blockposition = movingobjectpositionblock.getBlockPos();
            if (!(world.getBlockState(blockposition).getBlock() instanceof LiquidBlock)) {
                return InteractionResult.PASS;
            }
            if (world.mayInteract(entityhuman, blockposition) && entityhuman.mayUseItemAt(blockposition, movingobjectpositionblock.getDirection(), itemstack)) {
                EntityType<?> entitytypes = this.getType(worldserver.registryAccess(), itemstack);
                Object entity = entitytypes.spawn(worldserver, itemstack, entityhuman, blockposition, EntitySpawnReason.SPAWN_ITEM_USE, false, false);
                if (entity == null) {
                    return InteractionResult.PASS;
                }
                itemstack.consume(1, entityhuman);
                entityhuman.awardStat(Stats.ITEM_USED.get(this));
                world.gameEvent((Entity)entityhuman, GameEvent.ENTITY_PLACE, ((Entity)entity).position());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public boolean spawnsEntity(HolderLookup.Provider holderlookup_a, ItemStack itemstack, EntityType<?> entitytypes) {
        return Objects.equals(this.getType(holderlookup_a, itemstack), entitytypes);
    }

    @Nullable
    public static SpawnEggItem byId(@Nullable EntityType<?> entitytypes) {
        return BY_ID.get(entitytypes);
    }

    public static Iterable<SpawnEggItem> eggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }

    public EntityType<?> getType(HolderLookup.Provider holderlookup_a, ItemStack itemstack) {
        EntityType<?> entitytypes;
        CustomData customdata = itemstack.getOrDefault(DataComponents.ENTITY_DATA, CustomData.EMPTY);
        if (!customdata.isEmpty() && (entitytypes = customdata.parseEntityType(holderlookup_a, Registries.ENTITY_TYPE)) != null) {
            return entitytypes;
        }
        return this.defaultType;
    }

    @Override
    public FeatureFlagSet requiredFeatures() {
        return this.defaultType.requiredFeatures();
    }

    public Optional<Mob> spawnOffspringFromSpawnEgg(Player entityhuman, Mob entityinsentient, EntityType<? extends Mob> entitytypes, ServerLevel worldserver, Vec3 vec3d, ItemStack itemstack) {
        if (!this.spawnsEntity(worldserver.registryAccess(), itemstack, entitytypes)) {
            return Optional.empty();
        }
        Mob entityinsentient1 = entityinsentient instanceof AgeableMob ? ((AgeableMob)entityinsentient).getBreedOffspring(worldserver, (AgeableMob)entityinsentient) : entitytypes.create(worldserver, EntitySpawnReason.SPAWN_ITEM_USE);
        if (entityinsentient1 == null) {
            return Optional.empty();
        }
        entityinsentient1.setBaby(true);
        if (!entityinsentient1.isBaby()) {
            return Optional.empty();
        }
        entityinsentient1.snapTo(vec3d.x(), vec3d.y(), vec3d.z(), 0.0f, 0.0f);
        entityinsentient1.applyComponentsFromItemStack(itemstack);
        worldserver.addFreshEntityWithPassengers(entityinsentient1, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        itemstack.consume(1, entityhuman);
        return Optional.of(entityinsentient1);
    }

    @Override
    public boolean shouldPrintOpWarning(ItemStack itemstack, @Nullable Player entityhuman) {
        CustomData customdata;
        if (entityhuman != null && entityhuman.getPermissionLevel() >= 2 && (customdata = itemstack.get(DataComponents.ENTITY_DATA)) != null) {
            EntityType<?> entitytypes = customdata.parseEntityType(entityhuman.level().registryAccess(), Registries.ENTITY_TYPE);
            return entitytypes != null && entitytypes.onlyOpCanSetNbt();
        }
        return false;
    }
}

