/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class PotionBrewing {
    public static final int BREWING_TIME_SECONDS = 20;
    public static final PotionBrewing EMPTY = new PotionBrewing(List.of(), List.of(), List.of());
    private final List<Ingredient> containers;
    private final List<Mix<Potion>> potionMixes;
    private final List<Mix<Item>> containerMixes;

    PotionBrewing(List<Ingredient> var0, List<Mix<Potion>> var1, List<Mix<Item>> var2) {
        this.containers = var0;
        this.potionMixes = var1;
        this.containerMixes = var2;
    }

    public boolean isIngredient(ItemStack var0) {
        return this.isContainerIngredient(var0) || this.isPotionIngredient(var0);
    }

    private boolean isContainer(ItemStack var0) {
        for (Ingredient var2 : this.containers) {
            if (!var2.test(var0)) continue;
            return true;
        }
        return false;
    }

    public boolean isContainerIngredient(ItemStack var0) {
        for (Mix<Item> var2 : this.containerMixes) {
            if (!var2.ingredient.test(var0)) continue;
            return true;
        }
        return false;
    }

    public boolean isPotionIngredient(ItemStack var0) {
        for (Mix<Potion> var2 : this.potionMixes) {
            if (!var2.ingredient.test(var0)) continue;
            return true;
        }
        return false;
    }

    public boolean isBrewablePotion(Holder<Potion> var0) {
        for (Mix<Potion> var2 : this.potionMixes) {
            if (!var2.to.is(var0)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMix(ItemStack var0, ItemStack var1) {
        if (!this.isContainer(var0)) {
            return false;
        }
        return this.hasContainerMix(var0, var1) || this.hasPotionMix(var0, var1);
    }

    public boolean hasContainerMix(ItemStack var0, ItemStack var1) {
        for (Mix<Item> var3 : this.containerMixes) {
            if (!var0.is(var3.from) || !var3.ingredient.test(var1)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPotionMix(ItemStack var0, ItemStack var1) {
        Optional<Holder<Potion>> var2 = var0.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).potion();
        if (var2.isEmpty()) {
            return false;
        }
        for (Mix<Potion> var4 : this.potionMixes) {
            if (!var4.from.is(var2.get()) || !var4.ingredient.test(var1)) continue;
            return true;
        }
        return false;
    }

    public ItemStack mix(ItemStack var0, ItemStack var1) {
        if (var1.isEmpty()) {
            return var1;
        }
        Optional<Holder<Potion>> var2 = var1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).potion();
        if (var2.isEmpty()) {
            return var1;
        }
        for (Mix<Item> mix : this.containerMixes) {
            if (!var1.is(mix.from) || !mix.ingredient.test(var0)) continue;
            return PotionContents.createItemStack((Item)mix.to.value(), var2.get());
        }
        for (Mix<FeatureElement> mix : this.potionMixes) {
            if (!mix.from.is(var2.get()) || !mix.ingredient.test(var0)) continue;
            return PotionContents.createItemStack(var1.getItem(), mix.to);
        }
        return var1;
    }

    public static PotionBrewing bootstrap(FeatureFlagSet var0) {
        Builder var1 = new Builder(var0);
        PotionBrewing.addVanillaMixes(var1);
        return var1.build();
    }

    public static void addVanillaMixes(Builder var0) {
        var0.addContainer(Items.POTION);
        var0.addContainer(Items.SPLASH_POTION);
        var0.addContainer(Items.LINGERING_POTION);
        var0.addContainerRecipe(Items.POTION, Items.GUNPOWDER, Items.SPLASH_POTION);
        var0.addContainerRecipe(Items.SPLASH_POTION, Items.DRAGON_BREATH, Items.LINGERING_POTION);
        var0.addMix(Potions.WATER, Items.GLOWSTONE_DUST, Potions.THICK);
        var0.addMix(Potions.WATER, Items.REDSTONE, Potions.MUNDANE);
        var0.addMix(Potions.WATER, Items.NETHER_WART, Potions.AWKWARD);
        var0.addStartMix(Items.BREEZE_ROD, Potions.WIND_CHARGED);
        var0.addStartMix(Items.SLIME_BLOCK, Potions.OOZING);
        var0.addStartMix(Items.STONE, Potions.INFESTED);
        var0.addStartMix(Items.COBWEB, Potions.WEAVING);
        var0.addMix(Potions.AWKWARD, Items.GOLDEN_CARROT, Potions.NIGHT_VISION);
        var0.addMix(Potions.NIGHT_VISION, Items.REDSTONE, Potions.LONG_NIGHT_VISION);
        var0.addMix(Potions.NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, Potions.INVISIBILITY);
        var0.addMix(Potions.LONG_NIGHT_VISION, Items.FERMENTED_SPIDER_EYE, Potions.LONG_INVISIBILITY);
        var0.addMix(Potions.INVISIBILITY, Items.REDSTONE, Potions.LONG_INVISIBILITY);
        var0.addStartMix(Items.MAGMA_CREAM, Potions.FIRE_RESISTANCE);
        var0.addMix(Potions.FIRE_RESISTANCE, Items.REDSTONE, Potions.LONG_FIRE_RESISTANCE);
        var0.addStartMix(Items.RABBIT_FOOT, Potions.LEAPING);
        var0.addMix(Potions.LEAPING, Items.REDSTONE, Potions.LONG_LEAPING);
        var0.addMix(Potions.LEAPING, Items.GLOWSTONE_DUST, Potions.STRONG_LEAPING);
        var0.addMix(Potions.LEAPING, Items.FERMENTED_SPIDER_EYE, Potions.SLOWNESS);
        var0.addMix(Potions.LONG_LEAPING, Items.FERMENTED_SPIDER_EYE, Potions.LONG_SLOWNESS);
        var0.addMix(Potions.SLOWNESS, Items.REDSTONE, Potions.LONG_SLOWNESS);
        var0.addMix(Potions.SLOWNESS, Items.GLOWSTONE_DUST, Potions.STRONG_SLOWNESS);
        var0.addMix(Potions.AWKWARD, Items.TURTLE_HELMET, Potions.TURTLE_MASTER);
        var0.addMix(Potions.TURTLE_MASTER, Items.REDSTONE, Potions.LONG_TURTLE_MASTER);
        var0.addMix(Potions.TURTLE_MASTER, Items.GLOWSTONE_DUST, Potions.STRONG_TURTLE_MASTER);
        var0.addMix(Potions.SWIFTNESS, Items.FERMENTED_SPIDER_EYE, Potions.SLOWNESS);
        var0.addMix(Potions.LONG_SWIFTNESS, Items.FERMENTED_SPIDER_EYE, Potions.LONG_SLOWNESS);
        var0.addStartMix(Items.SUGAR, Potions.SWIFTNESS);
        var0.addMix(Potions.SWIFTNESS, Items.REDSTONE, Potions.LONG_SWIFTNESS);
        var0.addMix(Potions.SWIFTNESS, Items.GLOWSTONE_DUST, Potions.STRONG_SWIFTNESS);
        var0.addMix(Potions.AWKWARD, Items.PUFFERFISH, Potions.WATER_BREATHING);
        var0.addMix(Potions.WATER_BREATHING, Items.REDSTONE, Potions.LONG_WATER_BREATHING);
        var0.addStartMix(Items.GLISTERING_MELON_SLICE, Potions.HEALING);
        var0.addMix(Potions.HEALING, Items.GLOWSTONE_DUST, Potions.STRONG_HEALING);
        var0.addMix(Potions.HEALING, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        var0.addMix(Potions.STRONG_HEALING, Items.FERMENTED_SPIDER_EYE, Potions.STRONG_HARMING);
        var0.addMix(Potions.HARMING, Items.GLOWSTONE_DUST, Potions.STRONG_HARMING);
        var0.addMix(Potions.POISON, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        var0.addMix(Potions.LONG_POISON, Items.FERMENTED_SPIDER_EYE, Potions.HARMING);
        var0.addMix(Potions.STRONG_POISON, Items.FERMENTED_SPIDER_EYE, Potions.STRONG_HARMING);
        var0.addStartMix(Items.SPIDER_EYE, Potions.POISON);
        var0.addMix(Potions.POISON, Items.REDSTONE, Potions.LONG_POISON);
        var0.addMix(Potions.POISON, Items.GLOWSTONE_DUST, Potions.STRONG_POISON);
        var0.addStartMix(Items.GHAST_TEAR, Potions.REGENERATION);
        var0.addMix(Potions.REGENERATION, Items.REDSTONE, Potions.LONG_REGENERATION);
        var0.addMix(Potions.REGENERATION, Items.GLOWSTONE_DUST, Potions.STRONG_REGENERATION);
        var0.addStartMix(Items.BLAZE_POWDER, Potions.STRENGTH);
        var0.addMix(Potions.STRENGTH, Items.REDSTONE, Potions.LONG_STRENGTH);
        var0.addMix(Potions.STRENGTH, Items.GLOWSTONE_DUST, Potions.STRONG_STRENGTH);
        var0.addMix(Potions.WATER, Items.FERMENTED_SPIDER_EYE, Potions.WEAKNESS);
        var0.addMix(Potions.WEAKNESS, Items.REDSTONE, Potions.LONG_WEAKNESS);
        var0.addMix(Potions.AWKWARD, Items.PHANTOM_MEMBRANE, Potions.SLOW_FALLING);
        var0.addMix(Potions.SLOW_FALLING, Items.REDSTONE, Potions.LONG_SLOW_FALLING);
    }

    static final class Mix<T>
    extends Record {
        final Holder<T> from;
        final Ingredient ingredient;
        final Holder<T> to;

        Mix(Holder<T> var0, Ingredient var1, Holder<T> var2) {
            this.from = var0;
            this.ingredient = var1;
            this.to = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Mix.class, "from;ingredient;to", "from", "ingredient", "to"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Mix.class, "from;ingredient;to", "from", "ingredient", "to"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Mix.class, "from;ingredient;to", "from", "ingredient", "to"}, this, var0);
        }

        public Holder<T> from() {
            return this.from;
        }

        public Ingredient ingredient() {
            return this.ingredient;
        }

        public Holder<T> to() {
            return this.to;
        }
    }

    public static class Builder {
        private final List<Ingredient> containers = new ArrayList<Ingredient>();
        private final List<Mix<Potion>> potionMixes = new ArrayList<Mix<Potion>>();
        private final List<Mix<Item>> containerMixes = new ArrayList<Mix<Item>>();
        private final FeatureFlagSet enabledFeatures;

        public Builder(FeatureFlagSet var0) {
            this.enabledFeatures = var0;
        }

        private static void expectPotion(Item var0) {
            if (!(var0 instanceof PotionItem)) {
                throw new IllegalArgumentException("Expected a potion, got: " + String.valueOf(BuiltInRegistries.ITEM.getKey(var0)));
            }
        }

        public void addContainerRecipe(Item var0, Item var1, Item var2) {
            if (!(var0.isEnabled(this.enabledFeatures) && var1.isEnabled(this.enabledFeatures) && var2.isEnabled(this.enabledFeatures))) {
                return;
            }
            Builder.expectPotion(var0);
            Builder.expectPotion(var2);
            this.containerMixes.add(new Mix<Item>(var0.builtInRegistryHolder(), Ingredient.of((ItemLike)var1), var2.builtInRegistryHolder()));
        }

        public void addContainer(Item var0) {
            if (!var0.isEnabled(this.enabledFeatures)) {
                return;
            }
            Builder.expectPotion(var0);
            this.containers.add(Ingredient.of((ItemLike)var0));
        }

        public void addMix(Holder<Potion> var0, Item var1, Holder<Potion> var2) {
            if (var0.value().isEnabled(this.enabledFeatures) && var1.isEnabled(this.enabledFeatures) && var2.value().isEnabled(this.enabledFeatures)) {
                this.potionMixes.add(new Mix<Potion>(var0, Ingredient.of((ItemLike)var1), var2));
            }
        }

        public void addStartMix(Item var0, Holder<Potion> var1) {
            if (var1.value().isEnabled(this.enabledFeatures)) {
                this.addMix(Potions.WATER, var0, Potions.MUNDANE);
                this.addMix(Potions.AWKWARD, var0, var1);
            }
        }

        public PotionBrewing build() {
            return new PotionBrewing(List.copyOf(this.containers), List.copyOf(this.potionMixes), List.copyOf(this.containerMixes));
        }
    }
}

