/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.alchemy;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ARGB;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.Level;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public record PotionContents(Optional<Holder<Potion>> potion, Optional<Integer> customColor, List<MobEffectInstance> customEffects, Optional<String> customName) implements ConsumableListener,
TooltipProvider
{
    private final List<MobEffectInstance> customEffects;
    public static final PotionContents EMPTY = new PotionContents(Optional.empty(), Optional.empty(), List.of(), Optional.empty());
    private static final Component NO_EFFECT = Component.translatable("effect.none").withStyle(ChatFormatting.GRAY);
    public static final int BASE_POTION_COLOR = -13083194;
    private static final Codec<PotionContents> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Potion.CODEC.optionalFieldOf("potion").forGetter(PotionContents::potion), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(PotionContents::customColor), (App)MobEffectInstance.CODEC.listOf().optionalFieldOf("custom_effects", List.of()).forGetter(PotionContents::customEffects), (App)Codec.STRING.optionalFieldOf("custom_name").forGetter(PotionContents::customName)).apply((Applicative)instance, PotionContents::new));
    public static final Codec<PotionContents> CODEC = Codec.withAlternative(FULL_CODEC, Potion.CODEC, PotionContents::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotionContents> STREAM_CODEC = StreamCodec.composite(Potion.STREAM_CODEC.apply(ByteBufCodecs::optional), PotionContents::potion, ByteBufCodecs.INT.apply(ByteBufCodecs::optional), PotionContents::customColor, MobEffectInstance.STREAM_CODEC.apply(ByteBufCodecs.list()), PotionContents::customEffects, ByteBufCodecs.STRING_UTF8.apply(ByteBufCodecs::optional), PotionContents::customName, PotionContents::new);

    public PotionContents(Holder<Potion> holder) {
        this(Optional.of(holder), Optional.empty(), List.of(), Optional.empty());
    }

    public static ItemStack createItemStack(Item item, Holder<Potion> holder) {
        ItemStack itemstack = new ItemStack(item);
        itemstack.set(DataComponents.POTION_CONTENTS, new PotionContents(holder));
        return itemstack;
    }

    public boolean is(Holder<Potion> holder) {
        return this.potion.isPresent() && this.potion.get().is(holder) && this.customEffects.isEmpty();
    }

    public Iterable<MobEffectInstance> getAllEffects() {
        return this.potion.isEmpty() ? this.customEffects : (this.customEffects.isEmpty() ? this.potion.get().value().getEffects() : Iterables.concat(this.potion.get().value().getEffects(), this.customEffects));
    }

    public void forEachEffect(Consumer<MobEffectInstance> consumer, float f) {
        if (this.potion.isPresent()) {
            for (MobEffectInstance mobeffect : this.potion.get().value().getEffects()) {
                consumer.accept(mobeffect.withScaledDuration(f));
            }
        }
        for (MobEffectInstance mobeffect1 : this.customEffects) {
            consumer.accept(mobeffect1.withScaledDuration(f));
        }
    }

    public PotionContents withPotion(Holder<Potion> holder) {
        return new PotionContents(Optional.of(holder), this.customColor, this.customEffects, this.customName);
    }

    public PotionContents withEffectAdded(MobEffectInstance mobeffect) {
        return new PotionContents(this.potion, this.customColor, Util.copyAndAdd(this.customEffects, mobeffect), this.customName);
    }

    public int getColor() {
        return this.getColorOr(-13083194);
    }

    public int getColorOr(int i) {
        return this.customColor.isPresent() ? this.customColor.get().intValue() : PotionContents.getColorOptional(this.getAllEffects()).orElse(i);
    }

    public Component getName(String s) {
        String s1 = this.customName.or(() -> this.potion.map(holder -> ((Potion)holder.value()).name())).orElse("empty");
        return Component.translatable(s + s1);
    }

    public static OptionalInt getColorOptional(Iterable<MobEffectInstance> iterable) {
        int i = 0;
        int j = 0;
        int k = 0;
        int l = 0;
        for (MobEffectInstance mobeffect : iterable) {
            if (!mobeffect.isVisible()) continue;
            int i1 = mobeffect.getEffect().value().getColor();
            int j1 = mobeffect.getAmplifier() + 1;
            i += j1 * ARGB.red(i1);
            j += j1 * ARGB.green(i1);
            k += j1 * ARGB.blue(i1);
            l += j1;
        }
        if (l == 0) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(ARGB.color(i / l, j / l, k / l));
    }

    public boolean hasEffects() {
        return !this.customEffects.isEmpty() ? true : this.potion.isPresent() && !this.potion.get().value().getEffects().isEmpty();
    }

    public List<MobEffectInstance> customEffects() {
        return Lists.transform(this.customEffects, MobEffectInstance::new);
    }

    public void applyToLivingEntity(LivingEntity entityliving, float f) {
        Level world = entityliving.level();
        if (world instanceof ServerLevel) {
            Player entityhuman1;
            ServerLevel worldserver = (ServerLevel)world;
            Player entityhuman = entityliving instanceof Player ? (entityhuman1 = (Player)entityliving) : null;
            Player entityhuman2 = entityhuman;
            this.forEachEffect(mobeffect -> {
                if (mobeffect.getEffect().value().isInstantenous()) {
                    mobeffect.getEffect().value().applyInstantenousEffect(worldserver, entityhuman2, entityhuman2, entityliving, mobeffect.getAmplifier(), 1.0);
                } else {
                    entityliving.addEffect((MobEffectInstance)mobeffect, EntityPotionEffectEvent.Cause.POTION_DRINK);
                }
            }, f);
        }
    }

    public static void addPotionTooltip(Iterable<MobEffectInstance> iterable, Consumer<Component> consumer, float f, float f1) {
        ArrayList list = Lists.newArrayList();
        boolean flag = true;
        for (MobEffectInstance mobeffect : iterable) {
            flag = false;
            Holder<MobEffect> holder = mobeffect.getEffect();
            int i = mobeffect.getAmplifier();
            holder.value().createModifiers(i, (holder1, attributemodifier) -> list.add(new Pair(holder1, attributemodifier)));
            MutableComponent ichatmutablecomponent = PotionContents.getPotionDescription(holder, i);
            if (!mobeffect.endsWithin(20)) {
                ichatmutablecomponent = Component.translatable("potion.withDuration", ichatmutablecomponent, MobEffectUtil.formatDuration(mobeffect, f, f1));
            }
            consumer.accept(ichatmutablecomponent.withStyle(holder.value().getCategory().getTooltipFormatting()));
        }
        if (flag) {
            consumer.accept(NO_EFFECT);
        }
        if (!list.isEmpty()) {
            consumer.accept(CommonComponents.EMPTY);
            consumer.accept(Component.translatable("potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list) {
                AttributeModifier attributemodifier2 = (AttributeModifier)pair.getSecond();
                double d0 = attributemodifier2.amount();
                double d1 = attributemodifier2.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && attributemodifier2.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? attributemodifier2.amount() : attributemodifier2.amount() * 100.0;
                if (d0 > 0.0) {
                    consumer.accept(Component.translatable("attribute.modifier.plus." + attributemodifier2.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1), Component.translatable(((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                consumer.accept(Component.translatable("attribute.modifier.take." + attributemodifier2.operation().id(), ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(d1 *= -1.0), Component.translatable(((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())).withStyle(ChatFormatting.RED));
            }
        }
    }

    public static MutableComponent getPotionDescription(Holder<MobEffect> holder, int i) {
        MutableComponent ichatmutablecomponent = Component.translatable(holder.value().getDescriptionId());
        return i > 0 ? Component.translatable("potion.withAmplifier", ichatmutablecomponent, Component.translatable("potion.potency." + i)) : ichatmutablecomponent;
    }

    @Override
    public void onConsume(Level world, LivingEntity entityliving, ItemStack itemstack, Consumable consumable) {
        this.applyToLivingEntity(entityliving, itemstack.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue());
    }

    @Override
    public void addToTooltip(Item.TooltipContext item_b, Consumer<Component> consumer, TooltipFlag tooltipflag, DataComponentGetter datacomponentgetter) {
        PotionContents.addPotionTooltip(this.getAllEffects(), consumer, datacomponentgetter.getOrDefault(DataComponents.POTION_DURATION_SCALE, Float.valueOf(1.0f)).floatValue(), item_b.tickRate());
    }
}

