/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public record BlockItemStateProperties(Map<String, String> properties) implements TooltipProvider
{
    public static final BlockItemStateProperties EMPTY = new BlockItemStateProperties(Map.of());
    public static final Codec<BlockItemStateProperties> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).xmap(BlockItemStateProperties::new, BlockItemStateProperties::properties);
    private static final StreamCodec<ByteBuf, Map<String, String>> PROPERTIES_STREAM_CODEC = ByteBufCodecs.map(Object2ObjectOpenHashMap::new, ByteBufCodecs.STRING_UTF8, ByteBufCodecs.STRING_UTF8);
    public static final StreamCodec<ByteBuf, BlockItemStateProperties> STREAM_CODEC = PROPERTIES_STREAM_CODEC.map(BlockItemStateProperties::new, BlockItemStateProperties::properties);

    public <T extends Comparable<T>> BlockItemStateProperties with(Property<T> var0, T var1) {
        return new BlockItemStateProperties(Util.copyAndPut(this.properties, var0.getName(), var0.getName(var1)));
    }

    public <T extends Comparable<T>> BlockItemStateProperties with(Property<T> var0, BlockState var1) {
        return this.with(var0, var1.getValue(var0));
    }

    @Nullable
    public <T extends Comparable<T>> T get(Property<T> var0) {
        String var1 = this.properties.get(var0.getName());
        if (var1 == null) {
            return null;
        }
        return (T)((Comparable)var0.getValue(var1).orElse(null));
    }

    public BlockState apply(BlockState var0) {
        StateDefinition<Block, BlockState> var1 = var0.getBlock().getStateDefinition();
        for (Map.Entry<String, String> var3 : this.properties.entrySet()) {
            Property<?> var4 = var1.getProperty(var3.getKey());
            if (var4 == null) continue;
            var0 = BlockItemStateProperties.updateState(var0, var4, var3.getValue());
        }
        return var0;
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState var0, Property<T> var1, String var22) {
        return var1.getValue(var22).map(var2 -> (BlockState)var0.setValue(var1, var2)).orElse(var0);
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public void addToTooltip(Item.TooltipContext var0, Consumer<Component> var1, TooltipFlag var2, DataComponentGetter var3) {
        Integer var4 = this.get(BeehiveBlock.HONEY_LEVEL);
        if (var4 != null) {
            var1.accept(Component.translatable("container.beehive.honey", var4, 5).withStyle(ChatFormatting.GRAY));
        }
    }
}

