/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.item.consume_effects.ConsumeEffect;
import net.minecraft.world.item.consume_effects.PlaySoundConsumeEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public record Consumable(float consumeSeconds, ItemUseAnimation animation, Holder<SoundEvent> sound, boolean hasConsumeParticles, List<ConsumeEffect> onConsumeEffects) {
    public static final float DEFAULT_CONSUME_SECONDS = 1.6f;
    private static final int CONSUME_EFFECTS_INTERVAL = 4;
    private static final float CONSUME_EFFECTS_START_FRACTION = 0.21875f;
    public static final Codec<Consumable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_FLOAT.optionalFieldOf("consume_seconds", (Object)Float.valueOf(1.6f)).forGetter(Consumable::consumeSeconds), (App)ItemUseAnimation.CODEC.optionalFieldOf("animation", (Object)ItemUseAnimation.EAT).forGetter(Consumable::animation), (App)SoundEvent.CODEC.optionalFieldOf("sound", SoundEvents.GENERIC_EAT).forGetter(Consumable::sound), (App)Codec.BOOL.optionalFieldOf("has_consume_particles", (Object)true).forGetter(Consumable::hasConsumeParticles), (App)ConsumeEffect.CODEC.listOf().optionalFieldOf("on_consume_effects", List.of()).forGetter(Consumable::onConsumeEffects)).apply((Applicative)instance, Consumable::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Consumable> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.FLOAT, Consumable::consumeSeconds, ItemUseAnimation.STREAM_CODEC, Consumable::animation, SoundEvent.STREAM_CODEC, Consumable::sound, ByteBufCodecs.BOOL, Consumable::hasConsumeParticles, ConsumeEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), Consumable::onConsumeEffects, Consumable::new);

    public InteractionResult startConsuming(LivingEntity entityliving, ItemStack itemstack, InteractionHand enumhand) {
        boolean flag;
        if (!this.canConsume(entityliving, itemstack)) {
            return InteractionResult.FAIL;
        }
        boolean bl = flag = this.consumeTicks() > 0;
        if (flag) {
            entityliving.startUsingItem(enumhand);
            return InteractionResult.CONSUME;
        }
        ItemStack itemstack1 = this.onConsume(entityliving.level(), entityliving, itemstack);
        return InteractionResult.CONSUME.heldItemTransformedTo(itemstack1);
    }

    public ItemStack onConsume(Level world, LivingEntity entityliving, ItemStack itemstack) {
        RandomSource randomsource = entityliving.getRandom();
        this.emitParticlesAndSounds(randomsource, entityliving, itemstack, 16);
        if (entityliving instanceof ServerPlayer) {
            ServerPlayer entityplayer = (ServerPlayer)entityliving;
            entityplayer.awardStat(Stats.ITEM_USED.get(itemstack.getItem()));
            CriteriaTriggers.CONSUME_ITEM.trigger(entityplayer, itemstack);
        }
        itemstack.getAllOfType(ConsumableListener.class).forEach(consumablelistener -> consumablelistener.onConsume(world, entityliving, itemstack, this));
        if (!world.isClientSide) {
            EntityPotionEffectEvent.Cause cause = itemstack.is(Items.MILK_BUCKET) ? EntityPotionEffectEvent.Cause.MILK : (itemstack.is(Items.POTION) ? EntityPotionEffectEvent.Cause.POTION_DRINK : EntityPotionEffectEvent.Cause.FOOD);
            this.onConsumeEffects.forEach(consumeeffect -> consumeeffect.apply(world, itemstack, entityliving, cause));
        }
        entityliving.gameEvent(this.animation == ItemUseAnimation.DRINK ? GameEvent.DRINK : GameEvent.EAT);
        itemstack.consume(1, entityliving);
        return itemstack;
    }

    public void cancelUsingItem(ServerPlayer entityplayer, ItemStack itemstack) {
        itemstack.getAllOfType(ConsumableListener.class).forEach(consumablelistener -> consumablelistener.cancelUsingItem(entityplayer, itemstack));
        entityplayer.server.getPlayerList().sendActivePlayerEffects(entityplayer);
    }

    public boolean canConsume(LivingEntity entityliving, ItemStack itemstack) {
        FoodProperties foodinfo = itemstack.get(DataComponents.FOOD);
        if (foodinfo != null && entityliving instanceof Player) {
            Player entityhuman = (Player)entityliving;
            return entityhuman.canEat(foodinfo.canAlwaysEat());
        }
        return true;
    }

    public int consumeTicks() {
        return (int)(this.consumeSeconds * 20.0f);
    }

    public void emitParticlesAndSounds(RandomSource randomsource, LivingEntity entityliving, ItemStack itemstack, int i) {
        SoundEvent soundeffect;
        float f5;
        float f = randomsource.nextBoolean() ? 0.5f : 1.0f;
        float f1 = randomsource.triangle(1.0f, 0.2f);
        float f2 = 0.5f;
        float f3 = Mth.randomBetween(randomsource, 0.9f, 1.0f);
        float f4 = this.animation == ItemUseAnimation.DRINK ? 0.5f : f;
        float f6 = f5 = this.animation == ItemUseAnimation.DRINK ? f3 : f1;
        if (this.hasConsumeParticles) {
            entityliving.spawnItemParticles(itemstack, i);
        }
        if (entityliving instanceof OverrideConsumeSound) {
            OverrideConsumeSound consumable_b = (OverrideConsumeSound)((Object)entityliving);
            soundeffect = consumable_b.getConsumeSound(itemstack);
        } else {
            soundeffect = this.sound.value();
        }
        SoundEvent soundeffect1 = soundeffect;
        entityliving.playSound(soundeffect1, f4, f5);
    }

    public boolean shouldEmitParticlesAndSounds(int i) {
        int k;
        int j = this.consumeTicks() - i;
        boolean flag = j > (k = (int)((float)this.consumeTicks() * 0.21875f));
        return flag && i % 4 == 0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static interface OverrideConsumeSound {
        public SoundEvent getConsumeSound(ItemStack var1);
    }

    public static class Builder {
        private float consumeSeconds = 1.6f;
        private ItemUseAnimation animation = ItemUseAnimation.EAT;
        private Holder<SoundEvent> sound = SoundEvents.GENERIC_EAT;
        private boolean hasConsumeParticles = true;
        private final List<ConsumeEffect> onConsumeEffects = new ArrayList<ConsumeEffect>();

        Builder() {
        }

        public Builder consumeSeconds(float f) {
            this.consumeSeconds = f;
            return this;
        }

        public Builder animation(ItemUseAnimation itemuseanimation) {
            this.animation = itemuseanimation;
            return this;
        }

        public Builder sound(Holder<SoundEvent> holder) {
            this.sound = holder;
            return this;
        }

        public Builder soundAfterConsume(Holder<SoundEvent> holder) {
            return this.onConsume(new PlaySoundConsumeEffect(holder));
        }

        public Builder hasConsumeParticles(boolean flag) {
            this.hasConsumeParticles = flag;
            return this;
        }

        public Builder onConsume(ConsumeEffect consumeeffect) {
            this.onConsumeEffects.add(consumeeffect);
            return this;
        }

        public Consumable build() {
            return new Consumable(this.consumeSeconds, this.animation, this.sound, this.hasConsumeParticles, this.onConsumeEffects);
        }
    }
}

