/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class RecipeCache {
    private final Entry[] entries;
    private WeakReference<RecipeManager> cachedRecipeManager = new WeakReference<Object>(null);

    public RecipeCache(int var0) {
        this.entries = new Entry[var0];
    }

    public Optional<RecipeHolder<CraftingRecipe>> get(ServerLevel var0, CraftingInput var1) {
        if (var1.isEmpty()) {
            return Optional.empty();
        }
        this.validateRecipeManager(var0);
        for (int var2 = 0; var2 < this.entries.length; ++var2) {
            Entry var3 = this.entries[var2];
            if (var3 == null || !var3.matches(var1)) continue;
            this.moveEntryToFront(var2);
            return Optional.ofNullable(var3.value());
        }
        return this.compute(var1, var0);
    }

    private void validateRecipeManager(ServerLevel var0) {
        RecipeManager var1 = var0.recipeAccess();
        if (var1 != this.cachedRecipeManager.get()) {
            this.cachedRecipeManager = new WeakReference<RecipeManager>(var1);
            Arrays.fill(this.entries, null);
        }
    }

    private Optional<RecipeHolder<CraftingRecipe>> compute(CraftingInput var0, ServerLevel var1) {
        Optional<RecipeHolder<CraftingRecipe>> var2 = var1.recipeAccess().getRecipeFor(RecipeType.CRAFTING, var0, var1);
        this.insert(var0, var2.orElse(null));
        return var2;
    }

    private void moveEntryToFront(int var0) {
        if (var0 > 0) {
            Entry var1 = this.entries[var0];
            System.arraycopy(this.entries, 0, this.entries, 1, var0);
            this.entries[0] = var1;
        }
    }

    private void insert(CraftingInput var0, @Nullable RecipeHolder<CraftingRecipe> var1) {
        NonNullList<ItemStack> var2 = NonNullList.withSize(var0.size(), ItemStack.EMPTY);
        for (int var3 = 0; var3 < var0.size(); ++var3) {
            var2.set(var3, var0.getItem(var3).copyWithCount(1));
        }
        System.arraycopy(this.entries, 0, this.entries, 1, this.entries.length - 1);
        this.entries[0] = new Entry(var2, var0.width(), var0.height(), var1);
    }

    record Entry(NonNullList<ItemStack> key, int width, int height, @Nullable RecipeHolder<CraftingRecipe> value) {
        public boolean matches(CraftingInput var0) {
            if (this.width != var0.width() || this.height != var0.height()) {
                return false;
            }
            for (int var1 = 0; var1 < this.key.size(); ++var1) {
                if (ItemStack.isSameItemSameComponents(this.key.get(var1), var0.getItem(var1))) continue;
                return false;
            }
            return true;
        }
    }
}

