/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;

public interface LevelBasedValue {
    public static final Codec<LevelBasedValue> DISPATCH_CODEC = BuiltInRegistries.ENCHANTMENT_LEVEL_BASED_VALUE_TYPE.byNameCodec().dispatch(LevelBasedValue::codec, var0 -> var0);
    public static final Codec<LevelBasedValue> CODEC = Codec.either(Constant.CODEC, DISPATCH_CODEC).xmap(var02 -> (LevelBasedValue)var02.map(var0 -> var0, var0 -> var0), var0 -> {
        Either either;
        if (var0 instanceof Constant) {
            Constant var1 = (Constant)var0;
            either = Either.left((Object)var1);
        } else {
            either = Either.right((Object)var0);
        }
        return either;
    });

    public static MapCodec<? extends LevelBasedValue> bootstrap(Registry<MapCodec<? extends LevelBasedValue>> var0) {
        Registry.register(var0, "clamped", Clamped.CODEC);
        Registry.register(var0, "fraction", Fraction.CODEC);
        Registry.register(var0, "levels_squared", LevelsSquared.CODEC);
        Registry.register(var0, "linear", Linear.CODEC);
        return Registry.register(var0, "lookup", Lookup.CODEC);
    }

    public static Constant constant(float var0) {
        return new Constant(var0);
    }

    public static Linear perLevel(float var0, float var1) {
        return new Linear(var0, var1);
    }

    public static Linear perLevel(float var0) {
        return LevelBasedValue.perLevel(var0, var0);
    }

    public static Lookup lookup(List<Float> var0, LevelBasedValue var1) {
        return new Lookup(var0, var1);
    }

    public float calculate(int var1);

    public MapCodec<? extends LevelBasedValue> codec();

    public record Clamped(LevelBasedValue value, float min, float max) implements LevelBasedValue
    {
        public static final MapCodec<Clamped> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CODEC.fieldOf("value").forGetter(Clamped::value), (App)Codec.FLOAT.fieldOf("min").forGetter(Clamped::min), (App)Codec.FLOAT.fieldOf("max").forGetter(Clamped::max)).apply((Applicative)var0, Clamped::new)).validate(var0 -> {
            if (var0.max <= var0.min) {
                return DataResult.error(() -> "Max must be larger than min, min: " + var0.min + ", max: " + var0.max);
            }
            return DataResult.success((Object)var0);
        });

        @Override
        public float calculate(int var0) {
            return Mth.clamp(this.value.calculate(var0), this.min, this.max);
        }

        public MapCodec<Clamped> codec() {
            return CODEC;
        }
    }

    public record Fraction(LevelBasedValue numerator, LevelBasedValue denominator) implements LevelBasedValue
    {
        public static final MapCodec<Fraction> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)CODEC.fieldOf("numerator").forGetter(Fraction::numerator), (App)CODEC.fieldOf("denominator").forGetter(Fraction::denominator)).apply((Applicative)var0, Fraction::new));

        @Override
        public float calculate(int var0) {
            float var1 = this.denominator.calculate(var0);
            if (var1 == 0.0f) {
                return 0.0f;
            }
            return this.numerator.calculate(var0) / var1;
        }

        public MapCodec<Fraction> codec() {
            return CODEC;
        }
    }

    public record LevelsSquared(float added) implements LevelBasedValue
    {
        public static final MapCodec<LevelsSquared> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.fieldOf("added").forGetter(LevelsSquared::added)).apply((Applicative)var0, LevelsSquared::new));

        @Override
        public float calculate(int var0) {
            return (float)Mth.square(var0) + this.added;
        }

        public MapCodec<LevelsSquared> codec() {
            return CODEC;
        }
    }

    public record Linear(float base, float perLevelAboveFirst) implements LevelBasedValue
    {
        public static final MapCodec<Linear> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.fieldOf("base").forGetter(Linear::base), (App)Codec.FLOAT.fieldOf("per_level_above_first").forGetter(Linear::perLevelAboveFirst)).apply((Applicative)var0, Linear::new));

        @Override
        public float calculate(int var0) {
            return this.base + this.perLevelAboveFirst * (float)(var0 - 1);
        }

        public MapCodec<Linear> codec() {
            return CODEC;
        }
    }

    public record Lookup(List<Float> values, LevelBasedValue fallback) implements LevelBasedValue
    {
        public static final MapCodec<Lookup> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.listOf().fieldOf("values").forGetter(Lookup::values), (App)CODEC.fieldOf("fallback").forGetter(Lookup::fallback)).apply((Applicative)var0, Lookup::new));

        @Override
        public float calculate(int var0) {
            return var0 <= this.values.size() ? this.values.get(var0 - 1).floatValue() : this.fallback.calculate(var0);
        }

        public MapCodec<Lookup> codec() {
            return CODEC;
        }
    }

    public record Constant(float value) implements LevelBasedValue
    {
        public static final Codec<Constant> CODEC = Codec.FLOAT.xmap(Constant::new, Constant::value);
        public static final MapCodec<Constant> TYPED_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.fieldOf("value").forGetter(Constant::value)).apply((Applicative)var0, Constant::new));

        @Override
        public float calculate(int var0) {
            return this.value;
        }

        public MapCodec<Constant> codec() {
            return TYPED_CODEC;
        }
    }
}

