/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment.effects;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.phys.Vec3;

public record SpawnParticlesEffect(ParticleOptions particle, PositionSource horizontalPosition, PositionSource verticalPosition, VelocitySource horizontalVelocity, VelocitySource verticalVelocity, FloatProvider speed) implements EnchantmentEntityEffect
{
    public static final MapCodec<SpawnParticlesEffect> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ParticleTypes.CODEC.fieldOf("particle").forGetter(SpawnParticlesEffect::particle), (App)PositionSource.CODEC.fieldOf("horizontal_position").forGetter(SpawnParticlesEffect::horizontalPosition), (App)PositionSource.CODEC.fieldOf("vertical_position").forGetter(SpawnParticlesEffect::verticalPosition), (App)VelocitySource.CODEC.fieldOf("horizontal_velocity").forGetter(SpawnParticlesEffect::horizontalVelocity), (App)VelocitySource.CODEC.fieldOf("vertical_velocity").forGetter(SpawnParticlesEffect::verticalVelocity), (App)FloatProvider.CODEC.optionalFieldOf("speed", (Object)ConstantFloat.ZERO).forGetter(SpawnParticlesEffect::speed)).apply((Applicative)var0, SpawnParticlesEffect::new));

    public static PositionSource offsetFromEntityPosition(float var0) {
        return new PositionSource(PositionSourceType.ENTITY_POSITION, var0, 1.0f);
    }

    public static PositionSource inBoundingBox() {
        return new PositionSource(PositionSourceType.BOUNDING_BOX, 0.0f, 1.0f);
    }

    public static VelocitySource movementScaled(float var0) {
        return new VelocitySource(var0, ConstantFloat.ZERO);
    }

    public static VelocitySource fixedVelocity(FloatProvider var0) {
        return new VelocitySource(0.0f, var0);
    }

    @Override
    public void apply(ServerLevel var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3 var4) {
        RandomSource var5 = var3.getRandom();
        Vec3 var6 = var3.getKnownMovement();
        float var7 = var3.getBbWidth();
        float var8 = var3.getBbHeight();
        var0.sendParticles(this.particle, this.horizontalPosition.getCoordinate(var4.x(), var4.x(), var7, var5), this.verticalPosition.getCoordinate(var4.y(), var4.y() + (double)(var8 / 2.0f), var8, var5), this.horizontalPosition.getCoordinate(var4.z(), var4.z(), var7, var5), 0, this.horizontalVelocity.getVelocity(var6.x(), var5), this.verticalVelocity.getVelocity(var6.y(), var5), this.horizontalVelocity.getVelocity(var6.z(), var5), this.speed.sample(var5));
    }

    public MapCodec<SpawnParticlesEffect> codec() {
        return CODEC;
    }

    public record PositionSource(PositionSourceType type, float offset, float scale) {
        public static final MapCodec<PositionSource> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)PositionSourceType.CODEC.fieldOf("type").forGetter(PositionSource::type), (App)Codec.FLOAT.optionalFieldOf("offset", (Object)Float.valueOf(0.0f)).forGetter(PositionSource::offset), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(PositionSource::scale)).apply((Applicative)var0, PositionSource::new)).validate(var0 -> {
            if (var0.type() == PositionSourceType.ENTITY_POSITION && var0.scale() != 1.0f) {
                return DataResult.error(() -> "Cannot scale an entity position coordinate source");
            }
            return DataResult.success((Object)var0);
        });

        public double getCoordinate(double var0, double var2, float var4, RandomSource var5) {
            return this.type.getCoordinate(var0, var2, var4 * this.scale, var5) + (double)this.offset;
        }
    }

    public record VelocitySource(float movementScale, FloatProvider base) {
        public static final MapCodec<VelocitySource> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.FLOAT.optionalFieldOf("movement_scale", (Object)Float.valueOf(0.0f)).forGetter(VelocitySource::movementScale), (App)FloatProvider.CODEC.optionalFieldOf("base", (Object)ConstantFloat.ZERO).forGetter(VelocitySource::base)).apply((Applicative)var0, VelocitySource::new));

        public double getVelocity(double var0, RandomSource var2) {
            return var0 * (double)this.movementScale + (double)this.base.sample(var2);
        }
    }

    public static enum PositionSourceType implements StringRepresentable
    {
        ENTITY_POSITION("entity_position", (var0, var2, var4, var5) -> var0),
        BOUNDING_BOX("in_bounding_box", (var0, var2, var4, var5) -> var2 + (var5.nextDouble() - 0.5) * (double)var4);

        public static final Codec<PositionSourceType> CODEC;
        private final String id;
        private final CoordinateSource source;

        private PositionSourceType(String var2, CoordinateSource var3) {
            this.id = var2;
            this.source = var3;
        }

        public double getCoordinate(double var0, double var2, float var4, RandomSource var5) {
            return this.source.getCoordinate(var0, var2, var4, var5);
        }

        @Override
        public String getSerializedName() {
            return this.id;
        }

        static {
            CODEC = StringRepresentable.fromEnum(PositionSourceType::values);
        }

        @FunctionalInterface
        static interface CoordinateSource {
            public double getCoordinate(double var1, double var3, float var5, RandomSource var6);
        }
    }
}

