/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.equipment;

import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;

public record ArmorMaterial(int durability, Map<ArmorType, Integer> defense, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, TagKey<Item> repairIngredient, ResourceKey<EquipmentAsset> assetId) {
    public ItemAttributeModifiers createAttributes(ArmorType var0) {
        int var1 = this.defense.getOrDefault(var0, 0);
        ItemAttributeModifiers.Builder var2 = ItemAttributeModifiers.builder();
        EquipmentSlotGroup var3 = EquipmentSlotGroup.bySlot(var0.getSlot());
        ResourceLocation var4 = ResourceLocation.withDefaultNamespace("armor." + var0.getName());
        var2.add(Attributes.ARMOR, new AttributeModifier(var4, var1, AttributeModifier.Operation.ADD_VALUE), var3);
        var2.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(var4, this.toughness, AttributeModifier.Operation.ADD_VALUE), var3);
        if (this.knockbackResistance > 0.0f) {
            var2.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(var4, this.knockbackResistance, AttributeModifier.Operation.ADD_VALUE), var3);
        }
        return var2.build();
    }
}

